var questionsArray = [];
var chosenIndexes = [];
var tempChosenIndexes = [];
var firstGoCorrect = 0;

$(document).ready(function() {
	entryPoint();
});

//Game-specific initialization
function init(){
	disableCheckPageAnswer();
	
	$(gameXMLDOM).find('SimpleQuestionItem').each(function (index, question) {
		questionsArray.push({
			'audio': $(this).find('Audio > URL').text(),
			'image': $(this).find('Image > URL').text(),
			'question': $(this).find('Question').text(),
			'answer': $(this).find('Answer').text(),
			'chosen': true,
			'score': 0
		});
		chosenIndexes.push(index);
	});
}

//Should return the number of pages
function getPagesCount() {
	
}

//Game-specific reset procedure
function reset() {
	var tpl =
	'<div id="tabs" class="ui-tabs">' +
		'<ul>' +
			'<li role="tab"><a href="#choose-tab">Stage 1 - CHOOSE</a></li> ' +
			'<li role="tab"><a href="#learn-tab">LEARN</a></li>' +
			'<li role="tab"><a href="#remember-tab">REMEMBER</a></li>' +
			'<li role="tab"><a href="#write-tab">WRITE</a></li>' +
		'</ul>' +
		'<div id="choose-tab">' +
			'<div class="title">Choose the words to learn</div>' +
			'<div class="counter">Objects ' +
				'<span class="current">0</span> / ' +
				'<span class="total"></span>' +
			'</div>' +
			'<div class="objects"></div>' +
		'</div>' +
		'<div id="learn-tab">' +
			'<div class="counter">Objects ' +
				'<span class="current">0</span> / ' +
				'<span class="total"></span>' +
			'</div>' +
			'<div class="nav-button prev-button"></div>' +
			'<div class="learn-object">' +
				'<img class="image"/>' +
				'<div class="answer"></div>' +
				'<div class="audio"></div>' +
			'</div>' +
			'<div class="nav-button next-button active"></div>' +
		'</div>' +
		'<div id="remember-tab">' +
			'<div class="counter">Objects ' +
				'<span class="current">0</span> / ' +
				'<span class="total"></span>' +
			'</div>' +
			'<div class="nav-button prev-button inactive"></div>' +
			'<div class="remember-objects"></div>' +
			'<div class="nav-button next-button"></div>' +
		'</div>' +
		'<div id="write-tab">' +
			'<div class="counter">Objects ' +
				'<span class="current">0</span> / ' +
				'<span class="total"></span>' +
			'</div>' +
			'<div class="nav-button prev-button inactive"></div>' +
			'<div class="write-objects"></div>' +
			'<div class="nav-button next-button"></div>' +
		'</div>' +
	'</div>' +
	'<div class="skip-button button">Skip stage</div>';
	
	$('#ajax-cont').html(tpl);
	$('#ajax-cont #tabs').tabs();
	$('#ajax-cont #tabs ul li:nth-child(1) a').click();
	$('#ajax-cont #tabs ul li a').click(stageChange);
	
	$('#choose-tab .counter .total').text(questionsArray.length);
	$('#choose-tab .counter .current').text(questionsArray.length);
	var objects = '';
	$.each(questionsArray, function (qIndex, question) {
		objects += '<img class="object chosen" src="' + question.image + '" id="' + qIndex + '"/>';
	});
	$('#choose-tab .objects').html(objects);
	
	$('#choose-tab .object').on('click', function(event) {
		index = parseInt($(this).attr('id'), 10);
		if (questionsArray[index].chosen) {
			questionsArray[index].chosen = false;
			chosenIndexes.splice(chosenIndexes.indexOf(index), 1);
			$(this).removeClass('chosen');
			$('#choose-tab .counter .current').text(parseInt($('#choose-tab .counter .current').text(), 10) - 1);
		} else {
			questionsArray[index].chosen = true;
			chosenIndexes.push(index);
			$(this).addClass('chosen');
			$('#choose-tab .counter .current').text(parseInt($('#choose-tab .counter .current').text(), 10) + 1);
		}
		
		if (chosenIndexes.length === 0) {
			$('#tabs').tabs("option", "disabled", [1, 2, 3, 4]);
		} else {
			$('#tabs').tabs("option", "disabled", []);
		}
	});
	
	$('#learn-tab .next-button').click(function () { loadLearnObject(parseInt($('#learn-tab .counter .current').text(), 10)); });
	$('#learn-tab .prev-button').click(function () { loadLearnObject(parseInt($('#learn-tab .counter .current').text(), 10) - 2); });
	
	$('#remember-tab').on('click', '.next-button.active', function () { loadRememberObject(parseInt($('#remember-tab .counter .current').text(), 10)); });
	$('#remember-tab').on('click', '.prev-button.active', function () { loadRememberObject(parseInt($('#remember-tab .counter .current').text(), 10) - 2); });
	$('#remember-tab').on('click', '.image-wrap.active', onRmbImageClick);
	
	$('#write-tab').on('click', '.next-button.active', function () { loadWriteObject(parseInt($('#write-tab .counter .current').text(), 10)); });
	$('#write-tab').on('click', '.prev-button.active', function () { loadWriteObject(parseInt($('#write-tab .counter .current').text(), 10) - 2); });
	$('#write-tab').on('click', '.submit', onWriteSubmitClick);
	
	$('.skip-button').click(function () {
		$nextTab = $('#tabs .ui-state-active').next().find('a');
		$nextTab.click();
	});
}

function stageChange(event) {
	switch($(this).attr('href')) {
		case '#learn-tab':
			$('#learn-tab .counter .current').text('0');
			$('#learn-tab .counter .total').text(chosenIndexes.length);
			
			loadLearnObject(0);
			
			break;
		case '#remember-tab':
			$('#remember-tab .counter .current').text('0');
			$('#remember-tab .counter .total').text(chosenIndexes.length);
			
			firstGoCorrect = 0;
			loadRememberObjects();
			loadRememberObject(0);
			
			break;
		case '#write-tab':
			$('#write-tab .counter .current').text('0');
			$('#write-tab .counter .total').text(chosenIndexes.length);
			
			firstGoCorrect = 0;
			loadWriteObjects();
			loadWriteObject(0);
			
			break;
	}
	
	$('.skip-button').show();
	if ($(this).attr('href') === '#write-tab') {
		$('.skip-button').hide();
	}
}

function loadLearnObject(index) {
	var object = questionsArray[chosenIndexes[index]];
	
	$('#learn-tab .learn-object .image').attr('src', object.image);
	$('#learn-tab .learn-object .answer').text(object.answer);
	$('#learn-tab .learn-object .audio').replaceWith(getAudioCode(object.audio));
	processPlayer($('#learn-tab .learn-object .audio'));
	
	$('#learn-tab .nav-button').addClass('active');
	if (index === 0) {
		$('#learn-tab .prev-button').removeClass('active');
	} else if (index >= chosenIndexes.length - 1) {
		$('#learn-tab .next-button').removeClass('active');
	}
	
	$('#learn-tab .counter .current').text(index + 1);
}

function loadRememberObjects() {
	tempChosenIndexes = chosenIndexes.slice(0, chosenIndexes.length);
	
	var variants = [];
	
	$('#remember-tab .remember-object').remove();
	$.each(chosenIndexes, function(cIndex, question) {
		tempChosenIndexes.sort(function() { return Math.random() - 0.5; });
		var start = Math.max(0, tempChosenIndexes.indexOf(question) - 3);
		variants = tempChosenIndexes.slice(start, start + Math.min(4, tempChosenIndexes.length));
		var object = questionsArray[question];
		
		$question = $('<div class="remember-object"></div>');
		$.each(variants, function(vIndex, variant) {
			$question.append($(
				'<div class="image-wrap active ' + (variant === question) + '" style="background-image:url(\'' + questionsArray[variant].image + '\')">' +
					'<img class="correct" src="images/icon-correct.png"/>' +
					'<img class="incorrect" src="images/icon-incorrect.png"/>' +
				'</div>'
			));
		});
			
		$question.append($('<div class="answer">' + object.answer + '</div>'));
		$question.append(getAudioCode(object.audio));
		
		$('#remember-tab .remember-objects').append($question);
		processPlayer($question.find('.audio'));
	});
}	

function loadRememberObject(index) {
	$('#remember-tab .remember-objects .remember-object').removeClass('show');
	$('#remember-tab .remember-objects .remember-object:nth-child(' + (index + 1) + ')').addClass('show');
	$('#remember-tab .nav-button').addClass('active');
	if (index === 0) {
		$('#remember-tab .prev-button').removeClass('active');
	} else if (index >= chosenIndexes.length - 1) {
		$('#remember-tab .next-button').removeClass('active');
	}
	
	$('#remember-tab .counter .current').text(index + 1);
}

function loadWriteObjects() {
	$('#write-tab .write-object').remove();
	$.each(chosenIndexes, function(cIndex, question) {
		var object = questionsArray[question];
		
		$question = $(
			'<div class="write-object">' +
				'<img src="' + questionsArray[question].image + '" class="image"/>' +
				'<div class="input" correct="' + questionsArray[question].answer + '">' +
					'<img class="icon-correct" src="images/icon-correct.png"/>' +
					'<img class="icon-incorrect" src="images/icon-incorrect.png"/>' +
					'<input class="text" type="text"/><div class="submit button">Submit</div>' +
				'</div>' +
			'</div>');
		
		$('#write-tab .write-objects').append($question);
	});
}

function loadWriteObject(index) {
	$('#write-tab .write-objects .write-object').removeClass('show');
	$('#write-tab .write-objects .write-object:nth-child(' + (index + 1) + ')').addClass('show');
	$('#write-tab .nav-button').addClass('active');
	if (index === 0) {
		$('#write-tab .prev-button').removeClass('active');
	} else if (index >= chosenIndexes.length - 1) {
		$('#write-tab .next-button').removeClass('active');
	}
	
	$('#write-tab .counter .current').text(index + 1);
}

function onRmbImageClick(event) {
	$(this).addClass('selected');
	
	if ($(this).hasClass('true')) {
		if ($(this).siblings('.selected').length === 0) {
			firstGoCorrect ++;
		}
		$('#remember-tab .remember-object.show .image-wrap').removeClass('active');
		
		if ($('#remember-tab .remember-object .true.selected').length === chosenIndexes.length) {
			$('#gameScorePopup .content .scores').html(firstGoCorrect + ' out ouf ' + chosenIndexes.length + ' were correct on the first go!');
			openPopup('#gameScorePopup');
		}
	}
}

function onWriteSubmitClick() {
	$input = $(this).parent();
	
	$input.removeClass('correct');
	$input.removeClass('incorrect');
	
	if ($.trim($input.find('.text').val().toLowerCase()) === $input.attr('correct')) {
		if ($input.hasClass('incorrect') && !$input.hasClass('correct')) {
			$input.removeClass('incorrect');
		} else {
			firstGoCorrect ++;
		}
		
		$input.addClass('correct');
		
		if ($('#write-tab .input.correct').length === chosenIndexes.length) {
			$('#gameScorePopup .content .scores').html(firstGoCorrect + ' out ouf ' + chosenIndexes.length + ' were correct on the first go!');
			openPopup('#gameScorePopup');
		}
	} else {
		$input.addClass('incorrect');
	}
}

//If there are several pages, page loading handler
function getPage(pageNumber){
	
}

//When Check Answers button is pressed
function onCheckPageAnswer() {
	
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$.each(questionsArray, function (qIndex, question) {
		questions.push('<img style="width: 100px" src="' + question.image + '"/>');
		$input = $('.write-objects .write-object:nth-child(' + (qIndex + 1) + ') .input');
		var answer = $input.find('input').val();
		if (answer === undefined || answer === '') {
			answer = '___';
		}
		answers.push(answer);
		corrects.push(question.answer);
		
		if ($input.hasClass('correct')) {
			points.push(1);
			gamePoints++;
		} else {
			points.push(0);
		}
		
		totals.push(1);
		gameTotal ++;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}

//Audio file, if available
function getAudio() {
	return '';
}