var pageIndex;
var pages = [];

$(document).ready(function() {
	entryPoint();
});

// starts everything
function init(){
	$("#sortable")
		.sortable({
			placeholder: "ui-state-highlight"
		})
		.disableSelection();
	
	$(gameXMLDOM).find('OrderedQuestionItems').each(function (qIndex, question) {
		var cards = [];
		$(question).find('OrderedQuestionItem').each(function(cardIndex, card) {
			cards.push({ text: $(card).text(), correct: cardIndex });
		});
		
		pages.push({ cards: cards, audio: $(question).find('Audio > URL').text() });
	});
}

function getPage(pageNumber) {
	pageIndex = pageNumber;
	$('.question').hide();
	$('.question:nth-child(' + (pageNumber + 1) + ')').show();
}

function getPagesCount() {
	return pages.length;
}

function getAudio () {
	return pages[pageIndex].audio;
}

function reset() {
	$('.question').remove();
	
	$.each(pages, function (pIndex, page) {
		var cards = pages[pIndex].cards.slice();
		cards.sort(function() { return Math.random() - 0.5; });
		$question = $('<div class="question"></div>');
		$pile = $('<ul id="sortable"></ul>');
		$.each(cards, function (cIndex, card) {
			$pile.append($('<li class="ui-state-default" id=' + card.correct + '>' + card.text + '<img id="incorrect-icon" src="images/icon-incorrect.png" /><img id="correct-icon" src="images/icon-correct.png"/></li>'));
		});
		$question.append($pile);
		$('#ajax-questions').append($question);
		
		$('#ajax-questions .question:nth-child(' + (pIndex + 1) + ') #sortable').sortable({
			placeholder: "ui-state-highlight"
		}).disableSelection();
	});
	
	
	$('.question').hide();
}

function onCheckPageAnswer(page){
	if (typeof(page) !== 'number') {
		page = pageIndex;
	}
	
	$('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable li').removeClass('incorrect');
	$('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable li').removeClass('correct');
	
	$('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable li').each(function (index) {
		if (parseInt($(this).attr('id'), 10) !== index) {
			$(this).addClass('incorrect');
		} else {
			$(this).addClass('correct');
		}
	});
	$('#ajax-questions #sortable').addClass('show');
}

function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#ajax-questions .question').each(function(qIndex, question) {
		var answer = '';
		var qPoints = 0, qTotal = 0;
		
		questions.push('');
		
		$(question).find('#sortable li').each(function(lIndex, item) {
			answer += '<li>' + $(item).text() + '</li>';
			if ($(item).hasClass('correct')) {
				qPoints ++;
			}
			qTotal ++;
		});
		answers.push('<ul>' + answer + '</ul>');
		
		var correct = '';
		$.each(pages[qIndex].cards, function (cIndex, card) {
			correct += '<li>' + card.text + '</li>';
		});
		corrects.push('<ul>' + correct + '</ul>');
		
		points.push(qPoints);
		totals.push(qTotal);
		gamePoints += qPoints;
		gameTotal += qTotal;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}