/**
 * Core functions
 * 
 * To create a new game, copy the contents of GameTemplate.js and fill in the functions
 */

var gameXML = '';
var gameType = '';
var gameTitle = '';
var gameDescription = '';
var gameClues = '';
var gameInstructions = '';
var gameTestMin = "";
var gameXMLDOM;
var gameShowQuestionNo = "true";
var gameDisplayOptions = 0;
var gameNoCorrectAnswers = 0;
var fn;
var playerId = 0;

/**
 * Load XML Data and parsing
 *
 * @param xmlurl
 *   URL of the XML file.
 * @param gametype
 *   Root XML element name of the XML.
 * @param callbackFunc
 *   A callback function.
 */
function entryPoint() {
	console.log('Game init()');
	closeGameInstructionsPopup();
	closeGameCluesPopup();
	closeGameFinishPopup();
	closeGameScorePopup();
	
	jQuery('#jparse-meta').html('<img alt="Content Loading" src="images/ajax-loader.gif" />');
	alert('here1');
//	$.ajax({
//		type: "GET",
//		url: xmlData,
//		dataType: "xml",
//		success: function (data) {
data='<?xml version="1.0"?>
<MatchingGame gameType="MATCHING" skinType="default" showInstructionsWhenStartUp="true">
  <GameTitle>April Fool story vocab</GameTitle>
  <Clues>There are no clues for this activity.</Clues>
  <Instructions>Match the words and phrases at the top with their definitions.</Instructions>
  <EndingText/>
  <Introduction>
    <Text/>
  </Introduction>
  <SimpleQuestionItems numCol="0" optionsPanelNumCol="0">
    <SimpleQuestionItem>
      <Question>believing that you are better or more important than other people</Question>
      <Answer>arrogant</Answer>
    </SimpleQuestionItem>
    <SimpleQuestionItem>
      <Question>successful person</Question>
      <Answer>achiever</Answer>
    </SimpleQuestionItem>
    <SimpleQuestionItem>
      <Question>a machine controlled by a computer, which can do things that people can do</Question>
      <Answer>robot</Answer>
    </SimpleQuestionItem>
    <SimpleQuestionItem>
      <Question>a fact that a lot of people are talking about although they do not know if it is true</Question>
      <Answer>rumour</Answer>
    </SimpleQuestionItem>
    <SimpleQuestionItem>
      <Question>something you do to deceive or cheat someone, or to make someone look stupid as a joke</Question>
      <Answer>trick</Answer>
    </SimpleQuestionItem>
    <SimpleQuestionItem>
      <Question>to invent something, such as an excuse or a story, often in order to deceive</Question>
      <Answer>make something up</Answer>
    </SimpleQuestionItem>
    <SimpleQuestionItem>
      <Question>someone who says things that are not true</Question>
      <Answer>liar</Answer>
    </SimpleQuestionItem>
  </SimpleQuestionItems>
  <QuestionTitle/>
  <AnswerTitle/>
<GameSkin skinType="default">
  <Assets>
    <Asset>assets_default.swf</Asset>
  </Assets>
  <Styles>
    <Style selector=".classGameWrapper">
      <cornerRadius>8</cornerRadius>
      <backgroundColor>#F1F1F1</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
      <color>#000000</color>
      <fontWeight>normal</fontWeight>
    </Style>
    <Style selector=".classGameHeader">
      <fillColors>#959595</fillColors>
      <colorsConfiguration>1</colorsConfiguration>
      <topLeftRadius>8</topLeftRadius>
      <topRightRadius>8</topRightRadius>
      <borderThickness>0</borderThickness>
      <fillAlphas>1</fillAlphas>
    </Style>
    <Style selector=".classGameHeaderMainLogo">
      <backgroundColor>#FFFFFF</backgroundColor>
    </Style>
    <Style selector=".classGameTitle">
      <color>#FFFFFF</color>
    </Style>
    <Style selector=".classGameCopyright">
      <paddingTop>2</paddingTop>
      <color>#000000</color>
      <copyright>&#xA9; British Council</copyright>
      <URL></URL>
      <urlLabel/>
    </Style>

    <Style selector=".gameTextArea">
      <themeColor>#454545</themeColor>
    </Style>
    <Style selector=".itemContainer">
      <cornerRadius>4</cornerRadius>
      <backgroundColor>#E8F0D7</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
    </Style>
    <Style selector=".itemContainerOver">
      <cornerRadius>4</cornerRadius>
      <backgroundColor>#C7E783</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
    </Style>
    <Style selector=".itemContainerDrag">
      <cornerRadius>4</cornerRadius>
      <backgroundColor>#999999</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
    </Style>
    <Style selector=".itemContainerCorrectAnswer">
      <cornerRadius>4</cornerRadius>
      <backgroundColor>#116913</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
    </Style>
    <Style selector=".questionContainer">
      <cornerRadius>8</cornerRadius>
      <backgroundColor>#FFFFFF</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
      <color>#000000</color>
    </Style>
    <Style selector=".questionContainerFeedback">
      <cornerRadius>8</cornerRadius>
      <backgroundColor>#999999</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
    </Style>
    <Style selector=".questionContainerFeedbackOver">
      <cornerRadius>8</cornerRadius>
      <backgroundColor>#999999</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderThickness>1</borderThickness>
      <borderColor>#000000</borderColor>
    </Style>
    <Style selector=".itemSubContainer">
      <cornerRadius>4</cornerRadius>
      <backgroundColor>#F1F5E7</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
    </Style>
    <Style selector=".questionNumber">
      <fontWeight>bold</fontWeight>
      <color>#000000</color>
    </Style>
    <Style selector=".normalText">
      <color>#000000</color>
    </Style>
    <Style selector=".orderNumber">
      <paddingTop>3</paddingTop>
      <paddingBottom>0</paddingBottom>
      <paddingLeft>0</paddingLeft>
      <paddingRight>0</paddingRight>
      <glow-filter>false</glow-filter>
    </Style>
    <Style selector=".gapFillTextInput">
      <textAlign>center</textAlign>
      <borderStyle>solid</borderStyle>
      <borderThickness>1</borderThickness>
      <cornerRadius>3</cornerRadius>
    </Style>
    <Style selector=".classGameInfoPanel">
      <cornerRadius>8</cornerRadius>
      <backgroundColor>#669900</backgroundColor>
      <borderStyle>solid</borderStyle>
      <borderColor>#000000</borderColor>
      <borderThickness>1</borderThickness>
      <color>#FFFFFF</color>
      <fontWeight>normal</fontWeight>
    </Style>
    <Style selector=".gameInfoPanelTitle">
      <fontWeight>bold</fontWeight>
    </Style>
    <Style selector=".dragAndDropDestination">
      <borderStyle>solid</borderStyle>
      <borderThickness>1</borderThickness>
      <borderColor>#CCCCCC</borderColor>
      <cornerRadius>5</cornerRadius>
    </Style>
    <Style selector=".classGameHeaderSiteLogo">
      <siteLogo/>
      <backgroundColor>#FFFFFF</backgroundColor>
    </Style>
    <Style selector=".pageIconButtonUp">
      <color>#FFFFFF</color>
      <fillColors>0x063C00,0x157B15</fillColors>
      <colorsConfiguration>2</colorsConfiguration>
      <fillAlphas>1,1</fillAlphas>
      <cornerRadius>5</cornerRadius>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
      <gradientRatio>0,255</gradientRatio>
      <angle>90</angle>
    </Style>
    <Style selector=".pageIconButtonOver">
      <color>#FFFFFF</color>
      <fillColors>0x157B15,0x157B15</fillColors>
      <colorsConfiguration>2</colorsConfiguration>
      <fillAlphas>1,1</fillAlphas>
      <cornerRadius>5</cornerRadius>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
      <gradientRatio>0,255</gradientRatio>
      <angle>90</angle>
    </Style>
    <Style selector=".pageIconButtonCurrent">
      <color>#FFFFFF</color>
      <fillColors>0x540101,0x9F2424</fillColors>
      <colorsConfiguration>2</colorsConfiguration>
      <fillAlphas>1,1</fillAlphas>
      <cornerRadius>5</cornerRadius>
      <borderStyle>solid</borderStyle>
      <borderThickness>0</borderThickness>
      <gradientRatio>0,255</gradientRatio>
      <angle>90</angle>
    </Style>
    <Style selector=".classGamePageIconArrowUp">
      <backgroundColor>#FFFFFF</backgroundColor>
    </Style>
    <Style selector=".classGamePageIconArrowOver">
      <backgroundColor>#FFFFFF</backgroundColor>
    </Style>
    <Style selector=".classGameInterfaceButtonUp">
      <color>#000000</color>
      <fillColors>0x8C8C8C,0xE1E1E1</fillColors>
    </Style>
    <Style selector=".classGameInterfaceButtonOver">
      <color>#000000</color>
      <fillColors>0x8C8C8C,0xE1E1E1</fillColors>
    </Style>
    <Style selector=".classGameInterfaceSoundToggleButtonUp">
      <backgroundColor>#000000</backgroundColor>
    </Style>
    <Style selector=".classGameInterfaceSoundToggleButtonOver">
      <backgroundColor>#000000</backgroundColor>
    </Style>
    <Style selector=".classGameDialogButtonUp">
      <color>#FFFFFF</color>
      <fillColors>0x116913,0x005B03</fillColors>
    </Style>
    <Style selector=".classGameDialogButtonOver">
      <color>#FFFFFF</color>
      <fillColors>0x017E01,0x017E01</fillColors>
    </Style>
  </Styles>
</GameSkin></MatchingGame>
';
			parseGameXMLParameters(data);
			init();
			var pagesCount = getPagesCount();
			if (pagesCount > 1) {
				for (var i = 1; i <= pagesCount; i++) {
					$('#ajax-pages').append('<a id="' + i + '" class="pageButton" onclick="onPageClick(this.id)">' + i + '</a>');
				}
			}
			onReset();
//		}
//	});
	alert('here2');
	$('body').on('click', '#instructionsButton', onInstructions);
	$('body').on('click', '#checkAnswerButton:not(.disabled)', onCheckPageAnswer);
	$('body').on('click', '#finishButton', onFinish);
	$('body').on('click', '.play-btn', function(event) {
		if ($(this).hasClass('playing')) {
			$(this).removeClass('playing');
			document.getElementById($(event.target).siblings('.html-audio').attr('id')).pause();
		} else {
			$(this).addClass('playing');
			document.getElementById($(event.target).siblings('.html-audio').attr('id')).play();
		}
	});
}

function parseGameXMLParameters(xml) { 
	console.log('Parsing xml for general game data - ' + gameXML);
	alert('Parsing xml for general game data - ' + gameXML);

	gameXMLDOM = eval(xml);
	
	gameTitle = $(xml).find('GameTitle').text();
	gameClues = $(xml).find('Clues').text();
	gameClues = gameClues.replace(/\n/g, '<br/>');
	if (gameClues !== undefined && gameClues !== '') {
		$('#gameCluesText').html(gameClues);
	}

	gameInstructions = $(xml).find('Instructions').text();
	gameInstructions = gameInstructions.replace(/\n/g, '<br/>');
	if (gameInstructions !== undefined && gameInstructions !== '') {
		$('#gameInstructionsText').html(gameInstructions);
		$('#gameInstructionsText2').html(gameInstructions);
	}

	gameDescription = $(xml).find('Description').text();
	gameTestMin = $(xml).find('TestMin').text();
	gameShowQuestionNo = $(xml).find('ShowQuestionNo').text();
	var option = $(xml).find('DisplayOption').text();
	if (option === 'One Question Per Page') {
		gameDisplayOptions = 0;
	} else if (option === 'All Question On One Page') {
		gameDisplayOptions = 1;
	}
	
	if ($(xml).find('[noCorrectAnswer="true"]').length > 0 ||
		$(xml).find('NoCorrectAnswer').length > 0) {
		gameNoCorrectAnswers = 1;
		disableCheckPageAnswer();
	}
	
	$('#ajax-cont').html('<div class="feed-entry"> <h4>' + gameTitle + '</h4></div>');
}

function onGameStart(){
	if (gameTestMin !== "") {
		setTimeout(onTimeOut, parseInt(gameTestMin * 60 * 1000, 10));
	}
}

function onTimeOut () {
	openPopup('#gameTimeOutPopup');
}

function onReset(){
	$('#jparse-meta').remove();
	$('#answers').remove();
	closeGameInstructionsPopup();
	closeGameCluesPopup();
	closeGameFinishPopup();
	closeGameScorePopup();
	reset();
	
	onPageClick("1");
	
	if (gameInstructions !== undefined && gameInstructions !== '') {
		openPopup('#gameStartPopup');
	}
}

function onPageClick(id){
	$('#answers').remove();
	$('#ajax-pages a').removeClass('active');
	$('#ajax-pages a[id="' + id + '"]').addClass('active');
	getPage(parseInt(id, 10) - 1);
	
	$('.control .audio').remove();
	var audio = getAudio();
	if (audio !== undefined && audio !== '' ) {
		var audioStr = getAudioCode(audio);
		$('.control').append($(audioStr));
		processPlayer($('.control .audio'));
	}
}

function openPopup(id) {
	$(id).fadeIn("fast");
	$('#popup-overlay').fadeIn("fast");
}

function closePopup(id) {
	$(id).fadeOut("fast");
	$('#popup-overlay').fadeOut("fast");
}

function onHelp(){
	openPopup('#gameCluesPopup');
}

function onInstructions(event){
	openPopup('#gameInstructionsPopup');
}

function onFinish(){
	openPopup('#gameFinishPopup');
}

function onScore(){
	openPopup('#gameScorePopup');
}

function onConfirmedFinish(){
	var pages = getPagesCount();
	for (var i = 0; i < pages; i++) {
		onCheckPageAnswer(i);
	}
	
	closeGameFinishPopup();
	var score = getScore();
	
	var table = '';
			
	$.each(score.questions, function(qIndex, question) {
		table +=
			'<tr><td class="index-td"><span class="result-index">' + (qIndex + 1) + '.</span></td>';
		
		table += '<td>';
		if (question !== '') {
			table += '<div class="result-original">' + question + '</div>';
		}
		
		table += '<div class="result-answer">Your answer: ' + score.answers[qIndex] + '</div>';
		
		if (score.points[qIndex] !== score.totals[qIndex] &&
			gameNoCorrectAnswers !== 1) {
			table +=
				'<div class="result-correct">Correct answer: ' + score.corrects[qIndex] + '</div>';
		}
		
		table +=
			'</td>' +
			'<td><div class="result-score">' + score.points[qIndex] + ' out of ' + score.totals[qIndex] + '</div></td>' +
		'</tr>';
	});
	
	var percentage = Math.round(score.gamePoints * 100 / score.gameTotal);
	
	var noCorrectMessage = '';
	if (gameNoCorrectAnswers) {
		noCorrectMessage = '(There are no correct answers for this exercise)';
	}
	
	tableOut =
		'<table><tbody>' +
			'<tr>' +
				'<th colspan="2">Total score is ' + score.gamePoints + ' out of ' + score.gameTotal + ' (' + percentage + '%) ' + noCorrectMessage + '</th>' +
				'<th>Your answer</th>' +
			'</tr>' +
			table +
		'</tbody></table>';
	
	$('#gameScorePopup .content .scores').html(tableOut);
	
	openPopup('#gameScorePopup');
	
	saveScore(percentage);
}

function closeGameStartPopup(){
	closePopup('#gameStartPopup');
	onGameStart();
}

function closeGameInstructionsPopup(){
	closePopup('#gameInstructionsPopup');
}

function closeGameCluesPopup(){
	closePopup('#gameCluesPopup');
}

function closeGameFinishPopup(){
	closePopup('#gameFinishPopup');
}

function closeGameScorePopup(){
	closePopup('#gameScorePopup');
}

function closeGameTimeOutPopup() {
	closePopup('#gameTimeOutPopup');
	onConfirmedFinish();
}

/**
 * a helper function to get the key value from URL parameter http://example.com?key=value
 */
function getParameterByName(name) {
	name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
	var regexS = "[\\?&]" + name + "=([^&#]*)";
	var regex = new RegExp(regexS);
	var results = regex.exec(window.location.search);
	if(results == null) {
		return "";
	} else {
		return decodeURIComponent(results[1].replace(/\+/g, " "));
	}
}

/**
 * a helper function to get the game type from URL
 */
function getGameType(xmldata) { 
	var flashname = xmldata.split("/");
	flashname = flashname[flashname.length-1];
	flashname = flashname.split(".");
	flashname = flashname[0].split("_");
	return flashname[0];
}

// If an audio player is needed in the game, its code can be added with this function, 
// argument 'mp3' is the audio url. After adding, processPlayer has to be called to replace the player with a flash version, if necessary
function getAudioCode(mp3) {
	return '' +
		'<div class="audio" source="' + mp3 + '">' +
			'<audio class="html-audio" id="html-player' + playerId + '" onEnded="onAudioEnded(event)">' +
				'<source src="' + mp3 + '" type="audio/mp3"/>' +
			'</audio>' +
			'<div class="play-btn"></div>' +
			'<div class="player-wrap">' +
				'<div class="player" id="flash-player' + playerId++ + '">' +
				'</div>' +
			'</div>' +
		'</div>';
}

function processPlayer(player) {
	if (!document.createElement('audio').canPlayType ||
		!document.createElement('audio').canPlayType('audio/mpeg'))
	{
		player.find('.player-wrap').show();
		player.find('.play-btn').hide();
		
		swfobject.embedSWF(
			"js/dewplayer-mini.swf", 
			player.find('.player').attr('id'), 
			"38",
			"20",
			"9.0.0", 
			"", 
			{"mp3": player.attr('source')},
			{"wmode": "transparent"}
		);
	}
}

function onAudioEnded(event) {
	//$(event.target).siblings('.play-btn').removeClass('playing');
}

//If the game does not support checking of the answers, the check answers button can be disabled
function disableCheckPageAnswer() {
	$('.btn-name-check-ans').addClass('disabled');
}



