var GapFillDragAndDrop = function(container){
	this.pages;
	this.pageIndex;
	this.gameDisplayOptions = 0;
	this.container = container;
	this.gameXMLDOM;
}

GapFillDragAndDrop.prototype.init = function(gameXMLDOM){
	console.log('init GapFillDragAndDrop');
	this.gameXMLDOM = gameXMLDOM;
	var obj = this;
	this.container.find('#ajax-cont').append('<div id="cardPile"></div><div id="cardSlots"></div>');
	this.container.find('#cardPile').droppable({
		accept: '.card',
		tolerance: 'intersect',
		greedy : true,
		drop: function (even,ui) {
			console.log('drop from init func');
			ui.draggable.draggable( 'option', 'revert', false );
			obj.container.find('#cardSlots .question:nth-child(' + (obj.pageIndex + 1) + ') .slot[card="' + ui.draggable.attr('id') + '"]').attr('card', '');
		},
		out: obj.handleCardOut,
		hoverClass: 'hovered'
	});

	this.pages = [];
	
	if (this.gameDisplayOptions === 0) {
		$(this.gameXMLDOM).find('GapFillAssembledQuestionItem').each(function(qIndex, question) {
			var prefixesArray = [];
			var answersArray = [];
			var suffixesArray = [];
	
			$(question).find('GapFillQuestionItem').each(function(index, subquestion) {
				prefixesArray.push($(subquestion).find('Prefix').text());
				answersArray.push({
					text: $(subquestion).find('Answer').text(),
					correct: index
				});
				suffixesArray.push($(subquestion).find('Suffix').text());
			});
	
			obj.pages.push({
				'prefixes': prefixesArray,
				'answers': answersArray,
				'suffixes': suffixesArray,
				'audio': $(question).find('Audio > URL').text()
			});
		});
	} else {
		var prefixesArray = [];
		var answersArray = [];
		var suffixesArray = [];
		
		$(obj.gameXMLDOM).find('GapFillQuestionItem').each(function(qIndex, question) {
			prefixesArray.push($(question).find('Prefix').text());
			answersArray.push({
				text: $(question).find('Answer').text(),
				correct: qIndex
			});
			suffixesArray.push($(question).find('Suffix').text());
		});

		console.log(answersArray.length);
		if(answersArray.length > 12){
			this.container.addClass('reducelineheight');
		}
		
		obj.pages.push({
			'prefixes': prefixesArray,
			'answers': answersArray,
			'suffixes': suffixesArray,
			'audio': $(gameXMLDOM).find('Audio > URL').text()
		});
	}
}

GapFillDragAndDrop.prototype.getPage = function(pageNumber){
	this.pageIndex = pageNumber;
	this.container.find('#cardPile .question').hide();
	this.container.find('#cardPile .question:nth-child(' + (pageNumber + 1) + ')').show();
	this.container.find('#cardSlots .question').hide();
	this.container.find('#cardSlots .question:nth-child(' + (pageNumber + 1) + ')').show();
}

GapFillDragAndDrop.prototype.getAudio = function() {
	return this.pages[this.pageIndex].audio;
}

GapFillDragAndDrop.prototype.getPagesCount = function() {
	return this.pages.length;
}

GapFillDragAndDrop.prototype.onCheckPageAnswer = function(page){ 
	if (typeof(page) !== 'number'){
		page = this.pageIndex;
	}
	
	this.container.find('#cardSlots .question:nth-child(' + (page + 1) + ') .slot').each(function () {
		$(this).parent().removeClass( 'correct incorrect' );
		if ($(this).attr('card') === $(this).attr('id')) {
			$(this).parent().addClass( 'correct' );
		} else {
			$(this).parent().addClass( 'incorrect' );
		}
		$(this).parent().addClass('show');
	});
}

GapFillDragAndDrop.prototype.reset = function(){
	// Create the pile of shuffled cards
	this.container.find('#cardPile').empty();
	this.container.find('#cardSlots').empty();
	var obj = this;
	$.each(this.pages, function(pIndex, page) {
		page.answers.sort(function() { return Math.random() - 0.5; });
		var $question = $('<div class="question"></div>');

		$.each(page.answers, function (index, item) {
			$('<div class="card" id="' + item.correct + '">' + item.text + '</div>').appendTo($question).draggable({
				stack: '#cardPile',
				cursor: 'move',
				revert: true,
				scrollSensitivity: 1
			});
		});
		obj.container.find('#cardPile').append($question);
	
		$question = $('<div class="question"></div>');
		$.each(page.prefixes, function (index, prefix) {
			var $subQuestion = $(
				'<div class="subquestion">' +
					(index + 1) + '. ' + prefix +
					'<span class="slot-wrap">' +
						'<div class="slot" id="' + index + '">&nbsp;</div>' +
						'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
						'<img id="correct-icon" src="images/icon-correct.png"/>' +
					'</span>' +
					page.suffixes[index] +
				'</div>');
			$subQuestion.find('.slot').droppable({
				accept: '.card',
				hoverClass: 'hovered',
				tolerance: 'intersect',
				greedy : true,
				drop: function(event, ui){
					console.log('drop detected');
				}
			});
			$subQuestion.find('.slot').on('drop', {gameid:obj}, obj.handleCardDrop);
			$subQuestion.find('.slot').on('out', obj.handleCardOut);
			$question.append($subQuestion);
		});
		obj.container.find('#cardSlots').append($question);
	});

	obj.container.find('#gameStartPopup').show();
	obj.container.find('#gameStartPopup').animate( {
		left: '380px',
		top: '200px',
		width: '400px',
		height: '100px',
		opacity: 1
	});
}

GapFillDragAndDrop.prototype.handleCardDrop = function( event, ui ) {
	var obj = event.data.gameid;
	if ($(this).attr('card') === '' || $(this).attr('card') === undefined) {
		obj.container.find('#cardSlots .question:nth-child(' + (obj.pageIndex + 1) + ') .slot[card="' + ui.draggable.attr('id') + '"]').attr('card', '');
		$(this).attr('card', ui.draggable.attr('id'));

		ui.draggable.draggable( 'option', 'revert', false );
		$(this).width(ui.draggable.outerWidth());


		$(this).append(ui.draggable);
		ui.draggable.position({ of: $(this), my: 'center center', at: 'center center' });

		var appendTarget = $(this).parent().parent().parent().parent().prev('#cardPile').first();
		console.log(appendTarget);

		ui.draggable.draggable({
			helper: function(){
				return $(this).clone().width($(this).outerWidth(true));
			},
			greedy: true,
			appendTo: appendTarget,
			start: function(){
				$(this).css({opacity:0});
			},
			stop: function(){
				$(this).css({opacity:1});	
			}
		});

	}
}

GapFillDragAndDrop.prototype.handleCardOut = function(event, ui) {
	ui.draggable.draggable( 'option', 'revert', true );
}

GapFillDragAndDrop.prototype.getScore = function() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	var obj = this;
	$.each(this.pages, function(pIndex, page) {
		questions.push('');
		var answer = '<br/>';
		var correct = '<br/>';
		var qPoints = 0;
		var qTotal = 0;
		obj.container.find('#cardSlots .question:nth-child(' + (pIndex + 1) + ') .slot').each(function(sIndex, slot) {
			var input = obj.container.find('#cardPile .question:nth-child(' + (pIndex + 1) + ') .card[id="' + $(slot).attr('card') + '"]').text();
			if (input === '') {
				input = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
			}
			answer += 
				(sIndex + 1) + '. ' + 
				page.prefixes[sIndex] + 
				' <u>' + input + '</u> ' +
				page.suffixes[sIndex] + '<br/>';
			correct += 
				(sIndex + 1) + '. ' + 
				page.prefixes[sIndex] +
				' <u>' + obj.container.find('#cardPile .question:nth-child(' + (pIndex + 1) + ') .card[id="' + sIndex + '"]').text() + '</u> ' +
				page.suffixes[sIndex] + '<br/>';
			
			if ($(slot).parent().hasClass('correct')) {
				qPoints ++;
				gamePoints ++;
			}

			qTotal ++;
			gameTotal++;
		});

		answers.push(answer);
		corrects.push(correct);
		points.push(qPoints);
		totals.push(qTotal);
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}