var Grouping = function(container){
	this.questionsArray = [];
	this.cardsArray = [];
	this.gameDisplayOptions = 0;
	this.container = container;
	this.gameXMLDOM;
}


//Game-specific initialization
Grouping.prototype.init = function(gameXMLDOM){
	console.log('init Grouping');
	var self = this;
	self.gameXMLDOM = gameXMLDOM;
	self.container.find('#ajax-cont').html('<div id="cardPile"> </div><div id="questions"> </div>');
	self.container.find('#cardPile').droppable({
		accept: '.card',
		drop: function (even,ui) { 
			ui.draggable.draggable( 'option', 'revert', false );
			$slot = $('.slot[card="' + ui.draggable.text() + '"]');
			$slot.attr('card', '');
			$slot.parent().removeClass('correct incorrect show');
		},
		out: self.handleCardOut,
		hoverClass: 'hovered'
	});

	$(self.gameXMLDOM).find('MultipleAnswerQuestionItem').each(function (qIndex, question) {
		var answers = [];
		$(question).find('Answer').each(function(aIndex, answer) {
			answers.push($(answer).text());
			self.cardsArray.push({
				text: $(answer).text(),
				audio: $(answer).attr('url')
			});
		});
		self.questionsArray.push({
			'question': $(question).find('Question').text(),
			'answers': answers
		});
	});
}

//Should return the number of pages
Grouping.prototype.getPagesCount = function() {
	return 1;
}

//Game-specific reset procedure
Grouping.prototype.reset = function() {
	var self = this;
	self.container.find('#cardPile').html( '' );
	self.container.find('#questions').html( '' );

	self.cardsArray.sort( function() { return Math.random() - 0.5; } );
	$.each(self.cardsArray, function (cIndex, card) {
		self.container.find('#cardPile').append('<div class="card">' + card.text + '</div>');
		if (card.audio !== undefined) {
			self.container.find('#cardPile .card:nth-child(' + (cIndex + 1) + ')').append($(getAudioCode(card.audio)));
			processPlayer(self.container.find('#cardPile .card:nth-child(' + (cIndex + 1) + ') .audio'));
		}
		self.container.find('#cardPile .card:nth-child(' + (cIndex + 1) + ')').draggable({
			stack: '#cardPile div',
			cursor: 'move',
			revert: true,
			cancel: '.audio'
		});
	});
	
	$.each(self.questionsArray, function (qIndex, question) {
		var answers = '';
		$.each(question.answers, function(aIndex, answer) {
			answers += '<div class="slot-wrap"><div class="slot" card></div><img id="incorrect-icon" src="images/icon-incorrect.png"/><img id="correct-icon" src="images/icon-correct.png"/></div>';
		});
	
		var $newQuestion = $('<div class="question" id="' + qIndex + '">' + question.question + answers + '</div>');
		$newQuestion.find('.slot').droppable({
			accept: '.card',
			hoverClass: 'hovered'
		});
		$newQuestion.find('.slot').on('drop', {gameid:self}, self.handleCardDrop);
		$newQuestion.find('.slot').on('out', self.handleCardOut);
		self.container.find('#questions').append($newQuestion);
	});
}

Grouping.prototype.handleCardDrop = function( event, ui ) {
	var self = event.data.gameid;
	if ($(this).attr('card') === '' || $(this).attr('card') === undefined) {
		$slot = self.container.find('.slot[card="' + ui.draggable.text() + '"]');
		$slot.attr('card', '');
		$slot.parent().removeClass('correct incorrect show');
		$(this).attr('card', ui.draggable.text());
		
		ui.draggable.draggable( 'option', 'revert', false );
		ui.draggable.position({ of: $(this), my: 'center center', at: 'center center' });
	}
}

Grouping.prototype.handleCardOut = function(event, ui) {
	ui.draggable.draggable( 'option', 'revert', true );
}

//If there are several pages, page loading handler
Grouping.prototype.getPage = function(pageNumber){
	
}

//When Check Answers button is pressed
Grouping.prototype.onCheckPageAnswer = function() {
	var self = this;
	self.container.find('.slot[card!=""]').each(function () {
		$(this).parent().removeClass('correct incorrect');
		if ($.inArray($(this).attr('card'), self.questionsArray[parseInt($(this).closest('.question').attr('id'), 10)].answers) !== -1) {
			$(this).parent().addClass( 'correct' );
		} else {
			$(this).parent().addClass( 'incorrect' );
		}
	});
	self.container.find('.slot-wrap.correct').addClass('show');
	self.container.find('.slot-wrap.incorrect').addClass('show');
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
Grouping.prototype.getScore = function() {
	var self = this;
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	self.container.find('#questions .question').each(function (qIndex, question) {
		var answer = '';
		var qPoints = 0;
		var qTotal = 0;
		
		questions.push(self.questionsArray[qIndex].question);
		
		$(question).find('.slot-wrap').each(function(sIndex, slotWrap) {
			var card = $(slotWrap).find('.slot').attr('card');
			if (card !== undefined) {
				answer += '<li>' + card + '</li>';
			}
			
			if ($(slotWrap).hasClass('correct')) {
				qPoints++;
				gamePoints ++;
			}
			qTotal++;
			gameTotal++;
		});
		answers.push('<ul>' + answer + '</ul>');
		
		var correct = '';
		$.each(self.questionsArray[qIndex].answers, function(aIndex, answer) {
			correct += '<li>' + answer + '</li>';
		});
		corrects.push('<ul>' + correct + '</ul>');
		
		points.push(qPoints);
		totals.push(qTotal);
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}

//Audio file, if available
Grouping.prototype.getAudio = function() {
        return $(self.gameXMLDOM).find('Audio > URL').text();
}