var Matching = function(container){
	this.answersArray;
	this.questionsArray;
	this.questionsCount;
	this.pageIndex;
	this.correctCards = 0;
	this.gameDisplayOptions = 0;
	this.container = container;
	this.gameXMLDOM;
}

Matching.prototype.init = function(gameXMLDOM){
	console.log('init Matching');
	var self = this;
	this.gameXMLDOM = gameXMLDOM;
	this.container.find('#ajax-cont').html('<div id="cardPile"> </div><div id="cardSlots"> </div>');
	this.container.find('#cardPile').droppable({
		accept: '.card',
		drop: function (even,ui) { 
			ui.draggable.draggable( 'option', 'revert', false );
			$('#cardSlots .slot[card="' + ui.draggable.attr('id') + '"]').attr('card', '');
		},
		out: self.handleCardOut,
		hoverClass: 'hovered'
	});
	
	this.container.find('#ajax-questions').html('<ul id="nonsortable"></ul>');

	this.answersArray = [];
	this.questionsArray = [];
	this.questionsCount = 0;
	this.answersCount = 0;
	var obj = this;
	$(this.gameXMLDOM).find('Question').each(function (index, item) {
		obj.questionsArray.push({ text: $(item).text(), correct: index });
	});
	
	$(this.gameXMLDOM).find('Answer').each(function (index, item) {
		obj.answersArray.push({ text: $(item).text(), correct: index });
	});
}

Matching.prototype.getPagesCount = function() {
	return 1;
}

Matching.prototype.getAudio = function() {
	return '';
}

Matching.prototype.getPage = function(pageNumber){
	
}

Matching.prototype.onCheckPageAnswer = function() {
	this.container.find('#cardSlots .slot').each(function(sIndex, slot) {
		if ( $(slot).attr( 'correct' ) === $(slot).attr('card') ) {
			$(this).addClass( 'correct' );
			$(this).removeClass( 'incorrect' );
		} else {
			$(this).addClass( 'incorrect' );
			$(this).removeClass( 'correct' );
		}
		$(slot).addClass('show');
	});
}

Matching.prototype.reset = function() {
	// Reset the game
	this.container.find('#cardPile').html( '' );
	this.container.find('#cardSlots').html( '' );

	// Create the pile of shuffled cards
	this.answersArray.sort(function() { return Math.random() - 0.5; });
	var cardPile = this.container.find('#cardPile').first();
	var cardSlots = this.container.find('#cardSlots').first();
	for ( var i=0; i<this.answersArray.length; i++ ) {
		$('<div class="card" id="' + this.answersArray[i].correct + '">' + this.answersArray[i].text + '</div>').appendTo( $(cardPile) ).draggable( {
			//TODO this is probably gonna break
			stack: '#cardPile div',
			zIndex: 10000,
			cursor: 'move',
			revert: true
		} );
	}
	var obj = this;
	// Create the card slots
	this.questionsArray.sort(function() { return Math.random() - 0.5; });
	for ( i=0; i<this.questionsArray.length; i++ ) {
		$slot = $(
			'<div class="slot incorrect" correct="' + this.questionsArray[i].correct + '">&nbsp;' +
				'<div class="text">' + this.questionsArray[i].text + '</div>' +
				'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
				'<img id="correct-icon" src="images/icon-correct.png"/>' +
			'</div>');
		$slot.droppable( {
			accept: '.card',
			hoverClass: 'hovered',
			tolerance: 'intersect',
			drop: obj.handleCardDrop,
			out: obj.handleCardOut
		});
		cardSlots.append($slot);
	}
}

Matching.prototype.handleCardDrop = function( event, ui ) {
	if ($(this).attr('card') === '' || $(this).attr('card') === undefined) {
		$('#cardSlots .slot[card="' + ui.draggable.attr('id') + '"]').attr('card', '');
		$(this).attr('card', ui.draggable.attr('id'));

		
		$(ui.draggable).css({
			'margin': '0px'
		});
		ui.draggable.draggable( 'option', 'revert', false );
		

		$(this).append(ui.draggable);
		ui.draggable.position( { of: $(this), my: 'right center', at: 'right center' } );
		$(ui.draggable).css({
			'right': 'auto',
			'left': 'auto',
			'top' : 'auto'
		});

		var appendTarget = $(this).parent().prev('#cardPile');

		ui.draggable.draggable({
			helper: function(){
				return $(this).clone().width($(this).width());
			},
			appendTo : appendTarget,
			start: function(){
				$(this).css({opacity:0});
			},
			stop: function(){
				$(this).css({opacity:1});	
			}
		});
	}
}

Matching.prototype.handleCardOut = function(event, ui) {
	ui.draggable.draggable( 'option', 'revert', true );
}

Matching.prototype.getScore = function() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	var obj = this;
	this.container.find('#cardSlots .slot').each(function(sIndex, slot) {
		questions.push('');
		
		var answer = obj.container.find('#cardPile .card[id="' + $(slot).attr('card') + '"]').text();
		if (answer !== '') {
			answers.push($(slot).text() + ' ' + answer);
		} else {
			answers.push('You did not give any answer');
		}
		
		corrects.push($(slot).text() + ' ' + obj.container.find('#cardPile .card[id="' + $(slot).attr('correct') + '"]').text());
		
		if ($(slot).hasClass('correct')) {
			points.push(1);
			gamePoints ++;
		} else {
			points.push(0);
		}
		totals.push(1);
		gameTotal++;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}