var MultipleChoice = function(container){
	this.pageIndex;
	this.questionsArray = [];
	this.gameDisplayOptions = 0;
	this.container = container;
	this.gameXMLDOM;
}

//Game-specific initialization
MultipleChoice.prototype.init = function(gameXMLDOM){
	console.log('init MultipleChoice');
	this.gameXMLDOM = gameXMLDOM;
	var defaultOptions = '';
	var letters = 'abcdefghijklmnopqrstuvwxyz';
	$(this.gameXMLDOM).find('GlobalOptions > Option').each(function(index, Element) {
		defaultOptions +=
			'<a class="options" href="javascript:void(0)" value='+$(this).attr('value')+' onclick="answerQuestion(this)">' +
				'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
				'<img id="correct-icon" src="images/icon-correct.png"/>' +
				'<span>' + letters[index] + '. ' + $(this).text() + '</span>' +
			'</a>';
	});
	var obj = this;
	$(this.gameXMLDOM).find('MultipleChoiceQuestionItem').each(function(key, Element) {
		$options = $(this).find('Option');
		var options = '';
		
		if ($options.length !== 0) {
			$options.each(function (oIndex, option) {
				options +=
					'<a class="options" href="javascript:void(0)" value="' + $(option).attr('value') + '" onclick="answerQuestion(this)">' + 
						'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
						'<img id="correct-icon" src="images/icon-correct.png"/>' +
						'<span>' + letters[oIndex] + '. ' + $(option).text() + '</span>' +
					'</a>';
			});
		} else {
			options = defaultOptions;
		}
		
		obj.questionsArray.push({
			text: $(this).find('Question').text(),
			options: options,
			correct: $(this).find('Answer').text(),
			audio: $(this).find('Audio > URL').text()
		});
	});
}

//Should return the number of pages
MultipleChoice.prototype.getPagesCount = function() {
	return this.questionsArray.length;
}

//If there are several pages, page loading handler
MultipleChoice.prototype.getPage = function(pageNumber){
	this.pageIndex = pageNumber;
	this.container.find('.question').hide();
	this.container.find('.question:nth-child(' + (pageNumber + 1) + ')').show();
	
	if (pageNumber === this.questionsArray.length - 1) {
		this.container.find('.next-button').text('Finish');
	} else {
		this.container.find('.next-button').text('Next question');
	}
}

//Audio file, if available
MultipleChoice.prototype.getAudio = function() {
	return '';
	//return self.questionsArray[self.pageIndex].audio;
}

//When Check Answers button is pressed
MultipleChoice.prototype.onCheckPageAnswer = function(page) {
	var finishCheck = true;
	if (typeof(page) !== 'number') {
		page = this.pageIndex;
		finishCheck = false;
	}
	
	question = this.container.find('#ajax-questions .question:nth-child(' + (page + 1) + ')');
	$(question).find('.options').each(function(oIndex, option) {
		if ($(option).attr('value') === $(question).data('answer')) {
			$(option).addClass('correct');
		} else {
			$(option).addClass('incorrect');
		}
	});
	
	if (finishCheck) {
		$(question).find('.options').addClass('show');
	} else {
		$(question).find('.options').removeClass('show');
		$(question).find('.options.selected').addClass('show');
	}
}

//Game-specific reset procedure
MultipleChoice.prototype.reset = function() {
	var obj = this;
	obj.container.find('#ajax-questions').html('');
	$.each(obj.questionsArray, function (key, question) {
		var domString =
			'<div class="question" id="' + key + '">' +
				'<div class="text">' + question.text + '</div>' +
				'<div class="btn-group">' + question.options + '</div>' +
			'</div>';
		var $domString = $(domString).data('answer', question.correct);
		obj.container.find('#ajax-questions').append($domString);
	});
	
	obj.container.find('#ajax-questions').append($('<div class="next-button button">Next question</div>'));
	obj.container.find('.next-button').on('click', '', function (event) {
		if (obj.pageIndex < obj.questionsArray.length - 1) {
			obj.container.find('#ajax-pages #' + (obj.pageIndex + 2)).click();
		} else {
			obj.container.find('#finishButton').click();
		}
	});
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
MultipleChoice.prototype.getScore = function() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	this.container.find('#ajax-questions .question').each(function(qIndex, question) {
		questions.push($(question).find('.text').text());
		
		answers.push($(question).find('.btn-group .options.selected').text());
		
		corrects.push($(question).find('.btn-group .options[value="' + $(question).data('answer') + '"]').text());
		
		if ($(question).find('.btn-group .options.selected').hasClass('correct')) {
			points.push(1);
			gamePoints ++;
		} else {
			points.push(0);
		}
		totals.push(1);
		gameTotal++;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}

var answerQuestion = function(dom) {
	$dom = $(dom);
	$dom.siblings().removeClass('selected');
	$dom.addClass('selected');
}
