var ReorderingHorizontal = function(container){	
	this.pageIndex;
	this.pages = [];
	this.gameDisplayOptions = 0;
	this.container = container;
	this.gameXMLDOM;
}


//Game-specific initialization
ReorderingHorizontal.prototype.init = function(gameXMLDOM){
	console.log('init ReorderingHorizontal');
	var self = this;
	self.gameXMLDOM = gameXMLDOM;
	$(self.gameXMLDOM).find('OrderedQuestionItems').each(function (qIndex, question) {
		var cards = [];
		$(question).find('OrderedQuestionItem').each(function(cardIndex, card) {
			cards.push($(card).text());
		});
		
		self.pages.push({ cards: cards, score: 0, audio: $(question).find('Audio > URL').text() });
	});
}

ReorderingHorizontal.prototype.getPagesCount = function() {
	return this.pages.length;
}

//If there are several pages, page loading handler
ReorderingHorizontal.prototype.getPage = function(pageNumber){
	this.pageIndex = pageNumber;
	this.container.find('#ajax-questions .question').hide();
	this.container.find('#ajax-questions .question:nth-child(' + (pageNumber + 1) + ')').show();
}

ReorderingHorizontal.prototype.getAudio = function() {
	return this.pages[this.pageIndex].audio;
}

//When Check Answers button is pressed
ReorderingHorizontal.prototype.onCheckPageAnswer = function(page) {
	if (typeof(page) !== 'number') {
		page = this.pageIndex;
	}
	var self = this;
	this.container.find('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable li').each(function (index) {
		$(this).removeClass('incorrect');
		$(this).removeClass('correct');
		
		if ($(this).text() !== self.pages[page].cards[index]) {
			$(this).addClass('incorrect');
		} else {
			$(this).addClass('correct');
		}
	});
	self.container.find('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable').addClass('show');
}

//Game-specific reset procedure
ReorderingHorizontal.prototype.reset = function() {
	var self = this;
	self.container.find('.question').remove();
	$.each(self.pages, function (pIndex, page) {
		var cards = self.pages[pIndex].cards.slice();
		cards.sort(function() { return Math.random() - 0.5; });
		$question = $('<div class="question"></div>');
		$pile = $('<ul id="sortable"></ul>');
		$.each(cards, function (cIndex, card) {
			$pile.append($('<li class="ui-state-default">' + card + '<img id="incorrect-icon" src="images/icon-incorrect.png" /><img id="correct-icon" src="images/icon-correct.png"/></li>'));
		});
		$question.append($pile);
		self.container.find('#ajax-questions').append($question);
		self.container.find('#ajax-questions .question:nth-child(' + (pIndex + 1) + ') #sortable').sortable({
			placeholder: "ui-state-highlight"
		}).disableSelection();
	});
	self.container.find('.question').hide();
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
ReorderingHorizontal.prototype.getScore = function() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	var self = this;
	self.container.find('#ajax-questions .question').each(function(qIndex, question) {
		questions.push('');
		
		var answer = '';
		$(question).find('#sortable li').each(function() {
			answer += $(this).text() + ' ';
		});
		answers.push(answer);
		
		var correct = '';
		$.each(self.pages[qIndex].cards, function(cIndex, card) {
			correct += card + ' ';
		});
		corrects.push(correct);
		
		var score = $(question).find('#sortable li.correct').length;
		points.push(score);
		gamePoints += score;
		var total = self.pages[qIndex].cards.length;
		totals.push(total);
		gameTotal += total;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}