var ErrorCorrection = function(container){

	this.pageIndex;
	this.questionsArray = [];
	this.gameDisplayOptions = 0;

	this.container = container;
	this.gameXMLDOM;
}

//Game-specific initialization
function init(){
	$(gameXMLDOM).find('SimpleQuestionItem').each(function(key, Element) {
		questionsArray.push({
			text: $(this).find('Question').text(),
			correct: $(this).find('Answer').text().split('|')
		});
	});
}

//Should return the number of pages
function getPagesCount() {
	return questionsArray.length;
}

//If there are several pages, page loading handler
function getPage(pageNumber){
	pageIndex = pageNumber;
	$('.question').hide();
	$('.input').hide();
	$('.questions .question:nth-child(' + (pageNumber + 1) + ')').show();
	$('.inputs .input:nth-child(' + (pageNumber + 1) + ')').show();
	
	if (pageNumber === questionsArray.length - 1) {
		$('.next-button').text('Finish');
	} else {
		$('.next-button').text('Next question');
	}
}

//Audio file, if available
function getAudio() {
	return '';
}

//When Check Answers button is pressed
function onCheckPageAnswer(page) {
	if (typeof(page) !== 'number') {
		page = pageIndex;
	}
	
	$question = $('#ajax-cont .questions .question:nth-child(' + (page + 1) + ')');
	
	$input = $('.inputs .input:nth-child(' + (page + 1) + ')');
	
	if ($.inArray($.trim($input.find('input').val()), questionsArray[page].correct) >= 0) {
		$input.removeClass('incorrect');
		$input.addClass('correct');
	} else {
		$input.removeClass('correct');
		$input.addClass('incorrect');
	}
	$input.addClass('show');
}

//Game-specific reset procedure
function reset() {
	$('#ajax-cont .questions').remove();
	$('#ajax-cont').append('<div class="questions"></div>');
	$.each(questionsArray, function (key, question) {
		$('#ajax-cont .questions').append($(
			'<div class="question">' +
				question.text +
			'</div>'));
	});
	
	$('#ajax-questions').html('<div class="inputs"></div>');
	$.each(questionsArray, function (key, question) {
		$('#ajax-questions .inputs').append($(
			'<div class="input">' +
				'<input type="text" value="' + question.text + '"/>' +
				'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
				'<img id="correct-icon" src="images/icon-correct.png"/>' +
			'</div>'));
	});
	
	$('#ajax-questions').append($('<div class="next-button button">Next question</div>'));
	$('.next-button').on('click', '', function (event) {
		if (pageIndex < questionsArray.length - 1) {
			$('#ajax-pages #' + (pageIndex + 2)).click();
		} else {
			$('#finishButton').click();
		}
	});
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#ajax-cont .question').each(function(qIndex, question) {
		questions.push('');
		
		var $input = $('#ajax-questions .inputs .input:nth-child(' + (qIndex + 1) + ')');
		var answer = $input.find('input').val();
		
		corrects.push(questionsArray[qIndex].correct.join('<span class="or"> or </span>'));
		answers.push(answer);
		
		if ($input.hasClass('correct')) {
			points.push(1);
			gamePoints ++;
		} else {
			points.push(0);
		}
		
		totals.push(1);
		gameTotal++;
		
		$('#ajax-questions .input input').attr('disabled', 'disabled');
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}