var MultipleSelection = function(container){	
	this.pageIndex;
	this.questionsArray = [];
	this.gameDisplayOptions = 0;
	this.container = container;
	this.gameXMLDOM;
}

//Game-specific initialization
function init(){
	var defaultOptions = '';
	var defaultOptionsCount = 0;
	var letters = 'abcdefghijklmnopqrstuvwxyz';
	$(gameXMLDOM).find('GlobalOptions > Option').each(function(index, Element) {
		defaultOptions +=
			'<div class="option">' +
				'<div class="mark true"></div>' +
				'<div class="mark false"></div>' +
				'<a value="' + $(this).attr('value') + '">' +
					'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
					'<img id="correct-icon" src="images/icon-correct.png"/>' +
					'<span>' + letters[index] + '. ' + $(this).text() + '</span>' +
				'</a>' +
			'</div>';
		
		defaultOptionsCount++;
	});
		
	$(gameXMLDOM).find('MultipleSelectionQuestionItem').each(function(key, Element) {
		$options = $(this).find('Option');
		var options = '';
		var optionsCount = 0;
		
		if ($options.length !== 0) {
			$options.each(function (oIndex, option) {
				options +=
					'<div class="option">' +
						'<div class="mark true"></div>' +
						'<div class="mark false"></div>' +
						'<a value="' + $(option).attr('value') + '">' + 
							'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
							'<img id="correct-icon" src="images/icon-correct.png"/>' +
							'<span>' + letters[oIndex] + '. ' + $(option).text() + '</span>' +
						'</a>' +
					'</div>';
					
				optionsCount ++;
			});
		} else {
			options = defaultOptions;
			optionsCount = defaultOptionsCount;
		}
		
		var answers = [];
		$(this).find('Answer').each(function(aIndex, answer) {
			answers.push($(answer).text());
		});
		
		questionsArray.push({
			text: $(this).find('Question').text(),
			options: options,
			optionsCount: optionsCount,
			correct: answers
		});
	});
	
	$('body').on('click', '.mark', function() {
		if ($(this).hasClass('selected')) {	
			$(this).nextAll('a').removeClass('selected');
		} else {
			$(this).siblings('.mark').removeClass('selected');
			$(this).nextAll('a').addClass('selected');
		}
		$(this).toggleClass('selected');
	});
}

//Should return the number of pages
function getPagesCount() {
	return questionsArray.length;
}

//If there are several pages, page loading handler
function getPage(pageNumber){
	pageIndex = pageNumber;
	$('.question').hide();
	$('.question:nth-child(' + (pageNumber + 1) + ')').show();
	
	if (pageNumber === questionsArray.length - 1) {
		$('.next-button').text('Finish');
	} else {
		$('.next-button').text('Next question');
	}
}

//Audio file, if available
function getAudio() {
	return $(gameXMLDOM).find('MultipleSelectionGame > Audio > URL').text();
}

//When Check Answers button is pressed
function onCheckPageAnswer(page) {
	var finishCheck = true;
	if (typeof(page) !== 'number') {
		page = pageIndex;
		finishCheck = false;
	}
	
	question = $('#ajax-questions .question:nth-child(' + (page + 1) + ')');
	$(question).find('.option a').each(function(oIndex, option) {
		var selectedTrue = $(option).prevAll('.selected').hasClass('true');
		var selectedFalse = $(option).prevAll('.selected').hasClass('false');
		var isTrue = $.inArray($(option).attr('value'), questionsArray[page].correct) >= 0;
		$(option).removeClass('correct incorrect');
		if ( selectedTrue && isTrue || selectedFalse && !isTrue) {
			$(option).addClass('correct');
		} else {
			$(option).addClass('incorrect');
		}
	});
	
	if (finishCheck) {
		$(question).find('.option a').addClass('show');
	} else {
		$(question).find('.option a').removeClass('show');
		$(question).find('.option a.selected').addClass('show');
	}
}

//Game-specific reset procedure
function reset() {
	$('#ajax-questions').html('');
	$.each(questionsArray, function (key, question) {
		var domString =
			'<div class="question" id="' + key + '">' +
				'<div class="text">' + question.text + '</div>' +
				'<div class="btn-group">' + question.options + '</div>' +
			'</div>';
		$('#ajax-questions').append($(domString));
	});
	
	$('#ajax-questions').append($('<div class="next-button button">Next question</div>'));
	$('.next-button').on('click', '', function (event) {
		if (pageIndex < questionsArray.length - 1) {
			$('#ajax-pages #' + (pageIndex + 2)).click();
		} else {
			$('#finishButton').click();
		}
	});
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#ajax-questions .question').each(function(qIndex, question) {
		questions.push($(question).find('.text').text());
		
		var answer = '';
		var correct = '';
		$(question).find('.option a').each(function() {
			answer += '<li>' + $(this).text() + ' <u>';
			correct += '<li>' + $(this).text() + ' <u>';
			
			$mark = $(this).prevAll('.mark.selected');
			if ($mark.hasClass('true')) {
				answer += '&#10003;</u>';
			} else if ($mark.hasClass('false')) {
				answer += '&#10007;</u>';
			} else {
				answer += '&nbsp;&nbsp;</u>';
			}
			
			if ($.inArray($(this).attr('value'), questionsArray[qIndex].correct) >= 0)
			{
				correct += '&#10003;</u>';
			} else {
				correct += '&#10007;</u>';
			}
			
			answer += '</li>';
			correct += '</li>';
		});
		answers.push('<ul>' + answer + '</ul>');
		corrects.push('<ul>' + correct + '</ul>');
		
		var score = $(question).find('.option a.correct').length;
		points.push(score);
		gamePoints += score;
		var total = questionsArray[qIndex].optionsCount;
		totals.push(total);
		gameTotal += total;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}
