﻿var Brazil = {
	"theme" : {
		"name" : "theme_default"
	},
	"page_layout" : [
		{
			"content" : "nav",
			"template" : "tmpl_bc_nav",
			"anchor" : "bod"
		},
		{
			"content" : "header",
			"template" : "tmpl_bc_ingredient_header",
			"anchor" : "container"
		},
		{
			"content" : "ingredient",
			"template" : "tmpl_htmlpage",
			"anchor" : "container"
		}
	],
	"content":{
		"itemsPerPage" : "1",
		"columns" : "1",
		"extraPadding" : "false",
		"isRoot" : "false",
		"hasContent" : "false",

		"nav" :
		{
			"home_image": "home-icon.svg",
			"back_image": "back-icon.svg",
		},
		"header":
		{
			"folder": "khan/",
			"background" : "bc-sml.png",
			"tagline": "",
			"tagline_class": "tagline-text-small",
			"subhead" : "Pais",
			"logo":
			[
				{
					"image": "logo-intel.svg",
					"orientation": "top_left"
				},
				{
					"image": "logo-bc.svg",
					"orientation": "top_right"
				}

			]
		},
"ingredient" : [{
"h1"	: "Falando inglês em casa",
"p1_0"	: "Na maior parte dos casos, são os pais que ensinam seus filhos a falar a sua língua materna. Ao longo dos dois primeiros anos de vida, muitas vezes é a voz da mãe e seu modo especial de falar, chamado de 'parentese', que ensinam as crianças sobre o idioma e como falar.",


"h2"	: "Os pais, mesmo com um conhecimento básico de inglês, podem apoiar de forma bem sucedida a aprendizagem de inglês do seu filho ajustando e reutilizando muitas dessas mesmas técnicas de 'parentese'.",
"p2_0"	: "Os pais podem se preocupar com o sotaque deles em inglês. As crianças têm uma notável capacidade de alterar o seu sotaque para combinar com o inglês da sua vizinhança. As crianças precisam sentir 'Eu posso falar inglês' e 'Eu gosto de inglês' e o apoio de seus pais pode ajudá-los a conseguir isso a partir de suas primeiras lições.",
"p2_1"	: "Leia as notas abaixo sobre como falar inglês em casa. Você também pode baixar essas notas como um livro. Clique com o botão direito do mouse no link abaixo para baixar o livro em seu computador. Você pode imprimir este livro.",

"h3"	: "Por que a ajuda dos pais é a melhor.",
"p3_0"	: "Os pais podem se concentrar em seu filho, passar algum tempo em particular com eles.",
"p3_1"	: "Os pais podem encaixar sessões de inglês em qualquer parte do seu dia para se adaptar ao seu filho e a si mesmos.",
"p3_2" 	: "Os pais podem ajustar a duração de uma sessão de inglês e selecionar as atividades para atender às necessidades, aos interesses e à capacidade de concentração dos seus filhos.",
"p3_3"	: "Os pais conhecem seu filho intimamente e podem de forma intuitiva julgar o tipo de inglês falando adequado para os seus modos individuais de aprender o idioma.",
"p3_4"	: "Os pais podem interpretar melhor o humor dos seus filhos e reagir a eles. As crianças têm dias nos quais absorvem avidamente o idioma e outros nos quais elas têm dificuldade de se concentrar.",
"p3_5"	: "Os pais podem introduzir mais diversão, como eles estão trabalhando com um indivíduo, não com uma classe.",
"p3_6"	: "Os pais podem introduzir a cultura inglesa na vida familiar, ampliando as perspectivas do seu filho e a compreensão da sua própria cultura, assim como coisas em inglês.",

"h4"	: "O que é linguagem 'parentese'?",
"p4_0"	: "'Parentese' é uma forma de falar sintonizada e ajustada para a linguagem de uma criança, proporcionando o diálogo com a criança e a conduzindo ao seu próximo nível de competência. As mulheres parecem ser usuárias inatas de 'parentese', alguns homens parecem achar que é mais difícil, a menos que eles possam concentrar seu diálogo em torno de objetos específicos - um livro ilustrado ou um jogo. No entanto, as crianças - especialmente os meninos - precisam de modelos masculinos para saberem como os homens usam o idioma de forma diferente. Os homens tendem a adotar uma abordagem mais técnica para usar o idioma e menos conversa.",
"p4_1"	: "Os pais, usando uma voz mais suave, cuidadosa e linguagem mais simples, inconscientemente conduzem a criança pela atividade por meio de:",
"p4_2"	:[
			"um comentário contínuo (falado em voz alta) sobre o que está acontecendo: 'Vamos colocá-los aqui.' 'Aqui.' 'Olhe. Eu os coloquei sobre a mesa.' 'De qual deles você gosta?' [pausa] 'Oh, eu gosto deste.' 'O vermelho'",
			"repetir uma linguagem prática com mais frequência do que em uma conversa de adultos: a repetição introduzida naturalmente ajuda a criança a confirmar o que eles estão aprendendo - não é chato para a criança, mesmo que seja para os pais",
			"refletir o que a criança disse e ampliar: Criança: 'Amarelo'; Pai: 'Você gosta do amarelo.' 'Aqui está.' 'Aqui está o amarelo.' 'Vamos ver, amarelo, vermelho e aqui está o marrom.' 'Eu gosto do marrom, você gosta?' {pause}",
			"falar mais lentamente e enfatizando as palavras novas, naturalmente, sem alterar a melodia do idioma. 'Qual rima nós diremos hoje?' 'Você escolhe.' [pausa para a criança escolher]",
			"usar as mesmas frases a cada vez para gerenciar sessões de inglês, bem como atividades e jogos. Conforme a compreensão da criança aumenta, essas frases básicas são ampliadas: 'Vamos jogar Simon.' 'Fiquei parado ali.' 'Na minha frente.' 'Isso mesmo.' 'Você está pronto?'",
			"acrescentar expressão facial e gestos para auxiliar a compreensão",
			"usar contato visual no intercâmbio particular para tranquilizar e também incentivar uma criança hesitante a falar",
			"parar por um tempo maior conforme as crianças precisarem pensar sobre o que ouviram antes de estarem prontas para responder. Quando a fala ainda for limitada, pausas exageradas podem adicionar o divertimento ou manter o interesse em um jogo."
		],

"p4_3"	: "Alguns pais acham embaraçoso dramatizar e usar 'parentese'. No entanto, para a criança, isso torna aprender inglês mais fácil porque eles estão familiarizados com essas 'mini-aulas' naturais em sua língua materna. Depois que as crianças começarem a falar, os pais naturalmente sentiram menos necessidade de usar 'parentese', exceto quando introduzirem um novo idioma ou atividades.",
"h5"	: "Usando inglês",
"p5_0"	: "Ao usar inglês simples com muita repetição, os pais ajudam a criança a começar a pensar em inglês durante as atividades nas quais ela se sente segura e pode prever o que vai acontecer, como jogos ou na hora das rimas.",

"p5_1"	: "As crianças querem ser capazes de falar em inglês sobre:",
"p5_2"	:[
		"elas mesmas e o que gostam: 'Eu gosto, eu não gosto ... yuk'",
		"o que elas fizeram: 'Eu fui, eu vi..., eu comi...'",
		"como elas e os outros se sentem: 'Eu estou triste, ela está nervosa...'"
	],

"p5_3"	: "Os pais podem ajudar compartilhando livros ilustrados ou criando seus próprios livros usando desenhos ou fotografias.",
"p5_4"	: "A criança aprendendo sua língua materna se tornar hábil em transferir um pouco da linguagem para muitas situações: 'Tudo se foi.' Se os adultos transferem frases em inglês, da mesma forma, as crianças logo irão copiá-los",
"p5_5"	: "Quando as crianças precisam praticar inglês na escola, elas usam frases como 'Qual é o seu nome?' 'Quantos anos você tem?'' 'O que é isso?' 'Isso é um lápis.' Os pais podem transformar isso em uma atividade divertida, usando um brinquedo que só fala inglês, fazendo perguntas a ele e fingindo fazê-lo responder.",
"p5_6"	: "Conforme as crianças se tornam oradores mais competentes, elas podem incluir uma palavra em sua língua materna dentro de uma frase em inglês 'Ele está comendo um (...)', porque eles ainda não sabem a palavra em inglês. Se o adulto repetir a frase novamente usando apenas inglês, a criança poderá aprender a palavra em inglês. 'Ele está comendo uma ameixa.' 'Uma ameixa.'",

"h6"	: "Quando traduzir",
"p6_0"	: "A capacidade de entender das crianças não deve ser subestimada, pois elas entendem muito mais do que podem dizer em inglês. Em sua língua materna, as crianças costumam compreender apenas algumas das palavras que ouvem e preencher o restante com a linguagem corporal do falante e com as pistas ao redor delas para obter o significado. Onde 'parentese' é usado, elas parecem transferir essas habilidades para trabalhar o significado em inglês.",
"p6_1"	: "Quando ambos os novos conceitos e o novo idioma são introduzidos ao mesmo tempo, pode ser necessário fornecer uma tradução rápida uma vez, utilizando um sussurro, seguida diretamente pelo inglês. Se a tradução é dada mais de uma vez e novamente em sessões seguintes, uma criança pode se acostumar a espera pela tradução em vez de usar as suas próprias pistas para entender o inglês.",

"h7"	: "Sessões em inglês",

"p7_0"	: "As sessões em inglês podem durar de poucos minutos até cerca de 10 e podem ocorrer uma ou duas vezes por dia, dependendo das circunstâncias. Quanto maior for a frequência da utilização do inglês, mais rápido ele será absorvido.",
"p7_1"	: "Durante as sessões em inglês, os pais precisam se concentrar em seu filho sem quaisquer interrupções. As crianças vão adorar as sessões em inglês, porque para elas o inglês é um momento especial com toda a atenção dos pais.",
"p7_2"	: "As crianças são pensadores lógicos: elas precisam ter uma razão para falar inglês, uma vez que tanto elas quanto seus pais podem falar a língua materna.",
"p7_3"	: "Elas podem achar que é difícil mudar da sua língua materna para o inglês, por isso é importante definir o cenário: ' Em três minutos teremos a nossa sessão em inglês.' Estabelecer o cenário para a sessão em inglês pode envolver ir para um lugar especial na sala: 'Vamos nos sentar no sofá. Agora, vamos falar em inglês.' O aquecimento em inglês com contagem ou dizer uma rima familiar também ajuda a mudar para o inglês antes de introduzir alguma nova atividade.",
"p7_4"	: "As crianças aprendem o idioma quando o assunto é baseado em uma atividade com a qual elas estejam fisicamente envolvidas. Se elas já foram introduzidas à atividade em sua língua materna e compreenderam o conteúdo, elas se sentirão mais seguras e poderão se concentrar em entender e aprender o inglês acompanhante. Como as sessões são apenas em inglês, as atividades precisam ser mais curtas, tendo em vista que o período de atenção das crianças geralmente não é tão longo como na língua materna. Ouvir apenas inglês pode ser cansativo.",

"h8"	: "Encorajamento e elogios",
"p8_0"	: "As crianças esperam elogios de seus pais. Elas precisam se sentir bem e saber que estão fazendo progressos em inglês. O apoio positivo e contínuo, o incentivo e os elogios da mãe e do pai, bem como de toda a família, ajudam a construir a auto-confiança e motivar. Nos estágios iniciais da aprendizagem, o incentivo é especialmente importante e elogiar qualquer pequeno progresso é estimulante. 'Muito bom.' 'Gostei disso.' 'Parabéns!'",
"p8_1"	: "O começo com o inglês é o momento no qual as crianças precisam de mais apoio dos pais. Quando elas forem capazes de falar, recitar rimas e tiverem memorizado algumas histórias, o apoio já não precisará ser tão intenso. Nesse estágio, frases, rimas e histórias em inglês são susceptíveis a serem uma brincadeira transferida para a vida familiar. O inglês em família pode ser uma ligação e é provável que permaneça. Isso pode ser o início de atitudes positivas ao longo da vida quanto ao inglês e a outras culturas. Agora, é geralmente aceitável que as atitudes ao longo da vida são estabelecidas no início da infância, antes da idade de oito ou nove anos."
}],
		
		"footer" : {
			
		}
		
	}
};



