﻿var English = {
	"theme" : {
		"name" : "theme_default"
	},
	"page_layout" : [
		{
			"content" : "nav",
			"template" : "tmpl_bc_nav",
			"anchor" : "bod"
		},
		{
			"content" : "header",
			"template" : "tmpl_bc_ingredient_header",
			"anchor" : "container"
		},
		{
			"content" : "ingredient",
			"template" : "tmpl_htmlpage",
			"anchor" : "container"
		}
	],
	"content":{
		"itemsPerPage" : "1",
		"columns" : "1",
		"extraPadding" : "false",
		"isRoot" : "false",
		"hasContent" : "false",

		"nav" :
		{
			"home_image": "home-icon.svg",
			"back_image": "back-icon.svg",
		},
		"header":
		{
			"folder": "khan/",
			"background" : "bc-sml.png",
			"tagline": "",
			"tagline_class": "tagline-text-small",
			"subhead" : "Parents",
			"logo":
			[
				{
					"image": "logo-intel.svg",
					"orientation": "top_left"
				},
				{
					"image": "logo-bc.svg",
					"orientation": "top_right"
				}

			]
		},
"ingredient" : [{

"h1"	: "Speaking English at Home",
"p1_0"	: "For the most part, it is parents who teach their young children to speak their home language. Throughout the first two years of life, it is often the mother’s voice and her special way of talking, called ‘parentese’, that teaches young children about language and how to talk.",


"h2"	: "Parents, even with a basic knowledge of English, can successfully support their young child learning English by re-using and adjusting many of these same parentese techniques.",
"p2_0"	: "Parents may worry about their accent in English. Young children have a remarkable ability to alter their accent to match the English of their surroundings. Young children need to feel ‘I can speak English’ and ‘I like English’ and their parents’ support can help them achieve this from their first lessons.",
"p2_1"	: "Read the notes below on speaking English at home. You can also download these notes as a booklet. Right-click on the link below to download the booklet to your computer. You may print this booklet.",

"h3"	: "Why Parent's Help is best.",
"p3_0"	: "Parents can focus on their child, spending some one-to-one time with them.",
"p3_1"	: "Parents can fit English sessions into any part of their day to suit their child and themselves.",
"p3_2" 	: "Parents can regulate the length of an English session and select activities to fit their child’s needs, interests and ability to concentrate.",
"p3_3"	: "Parents know their child intimately and can intuitively judge the type of English talking suitable for their individual ways of picking up language.",
"p3_4"	: "Parents can best interpret their child’s moods and respond to them. Children have days when they eagerly absorb language and others when they find it difficult to concentrate.",
"p3_5"	: "Parents can introduce more fun, as they are working with an individual, not a class.",
"p3_6"	: "Parents can introduce English culture into family life, so broadening their child’s outlook and understanding of their own culture as well as things English.",

"h4"	: "What is Parentese Language?",
"p4_0"	: "'Parentese' is a form of talking that tunes into and adjusts to a young child’s language, providing dialogue with the child and shepherding them to their next level of competence. Women appear to be innate users of parentese; some men seem to find it more difficult unless they can centre their talk around specific objects – a picture book or a game. However, children – especially boys – need male role models as men use language differently. Men tend to take a more technical approach to using language and 'chatter' less.",
"p4_1"	: "Parents, using a softer, caring voice and simpler language, unconsciously shepherd their young child through an activity by:",
"p4_2"	:[
			"a running commentary (talking aloud) on what is going on: 'Let's put it here.' 'There.' 'Look. I’ve put it on the table.' 'Which one do you like?' [pause] 'Oh, I like this one.' 'The red one'",
			"repeating useful language more often than in adult talk: repetition introduced naturally helps the child to confirm what they are picking up – it is not boring for the child, even if it is for the parent",
			"reflecting back what their child has said and enlarging it: Child: 'Yellow'; Parent: 'You like the yellow one.' 'Here it is.' 'Here’s the yellow one.' 'Let's see. yellow, red and here's the brown one.' 'I like the brown one, do you?' {pause}",
			"talking more slowly and stressing new words naturally without altering the melody of the language. 'Which rhyme shall we say today?' 'You choose.' [pause for child to select]",
			"using the same phrases each time to manage English sessions as well as activities and games. As children’s understanding increases, these basic phrases are enlarged: 'Let's play Simon says.' 'Stand there.' 'In front of me.' 'That’s right.' 'Are you ready?'",
			"adding facial expression and gesture to aid understanding",
			"using eye contact in one-to-one exchanges to reassure and also to encourage a hesitant child to speak",
			"pausing for a longer time as children need to think about what they hear before they are ready to reply. When speaking is still limited, exaggerated pauses can add fun or hold interest in a game."
		],

"p4_3"	: "Some parents find it embarrassing to dramatise and use parentese. However, for the child, it makes picking up English easier as they are familiar with these natural 'mini-lessons' in their home language. Once young children begin to speak, parents innately feel less need to use parentese, except when introducing new language or activities.",
"h5"	: "Using English",
"p5_0"	: "By using simple English with plenty of repetition, parents help their child to begin thinking in English during activities where they feel secure and can predict what is going to happen, like games or 'rhyme times'.",

"p5_1"	: "Young children want to be able to talk in English about:",
"p5_2"	:[
		"themselves and what they like: 'I like; I don't like… yuk'",
		"what they have done: 'I went to; I saw…; I ate…'",
		"how they and others feel: 'I am sad; she's cross …'"
	],

"p5_3"	: "Parents can help by sharing picture books or making their own books using drawings or photographs.",
"p5_4"	: "Young children learning their home language become skilled in transferring a little language to many situations: 'All gone.' If adults transfer English phrases in the same way, young children soon copy them",
"p5_5"	: "When children need to practise school English, use phrases like 'What's your name?' 'How old are you?' 'What's this?' 'That’s a pencil.' Parents can turn this into a fun activity by using a toy that speaks only English, asking it the questions and pretending to make it answer.",
"p5_6"	: "As young children become more competent speakers, they may include a word in their home language within an English phrase 'He's eating a (…)' because they do not yet know the English word. If the adult repeats the phrase back using only English, the child can pick up the English word. 'He's eating a plum.' 'A plum.'",

"h6"	: "When to translate",
"p6_0"	: "Young children's ability to understand should not be underestimated; they understand much more than they can say in English. In their home language young children are used to understanding only some of the words they hear and filling in the rest from the speaker’s body language and clues around them to get meaning. Where parentese is used, they appear to transfer these skills to working out the meaning in English.",
"p6_1"	: "When both new concepts and new language are introduced at the same time, it may be necessary to give a quick translation once, using a whisper, followed directly by the English. If translation is given more than once and again in following sessions, a child may get used to waiting for the translation instead of using his or her own clues to understand the English.",

"h7"	: "English Sessions",

"p7_0"	: "English sessions may last from just a few minutes up to about ten and can take place once or twice a day, depending on circumstances. The more frequently Englishis used, the quicker it is absorbed.",
"p7_1"	: "During English sessions parents need to focus on their child without any interruptions. Young children come to love English sessions, because for them English is a special time with their parent’s undivided attention.",
"p7_2"	: "Young children are logical thinkers: they need to have a reason for speaking English, since both they and their parents can speak the home language.",
"p7_3"	: "They may find it difficult to switch from their home language into English, so it is important to set the scene: 'In three minutes we are goingto have our English time.' Setting the scene for English time might involve moving to a special place in the room: 'Let's sit on the sofa. Now, let's talk in English.' Warming up in English by counting or saying a familiar rhyme also helps to switch into English before introducing some new activity.",
"p7_4"	: "Children pick up language when the talk is based around an activity in which they are physically involved. If they have already been introduced to the activity in their home language and understood the content, they feel more secure and can concentrate on understanding and picking up the accompanying English. Where sessions are in only English, activities need to be shorter since children’s attention span is generally not as long as in the home language. Listening only to English can be tiring.",

"h8"	: "Encouragement and praise",
"p8_0"	: "Young children look for their parents' praise. They need to feel good, and know they are making progress in English. Continuous positive support, encouragement and praise from both mother and father, as well as the extended family, helps to build up self-confidence and motivate. In the early stages of learning, encouragement is especially important and praise for any small success motivates. 'That's good.' 'I like that.' 'Well done!'",
"p8_1"	: "Starting off in English is the time when young children need parents’ support the most. Once they are able to speak, recite rhymes and have memorised some stories, the support need no longer be so intensive. By this stage, English phrases, rhymes and stories are likely to have been playfully transferred into family life. In-family English can be bonding and is likely to stay. This can be the beginning of positive lifelong attitudes to English and other cultures. It is now generally accepted that lifelong attitudes are laid down in early childhood before the age of eight or nine."


}],
		
		"footer" : {
			
		}
		
	}
};



