<#
  .Notes
	Copyright (c) 2013-2014, Intel Corporation. All rights reserved.
  .Synopsis 
	Clears all events of the specified solution component on the platform
  .Description
	Clears all events of the specified solution component on the platform
  .Example
	.\SCS-ClearEvents -ComputerName MyHost.Domain.com -Component 0b93a9cb-64b1-43ed-bc33-e5b0b8692694
  .Outputs
	None
#>
[CmdletBinding()]
Param(
	[Parameter(Position=0,Mandatory=$False, HelpMessage='Fully qualified component identifer of the solution component on which to perform the operation (default: all components)')][string]$Component = "",
	[Parameter(Mandatory=$False, HelpMessage='Address of the computer on which to perform the operation (default: localhost)')][string]$ComputerName = $env:ComputerName,
	[Parameter(Mandatory=$False, HelpMessage='Credentials to use for authenticating to the Solutions Framework (default: current user)')][Object]$Credential = $null
)

$SCS_SolutionEvent_Class = $(
	if ($Credential) {
		Get-WMIObject -Computer $ComputerName -Credential $cred -Authentication 6 -Errorvariable err -Namespace Root\Intel_SCS_Framework -List SCS_SolutionEvent
	} else {
		Get-WMIObject -Computer $ComputerName -Authentication 6 -Errorvariable err -Namespace Root\Intel_SCS_Framework -List SCS_SolutionEvent
	}
) | Select -First 1

if ($SCS_SolutionEvent_Class -eq $null) {
	if($err.Count -gt 0) {$mg=$err[0];} else { $mg="";}
	Write-Error "Failed to access the the Solutions Framework. $mg"
	exit $exitcode = 1
}

$method = "ClearAllEvents"
$params = $SCS_SolutionEvent_Class.PSBase.GetMethodParameters($method)
if ($Component) {
	$params.ComponentID = $Component
}
if ($Component) {
	$params.ComponentID = $Component
}
try {
	$ret = $SCS_SolutionEvent_Class.PSBase.InvokeMethod($method, $params, $null)
} catch [Exception] {
	Write-Error "Failed to execute the $method command with message: $_.Exception.Message"
	Write-Host "Please check the event log for more details."
	exit $exitcode = $_.Exception.ErrorCode
}
$exitcode = $ret.ReturnValue

exit $exitcode
