<#
  .Notes
	Copyright (c) 2013-2014, Intel Corporation. All rights reserved.
  .Synopsis 
	Runs a discovery operation and reports the available software and hardware capabilities of the platform, and optionally publishes the data to the RCS 
  .Description
	Runs a discovery operation and reports the available software and hardware capabilities of the platform, and optionally publishes the data to the RCS.
	Data can only be published to an RCS that is installed in database mode.
	Running this cmdlet on an RCS in non-database mode will return an error.
  .Example
	.\SCS-PlatformDiscovery -ComputerName MyHost.Domain.com
  .Outputs
	An XML document containing the platform discovery data. For information about the format and content of this XML document, refer to the documentation supplied with the Framework. If the data is published to the RCS, nothing is returned in the output of the cmdlet.
#>
[CmdletBinding()]
Param(
	[string]$bad_param,
	[Parameter(Mandatory=$False, HelpMessage='Address of the computer on which to perform the operation (default: localhost)')][string]$ComputerName = $env:ComputerName,
	[Parameter(Mandatory=$False, HelpMessage='Credentials to use for authenticating to the Solutions Framework (default: current user)')][Object]$Credential = $null,
	[Parameter(Mandatory=$False, HelpMessage='Address of the RCS to which to publish the platform discovery data (default: do not publish)')][string]$Publish = $null
)

if ($bad_param) {
	Write-Host "Invalid positional parameter"
	exit 5
}

$class = $(
    if ($Credential) {
        Get-WMIObject -Computer $ComputerName -Credential $cred -Authentication 6 -Errorvariable err -Namespace Root\Intel_SCS_Framework -List SCS_HostSolutionManager
    } else {
        Get-WMIObject -Computer $ComputerName -Authentication 6 -Errorvariable err -Namespace Root\Intel_SCS_Framework -List SCS_HostSolutionManager
    }
)

if ($class -eq $null) {
	if($err.Count -gt 0) {$mg=$err[0];} else { $mg="";}
	Write-Error "Failed to access the Solutions Framework. $mg"	
	exit 1
}

$methodName = "PlatformDiscovery"
$params = $class.PSBase.GetMethodParameters($methodName)
if ($Publish) {
    $params.RCSAddress = $Publish
}

try {
  $ret = $class.PSBase.InvokeMethod($methodName, $params, $null)
} catch [Exception] {
	Write-Error "Failed to execute the $methodName command with message: $_.Exception.Message" 
	Write-Host "Please check the event log for more details."
	exit $_.Exception.ErrorCode
}
$exitcode = $ret.ReturnValue

if ($Publish -ne $null) {
    $ret.DiscoveryData
}

exit $exitcode
