<#
  .Notes
	Copyright (c) 2013-2014, Intel Corporation. All rights reserved.
  .Synopsis 
	Resets the Key Performance Indicators (KPI) data of the specified solution component, or all solution components on the platform
  .Description
	Resets the Key Performance Indicators (KPI) data of the specified solution component, or all solution components on the platform
  .Example
	.\SCS-ResetKPI -ComputerName MyHost.Domain.com -Component 0b93a9cb-64b1-43ed-bc33-e5b0b8692694
  .Outputs
	None
#>
[CmdletBinding()]
Param(
	[Parameter(Position=0,Mandatory=$False, HelpMessage='Fully qualified component identifer of the solution component on which to perform the operation')][string]$Component = "",
	[Parameter(Mandatory=$False, HelpMessage='Address of the computer on which to perform the operation (default: localhost)')][string]$ComputerName = $env:ComputerName,
	[Parameter(Mandatory=$False, HelpMessage='Credentials to use for authenticating to the Solutions Framework (default: current user)')][Object]$Credential = $null
)

$filter = $(
	if ($Component -ne "") {
		if ($ComponentID -Match '%') {
			"ComponentID LIKE ""$Component"""
		} else {
			"ComponentID = ""$Component"""
		}
	} else {
		""
	}
)

$SCS_ManagedElement = $( # Retrieve the specified ManagedElement
    if ($Credential) {
        Get-WMIObject -Computer $ComputerName -Credential $cred -Authentication 6 -Errorvariable err -Namespace Root\Intel_SCS_Framework -Class SCS_ManagedElement -Filter $filter
    } else {
        Get-WMIObject -Computer $ComputerName -Authentication 6 -Errorvariable err -Namespace Root\Intel_SCS_Framework -Class SCS_ManagedElement -Filter $filter
    }
) | Select -First 1 # If the filter returns multiple components, the cmdlet will run on only the first component

if ($SCS_ManagedElement -eq $null) {
	if($err.Count -gt 0) {$mg=$err[0];} else { $mg="";}
	Write-Error "Failed to load component $Component with error: $mg"
	exit 1
}

$method = "ResetKPIs"
$params = $SCS_ManagedElement.GetMethodParameters($method)
try {
	$ret = $SCS_ManagedElement.InvokeMethod($method, $params, $null)
} catch [Exception] {
	Write-Error "Failed to execute the $method command with message: $_.Exception.Message"
	Write-Host "Please check the event log for more details."
	exit $_.Exception.ErrorCode
}
$exitcode = $ret.ReturnValue

exit $exitcode
