#ifndef _ERRORS_H
#define _ERRORS_H

typedef unsigned long error_code_t;

#define MAX_ERROR_STR_LENGTH 		1024
typedef struct _error_msg_t
{
	char str[MAX_ERROR_STR_LENGTH];
} error_msg_t;

#define SUCCESS 0x0
#define SUCCESS_MSG "Success"


#define ERROR_TYPE_WD_DRIVER 0x0001
#define ERROR_TYPE_DNX_CMD 0x0002
#define ERROR_TYPE_GENERAL 0x0003
#define ERROR_TYPE_DNX_FW 0x8000

typedef enum _GENERAL_STATUS
{
	STATUS_SUCCESS = SUCCESS,
	STATUS_GENERAL_ERROR  = (ERROR_TYPE_GENERAL << 16) ,
	STATUS_INVALID_PARAMS,
	STATUS_RESULT_BUFFER_TOO_SMALL,
	STATUS_DEVICE_NOT_FOUND,
	STATUS_CONFIGURATION_ERROR,
	STATUS_PROTOCOL_ERROR,
	STATUS_INVALID_TIMEOUT,
} GENERAL_STATUS;
typedef enum _WD_DRIVER_STATUS
{
	WD_DRIVER_STATUS_SUCCESS = SUCCESS,
	WD_DRIVER_STATUS_NAME_SET_FAILED  = (ERROR_TYPE_WD_DRIVER << 16) ,
	WD_DRIVER_STATUS_PIPE_NOT_FOUND,
	WD_DRIVER_STATUS_LOAD_LIBRARY_FAILED,
	WD_DRIVER_STATUS_SYMBOL_NOT_FOUND
} WD_DRIVER_STATUS;

typedef enum _DNX_CMD_STATUS
{
	DNX_CMD_STATUS_SUCCESS = SUCCESS,
	DNX_CMD_STATUS_PROTOCOL_ERROR_BAD_RESPONSE_CODE = (ERROR_TYPE_DNX_CMD << 16) ,
	DNX_CMD_STATUS_PROTOCOL_ERROR_BAD_RESPONSE_MARKER,
	DNX_CMD_STATUS_PROTOCOL_ERROR_RESPONSE_MSG_TYPE_UNSUPPORTED,
	DNX_CMD_STATUS_PROTOCOL_ERROR_UNEXPECTED_MSG_DATA_SIZE,
	DNX_CMD_STATUS_PROTOCOL_ERROR_UNEXPECTED_EXT_DATA_SIZE,
} DNX_CMD_STATUS;

typedef enum _DNX_FW_STATUS
{
	DNX_FW_STATUS_SUCCESS  = SUCCESS,// 0x00000000
	DNX_FW_STATUS_EMEDIA_NOT_PRESENT = (ERROR_TYPE_DNX_FW << 16) ,// 0x80000000
	DNX_FW_STATUS_EINVALID_CMD,				 // 0x80000001
	DNX_FW_STATUS_EINVALID_RPMB_BP_DATA,	 // 0x80000002
	DNX_FW_STATUS_EPART_UNSUPPORTED,		 // 0x80000003
	DNX_FW_STATUS_EINVALID_ENH_ATTRIB,		 // 0x80000004
	DNX_FW_STATUS_EINVALID_SIZE,			 // 0x80000005
	DNX_FW_STATUS_EINVALID_REL_WR_ATTRIB,	 // 0x80000006
	DNX_FW_STATUS_EINVALID_EXT_PART_ATTRIB,	 // 0x80000007
	DNX_FW_STATUS_EINVALID_PUB_KEY,			 // 0x80000008
	DNX_FW_STATUS_EMAN_AUTH_FAILURE,		 // 0x80000009
	DNX_FW_STATUS_EINVALID_UNIT_ID,			 // 0x8000000a
	DNX_FW_STATUS_EINVALID_FLAGS,			 // 0x8000000b
	DNX_FW_STATUS_BAD_CHKSUM,				 // 0x8000000c
	DNX_FW_STATUS_EINVALID_MAN_SZ,			 // 0x8000000d
	DNX_FW_STATUS_EINVALID_DNX_MOD_SZ,		 // 0x8000000e
	DNX_FW_STATUS_EINVALID_INSUFF_SRAM,		 // 0x8000000f
	DNX_FW_STATUS_EINVALID_HASH,			 // 0x80000010
	DNX_FW_STATUS_EINVALID_PARAM,			 // 0x80000011
	DNX_FW_STATUS_EINVALID_SIG,				 // 0x80000012
	DNX_FW_STATUS_EINVALID_MOD_TYPE,		 // 0x80000013
	DNX_FW_STATUS_EINVALID_GMID,			 // 0x80000014
	DNX_FW_STATUS_EINVALID_MIN_VER,			 // 0x80000015
	DNX_FW_STATUS_EINVALID_PLAT_ID,			 // 0x80000016
	DNX_FW_STATUS_EINVALID_MACHINE_ID,		 // 0x80000017
	DNX_FW_STATUS_EINVALID_IMG_HDR_SZ,		 // 0x80000018
	DNX_FW_STATUS_EINVALID_OPERATION,		 // 0x80000019
	DNX_FW_STATUS_EINVALID_ELEMENT_INFO,	 // 0x8000001a
	DNX_FW_STATUS_LLDD_OVERFLOW,			 // 0x8000001b
	DNX_FW_STATUS_EINVALID_CHUNK_SIZE,		 // 0x8000001c
	DNX_FW_STATUS_CHUNK_OVERFLOW,			 // 0x8000001d
	DNX_FW_STATUS_PROGRAMMING_ERROR,		 // 0x8000001e
	DNX_FW_STATUS_EINVALID_CHUNK_CNT,		 // 0x8000001f
	DNX_FW_STATUS_EINVALID_IMAGE_SZ,		 // 0x80000020
	DNX_FW_STATUS_EINVALID_PART_HDR,		 // 0x80000021
	DNX_FW_STATUS_EINVALID_PART_MAN_ENTRY,	 // 0x80000022
	DNX_FW_STATUS_EINVALID_PART_METADATA,	 // 0x80000023
	DNX_FW_STATUS_EINVALID_PART_MODULE,		 // 0x80000024
	DNX_FW_STATUS_EINVALID_PART_INFO,		 // 0x80000025
	DNX_FW_STATUS_EINVALID_COMPRESS_TYPE,	 // 0x80000026
	DNX_FW_STATUS_EINVALID_SIGNATURE,		 // 0x80000027
	DNX_FW_STATUS_EINVALID_NEXT_STEP,		 // 0x80000028
	DNX_FW_STATUS_EINVALID_IFP_EMULATION,	 // 0x80000029
	DNX_FW_STATUS_EINVALID_TOKEN_SLOT_IDX,	 // 0x8000002a
	DNX_FW_STATUS_EINVALID_TOKEN_CONTENT,	 // 0x8000002b
	DNX_FW_STATUS_EINVALID_LIFECYCLE_STAGE,	 // 0x8000002c
	DNX_FW_STATUS_EINVALID_DEVICE_TYPE,		 // 0x8000002d
	DNX_FW_STATUS_EINVALID_PARTITION,		 // 0x8000002e
	DNX_FW_STATUS_EINVALID_TIMEOUT_SIZE,	 // 0x8000002f
	DNX_FW_STATUS_EMEDIA_ERROR,				 // 0x80000030
	DNX_FW_STATUS_ERPMB_NOT_PROVISIONED,	 // 0x80000031
	DNX_FW_STATUS_EINVALID_VERSION,			 // 0x80000032
	DNX_FW_STATUS_EINVALID_NUM_REGIONS,      // 0x80000033
	DNX_FW_STATUS_EINVALID_OFFSET,			 // 0x80000034
	DNX_FW_STATUS_EIMAGE_AND_DESCR_MISMATCH, // 0x80000035
	DNX_FW_STATUS_EALREADY_CONFIGURED,		 // 0x80000036
	DNX_FW_STATUS_ENO_TOKEN,				 // 0x80000037
	DNX_FW_STATUS_ESVN_DOWNGRADE,            // 0x80000038
	DNX_FW_STATUS_EINVALID_REGIONS, 		 // 0x80000039
	DNX_FW_STATUS_EUNSUPPORTED_STORAGE_DEV,	 // 0x8000003a
	DNX_FW_STATUS_ESTORAGE_WRITE_FAIL,		 // 0x8000003b
	DNX_FW_STATUS_ESTORAGE_READ_FAIL,		 // 0x8000003c
	DNX_FW_STATUS_EOUT_OF_FLASH_BOUNDS,		 // 0x8000003d
	DNX_FW_STATUS_EINVALID_MAN_EXT_TYPE,	 // 0x8000003e
	DNX_FW_STATUS_EINVALID_OEM_ID,			 // 0x8000003f
	DNX_FW_STATUS_EINVALID_PART_HDR_NAME,	 // 0x80000040
	DNX_FW_STATUS_EINVALID_PART_HDR_LEN,	 // 0x80000041
	DNX_FW_ETOKEN_NOT_SUPPORTED_BEFORE_FIRST_BOOT, // 0x80000042
	EINVALID_IMAGE_LAYOUT,                  // 0x80000043    // Invalid image layout
	EINVALID_OEM_KEY_MANIFEST,              // 0x80000044    // Invalid oem key manifest
	ENO_OEM_DNX_IFWI_KEY_HASH,              // 0x80000045    // No dnx ifwi key in oem key manifest
	EINVALID_LAYOUT_VERSION,                // 0x80000046    // dnx ifwi version must be 0x00000001.
	EINVALID_KM_ID,                         // 0x80000047    // Invalid Key Manifest ID (of the OEM KM)
	ENO_OEM_KM                              // 0x80000048    // oem KM is missing (size zero), and it shouldn't be (platform has pub key hash)
} DNX_FW_STATUS;


#endif //#ifndef _ERRORS_H
