/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import jdk.jfr.events.SocketReadEvent;
import jdk.jfr.events.SocketWriteEvent;
import oracle.jrockit.jfr.JIInstrumentationMethod;
import oracle.jrockit.jfr.JIInstrumentationTarget;
import oracle.jrockit.jfr.JITracer;

@JIInstrumentationTarget(value="sun.nio.ch.SocketChannelImpl")
final class SocketChannelImplInstrumentor {
    private InetSocketAddress remoteAddress;

    private SocketChannelImplInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!JITracer.socketReadToken.isEnabled()) {
            return this.read(byteBuffer);
        }
        SocketReadEvent socketReadEvent = new SocketReadEvent(JITracer.socketReadToken);
        int n = -1;
        try {
            socketReadEvent.begin();
            n = this.read(byteBuffer);
        }
        finally {
            String string = this.remoteAddress.getAddress().toString();
            int n2 = string.lastIndexOf(47);
            socketReadEvent.host = string.substring(0, n2);
            socketReadEvent.address = string.substring(n2 + 1);
            socketReadEvent.port = this.remoteAddress.getPort();
            socketReadEvent.bytesRead = n;
            socketReadEvent.timeout = 0L;
            socketReadEvent.commit();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!JITracer.socketReadToken.isEnabled()) {
            return this.read(byteBufferArray, n, n2);
        }
        SocketReadEvent socketReadEvent = new SocketReadEvent(JITracer.socketReadToken);
        long l = -1L;
        try {
            socketReadEvent.begin();
            l = this.read(byteBufferArray, n, n2);
        }
        finally {
            String string = this.remoteAddress.getAddress().toString();
            int n3 = string.lastIndexOf(47);
            socketReadEvent.host = string.substring(0, n3);
            socketReadEvent.address = string.substring(n3 + 1);
            socketReadEvent.port = this.remoteAddress.getPort();
            socketReadEvent.bytesRead = l;
            socketReadEvent.timeout = 0L;
            socketReadEvent.commit();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!JITracer.socketWriteToken.isEnabled()) {
            return this.write(byteBuffer);
        }
        SocketWriteEvent socketWriteEvent = new SocketWriteEvent(JITracer.socketWriteToken);
        int n = -1;
        try {
            socketWriteEvent.begin();
            n = this.write(byteBuffer);
        }
        finally {
            String string = this.remoteAddress.getAddress().toString();
            int n2 = string.lastIndexOf(47);
            socketWriteEvent.host = string.substring(0, n2);
            socketWriteEvent.address = string.substring(n2 + 1);
            socketWriteEvent.port = this.remoteAddress.getPort();
            socketWriteEvent.bytesWritten = n;
            socketWriteEvent.commit();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!JITracer.socketWriteToken.isEnabled()) {
            return this.write(byteBufferArray, n, n2);
        }
        SocketWriteEvent socketWriteEvent = new SocketWriteEvent(JITracer.socketWriteToken);
        long l = -1L;
        try {
            socketWriteEvent.begin();
            l = this.write(byteBufferArray, n, n2);
        }
        finally {
            String string = this.remoteAddress.getAddress().toString();
            int n3 = string.lastIndexOf(47);
            socketWriteEvent.host = string.substring(0, n3);
            socketWriteEvent.address = string.substring(n3 + 1);
            socketWriteEvent.port = this.remoteAddress.getPort();
            socketWriteEvent.bytesWritten = l;
            socketWriteEvent.commit();
        }
        return l;
    }
}

