/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.control.GlobalMenuAdapter;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import com.sun.javafx.stage.StageHelper;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class MenuBarSkin
extends BehaviorSkinBase<MenuBar, BehaviorBase<MenuBar>>
implements TraverseListener {
    private final HBox container;
    private Menu openMenu;
    private MenuBarButton openMenuButton;
    private int focusedMenuIndex = -1;
    private static WeakHashMap<Stage, Reference<MenuBarSkin>> systemMenuMap;
    private static List<MenuBase> wrappedDefaultMenus;
    private static Stage currentMenuBarStage;
    private List<MenuBase> wrappedMenus;
    private WeakEventHandler<KeyEvent> weakSceneKeyEventHandler;
    private WeakEventHandler<MouseEvent> weakSceneMouseEventHandler;
    private WeakChangeListener<Boolean> weakWindowFocusListener;
    private WeakChangeListener<Window> weakWindowSceneListener;
    private EventHandler<KeyEvent> keyEventHandler;
    private EventHandler<MouseEvent> mouseEventHandler;
    private ChangeListener<Boolean> menuBarFocusedPropertyListener;
    private ChangeListener<Scene> sceneChangeListener;
    Runnable firstMenuRunnable = new Runnable(){

        @Override
        public void run() {
            if (MenuBarSkin.this.container.getChildren().size() > 0 && MenuBarSkin.this.container.getChildren().get(0) instanceof MenuButton) {
                if (MenuBarSkin.this.focusedMenuIndex != 0) {
                    MenuBarSkin.this.unSelectMenus();
                    MenuBarSkin.this.menuModeStart(0);
                    MenuBarSkin.this.openMenuButton = (MenuBarButton)MenuBarSkin.this.container.getChildren().get(0);
                    MenuBarSkin.this.openMenu = (Menu)((MenuBar)MenuBarSkin.this.getSkinnable()).getMenus().get(0);
                    MenuBarSkin.this.openMenuButton.setHover();
                } else {
                    MenuBarSkin.this.unSelectMenus();
                }
            }
        }
    };
    private boolean pendingDismiss = false;
    private EventHandler<ActionEvent> menuActionEventHandler = actionEvent -> {
        CustomMenuItem customMenuItem;
        if (actionEvent.getSource() instanceof CustomMenuItem && !(customMenuItem = (CustomMenuItem)actionEvent.getSource()).isHideOnClick()) {
            return;
        }
        this.unSelectMenus();
    };
    private ListChangeListener<MenuItem> menuItemListener = change -> {
        while (change.next()) {
            for (MenuItem menuItem : change.getAddedSubList()) {
                menuItem.addEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
            }
            for (MenuItem menuItem : change.getRemoved()) {
                menuItem.removeEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
            }
        }
    };

    public static void setDefaultSystemMenuBar(MenuBar menuBar) {
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            wrappedDefaultMenus.clear();
            for (Menu menu : menuBar.getMenus()) {
                wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
            }
            menuBar.getMenus().addListener(change -> {
                wrappedDefaultMenus.clear();
                for (Menu menu : menuBar.getMenus()) {
                    wrappedDefaultMenus.add(GlobalMenuAdapter.adapt(menu));
                }
            });
        }
    }

    private static MenuBarSkin getMenuBarSkin(Stage stage) {
        if (systemMenuMap == null) {
            return null;
        }
        Reference<MenuBarSkin> reference = systemMenuMap.get(stage);
        return reference == null ? null : reference.get();
    }

    private static void setSystemMenu(Stage stage) {
        List<MenuBase> list;
        if (stage != null && stage.isFocused()) {
            while (stage != null && stage.getOwner() instanceof Stage && ((list = MenuBarSkin.getMenuBarSkin(stage)) == null || ((MenuBarSkin)((Object)list)).wrappedMenus == null)) {
                stage = (Stage)stage.getOwner();
            }
        } else {
            stage = null;
        }
        if (stage != currentMenuBarStage) {
            MenuBarSkin menuBarSkin;
            list = null;
            if (stage != null && (menuBarSkin = MenuBarSkin.getMenuBarSkin(stage)) != null) {
                list = menuBarSkin.wrappedMenus;
            }
            if (list == null) {
                list = wrappedDefaultMenus;
            }
            Toolkit.getToolkit().getSystemMenu().setMenus(list);
            currentMenuBarStage = stage;
        }
    }

    private static void initSystemMenuBar() {
        systemMenuMap = new WeakHashMap();
        InvalidationListener invalidationListener = observable -> MenuBarSkin.setSystemMenu((Stage)((ReadOnlyProperty)observable).getBean());
        ObservableList<Stage> observableList = StageHelper.getStages();
        for (Stage stage : observableList) {
            stage.focusedProperty().addListener(invalidationListener);
        }
        observableList.addListener(change -> {
            while (change.next()) {
                for (Stage stage : change.getRemoved()) {
                    stage.focusedProperty().removeListener(invalidationListener);
                }
                for (Stage stage : change.getAddedSubList()) {
                    stage.focusedProperty().addListener(invalidationListener);
                    MenuBarSkin.setSystemMenu(stage);
                }
            }
        });
    }

    EventHandler<KeyEvent> getKeyEventHandler() {
        return this.keyEventHandler;
    }

    public MenuBarSkin(MenuBar menuBar) {
        super(menuBar, new BehaviorBase<MenuBar>(menuBar, Collections.emptyList()));
        String string;
        this.container = new HBox();
        this.container.getStyleClass().add("container");
        this.getChildren().add(this.container);
        this.keyEventHandler = keyEvent -> {
            if (this.openMenu != null) {
                switch (keyEvent.getCode()) {
                    case LEFT: {
                        boolean bl;
                        boolean bl2 = bl = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                        if (menuBar.getScene().getWindow().isFocused()) {
                            if (this.openMenu == null) {
                                return;
                            }
                            if (!this.openMenu.isShowing()) {
                                if (bl) {
                                    this.selectNextMenu();
                                } else {
                                    this.selectPrevMenu();
                                }
                                keyEvent.consume();
                                return;
                            }
                            if (bl) {
                                this.showNextMenu();
                            } else {
                                this.showPrevMenu();
                            }
                        }
                        keyEvent.consume();
                        break;
                    }
                    case RIGHT: {
                        boolean bl;
                        boolean bl3 = bl = menuBar.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
                        if (menuBar.getScene().getWindow().isFocused()) {
                            if (this.openMenu == null) {
                                return;
                            }
                            if (!this.openMenu.isShowing()) {
                                if (bl) {
                                    this.selectPrevMenu();
                                } else {
                                    this.selectNextMenu();
                                }
                                keyEvent.consume();
                                return;
                            }
                            if (bl) {
                                this.showPrevMenu();
                            } else {
                                this.showNextMenu();
                            }
                        }
                        keyEvent.consume();
                        break;
                    }
                    case DOWN: {
                        if (!menuBar.getScene().getWindow().isFocused() || this.focusedMenuIndex == -1 || this.openMenu == null) break;
                        this.openMenu = (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
                        if (!this.isMenuEmpty((Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex))) {
                            this.openMenu.show();
                        }
                        keyEvent.consume();
                        break;
                    }
                    case ESCAPE: {
                        this.unSelectMenus();
                        keyEvent.consume();
                        break;
                    }
                }
            }
        };
        this.menuBarFocusedPropertyListener = (observableValue, bl, bl2) -> {
            if (bl2.booleanValue()) {
                this.unSelectMenus();
                this.menuModeStart(0);
                this.openMenuButton = (MenuBarButton)this.container.getChildren().get(0);
                this.openMenu = (Menu)((MenuBar)this.getSkinnable()).getMenus().get(0);
                this.openMenuButton.setHover();
            } else {
                this.unSelectMenus();
            }
        };
        this.weakSceneKeyEventHandler = new WeakEventHandler<KeyEvent>(this.keyEventHandler);
        Utils.executeOnceWhenPropertyIsNonNull(menuBar.sceneProperty(), scene -> scene.addEventFilter(KeyEvent.KEY_PRESSED, this.weakSceneKeyEventHandler));
        this.mouseEventHandler = mouseEvent -> {
            if (!this.container.localToScene(this.container.getLayoutBounds()).contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.unSelectMenus();
            }
        };
        this.weakSceneMouseEventHandler = new WeakEventHandler<MouseEvent>(this.mouseEventHandler);
        Utils.executeOnceWhenPropertyIsNonNull(menuBar.sceneProperty(), scene -> scene.addEventFilter(MouseEvent.MOUSE_CLICKED, this.weakSceneMouseEventHandler));
        this.weakWindowFocusListener = new WeakChangeListener<Boolean>((observableValue, bl, bl2) -> {
            if (!bl2.booleanValue()) {
                this.unSelectMenus();
            }
        });
        Utils.executeOnceWhenPropertyIsNonNull(menuBar.sceneProperty(), scene -> {
            if (scene.getWindow() != null) {
                scene.getWindow().focusedProperty().addListener(this.weakWindowFocusListener);
            } else {
                ChangeListener<Window> changeListener = (observableValue, window, window2) -> {
                    if (window != null) {
                        window.focusedProperty().removeListener(this.weakWindowFocusListener);
                    }
                    if (window2 != null) {
                        window2.focusedProperty().addListener(this.weakWindowFocusListener);
                    }
                };
                this.weakWindowSceneListener = new WeakChangeListener<Window>(changeListener);
                scene.windowProperty().addListener(this.weakWindowSceneListener);
            }
        });
        this.rebuildUI();
        menuBar.getMenus().addListener(change -> this.rebuildUI());
        for (Menu object2 : ((MenuBar)this.getSkinnable()).getMenus()) {
            object2.visibleProperty().addListener((observableValue, bl, bl2) -> this.rebuildUI());
        }
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            menuBar.useSystemMenuBarProperty().addListener(observable -> this.rebuildUI());
        }
        KeyCombination keyCombination = (string = System.getProperty("os.name")) != null && string.startsWith("Mac") ? KeyCombination.keyCombination("ctrl+F10") : KeyCombination.keyCombination("F10");
        Utils.executeOnceWhenPropertyIsNonNull(menuBar.sceneProperty(), scene -> scene.getAccelerators().put(keyCombination, this.firstMenuRunnable));
        ParentTraversalEngine parentTraversalEngine = new ParentTraversalEngine((Parent)((Object)this.getSkinnable()));
        parentTraversalEngine.addTraverseListener(this);
        ((MenuBar)this.getSkinnable()).setImpl_traversalEngine(parentTraversalEngine);
        menuBar.sceneProperty().addListener((observableValue, scene, scene2) -> {
            if (this.weakSceneKeyEventHandler != null && scene != null) {
                scene.removeEventFilter(KeyEvent.KEY_PRESSED, this.weakSceneKeyEventHandler);
            }
            if (this.weakSceneMouseEventHandler != null && scene != null) {
                scene.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.weakSceneMouseEventHandler);
            }
            if (scene != null) {
                scene.getAccelerators().remove(keyCombination);
            }
            if (scene2 != null) {
                scene2.getAccelerators().put(keyCombination, this.firstMenuRunnable);
            }
        });
    }

    MenuButton getNodeForMenu(int n) {
        if (n < this.container.getChildren().size()) {
            return (MenuBarButton)this.container.getChildren().get(n);
        }
        return null;
    }

    int getFocusedMenuIndex() {
        return this.focusedMenuIndex;
    }

    private boolean menusContainCustomMenuItem() {
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            if (!this.menuContainsCustomMenuItem(menu)) continue;
            System.err.println("Warning: MenuBar ignored property useSystemMenuBar because menus contain CustomMenuItem");
            return true;
        }
        return false;
    }

    private boolean menuContainsCustomMenuItem(Menu menu) {
        for (MenuItem menuItem : menu.getItems()) {
            if (menuItem instanceof CustomMenuItem && !(menuItem instanceof SeparatorMenuItem)) {
                return true;
            }
            if (!(menuItem instanceof Menu) || !this.menuContainsCustomMenuItem((Menu)menuItem)) continue;
            return true;
        }
        return false;
    }

    private int getMenuBarButtonIndex(MenuBarButton menuBarButton) {
        for (int i = 0; i < this.container.getChildren().size(); ++i) {
            MenuBarButton menuBarButton2 = (MenuBarButton)this.container.getChildren().get(i);
            if (menuBarButton != menuBarButton2) continue;
            return i;
        }
        return -1;
    }

    private void updateActionListeners(Menu menu, boolean bl) {
        if (bl) {
            menu.getItems().addListener(this.menuItemListener);
        } else {
            menu.getItems().removeListener(this.menuItemListener);
        }
        for (MenuItem menuItem : menu.getItems()) {
            if (menuItem instanceof Menu) {
                this.updateActionListeners((Menu)menuItem, bl);
                continue;
            }
            if (bl) {
                menuItem.addEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
                continue;
            }
            menuItem.removeEventHandler(ActionEvent.ACTION, this.menuActionEventHandler);
        }
    }

    private void rebuildUI() {
        MenuBarButton menuBarButton;
        ((MenuBar)this.getSkinnable()).focusedProperty().removeListener(this.menuBarFocusedPropertyListener);
        for (Menu object : ((MenuBar)this.getSkinnable()).getMenus()) {
            this.updateActionListeners(object, false);
        }
        for (Node node : this.container.getChildren()) {
            menuBarButton = (MenuBarButton)node;
            menuBarButton.hide();
            menuBarButton.menu.showingProperty().removeListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().unbind();
            menuBarButton.textProperty().unbind();
            menuBarButton.graphicProperty().unbind();
            menuBarButton.styleProperty().unbind();
            menuBarButton.setSkin(null);
            menuBarButton = null;
        }
        this.container.getChildren().clear();
        if (Toolkit.getToolkit().getSystemMenu().isSupported()) {
            MenuBarSkin menuBarSkin;
            Scene scene3 = ((MenuBar)this.getSkinnable()).getScene();
            if (scene3 != null) {
                if (this.sceneChangeListener == null) {
                    this.sceneChangeListener = (observableValue, scene, scene2) -> {
                        Stage stage;
                        Object object;
                        if (scene != null && scene.getWindow() instanceof Stage && (object = MenuBarSkin.getMenuBarSkin(stage = (Stage)scene.getWindow())) == this) {
                            ((MenuBarSkin)object).wrappedMenus = null;
                            systemMenuMap.remove(stage);
                            if (currentMenuBarStage == stage) {
                                currentMenuBarStage = null;
                                MenuBarSkin.setSystemMenu(stage);
                            }
                        }
                        if (scene2 != null && ((MenuBar)this.getSkinnable()).isUseSystemMenuBar() && !this.menusContainCustomMenuItem() && scene2.getWindow() instanceof Stage) {
                            stage = (Stage)scene2.getWindow();
                            if (systemMenuMap == null) {
                                MenuBarSkin.initSystemMenuBar();
                            }
                            if (this.wrappedMenus == null) {
                                this.wrappedMenus = new ArrayList<MenuBase>();
                                systemMenuMap.put(stage, new WeakReference<MenuBarSkin>(this));
                            } else {
                                this.wrappedMenus.clear();
                            }
                            for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
                                this.wrappedMenus.add(GlobalMenuAdapter.adapt(menu));
                            }
                            currentMenuBarStage = null;
                            MenuBarSkin.setSystemMenu(stage);
                            ((MenuBar)this.getSkinnable()).requestLayout();
                            Platform.runLater(() -> ((MenuBar)this.getSkinnable()).requestLayout());
                        }
                    };
                    ((MenuBar)this.getSkinnable()).sceneProperty().addListener(this.sceneChangeListener);
                }
                this.sceneChangeListener.changed(((MenuBar)this.getSkinnable()).sceneProperty(), scene3, scene3);
                if (currentMenuBarStage != null ? MenuBarSkin.getMenuBarSkin(currentMenuBarStage) == this : ((MenuBar)this.getSkinnable()).isUseSystemMenuBar()) {
                    return;
                }
            } else if (currentMenuBarStage != null && (menuBarSkin = MenuBarSkin.getMenuBarSkin(currentMenuBarStage)) == this) {
                MenuBarSkin.setSystemMenu(null);
            }
        }
        ((MenuBar)this.getSkinnable()).focusedProperty().addListener(this.menuBarFocusedPropertyListener);
        for (Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            if (!menu.isVisible()) continue;
            menuBarButton = new MenuBarButton(this, menu.getText(), menu.getGraphic());
            menuBarButton.setFocusTraversable(false);
            menuBarButton.getStyleClass().add("menu");
            menuBarButton.setStyle(menu.getStyle());
            menuBarButton.setId(menu.getId());
            menuBarButton.getItems().setAll((Collection<MenuItem>)menu.getItems());
            this.container.getChildren().add(menuBarButton);
            menu.getItems().addListener(change -> {
                while (change.next()) {
                    menuBarButton.getItems().removeAll(change.getRemoved());
                    menuBarButton.getItems().addAll(change.getFrom(), change.getAddedSubList());
                }
            });
            menu.getStyleClass().addListener(change -> {
                while (change.next()) {
                    for (int i = change.getFrom(); i < change.getTo(); ++i) {
                        menuBarButton.getStyleClass().add((String)menu.getStyleClass().get(i));
                    }
                    for (String string : change.getRemoved()) {
                        menuBarButton.getStyleClass().remove(string);
                    }
                }
            });
            menu.idProperty().addListener((observableValue, string, string2) -> menuBarButton.setId((String)string2));
            menuBarButton.menuListener = (observableValue, bl, bl2) -> {
                if (menu.isShowing()) {
                    menuBarButton.show();
                    this.menuModeStart(this.container.getChildren().indexOf(menuBarButton));
                } else {
                    menuBarButton.hide();
                }
            };
            menuBarButton.menu = menu;
            menu.showingProperty().addListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().bindBidirectional(menu.disableProperty());
            menuBarButton.textProperty().bind(menu.textProperty());
            menuBarButton.graphicProperty().bind(menu.graphicProperty());
            menuBarButton.styleProperty().bind(menu.styleProperty());
            menuBarButton.getProperties().addListener(change -> {
                if (change.wasAdded() && "autoHide".equals(change.getKey())) {
                    menuBarButton.getProperties().remove("autoHide");
                    menu.hide();
                }
            });
            menuBarButton.showingProperty().addListener((observableValue, bl, bl2) -> {
                if (bl2.booleanValue()) {
                    if (this.openMenuButton != null && this.openMenuButton != menuBarButton) {
                        this.openMenuButton.hide();
                    }
                    this.openMenuButton = menuBarButton;
                    this.openMenu = menu;
                    if (!menu.isShowing()) {
                        menu.show();
                    }
                }
            });
            menuBarButton.setOnMousePressed(mouseEvent -> {
                this.pendingDismiss = menuBarButton.isShowing();
                if (menuBarButton.getScene().getWindow().isFocused()) {
                    this.openMenu = menu;
                    if (!this.isMenuEmpty(menu)) {
                        this.openMenu.show();
                    }
                    this.menuModeStart(this.getMenuBarButtonIndex(menuBarButton));
                }
            });
            menuBarButton.setOnMouseReleased(mouseEvent -> {
                if (menuBarButton.getScene().getWindow().isFocused() && this.pendingDismiss) {
                    this.resetOpenMenu();
                }
                this.pendingDismiss = false;
            });
            menuBarButton.setOnMouseEntered(mouseEvent -> {
                if (menuBarButton.getScene() != null && menuBarButton.getScene().getWindow() != null && menuBarButton.getScene().getWindow().isFocused()) {
                    if (this.openMenuButton != null && this.openMenuButton != menuBarButton) {
                        this.openMenuButton.clearHover();
                        this.openMenuButton = null;
                        this.openMenuButton = menuBarButton;
                    }
                    this.updateFocusedIndex();
                    if (this.openMenu != null && this.openMenu != menu) {
                        this.openMenu.hide();
                        this.openMenu = menu;
                        this.updateFocusedIndex();
                        if (!this.isMenuEmpty(menu)) {
                            this.openMenu.show();
                        }
                    }
                }
            });
            this.updateActionListeners(menu, true);
        }
        ((MenuBar)this.getSkinnable()).requestLayout();
    }

    @Override
    public void dispose() {
        this.cleanUpSystemMenu();
        super.dispose();
    }

    private void cleanUpSystemMenu() {
        if (this.sceneChangeListener != null && this.getSkinnable() != null) {
            ((MenuBar)this.getSkinnable()).sceneProperty().removeListener(this.sceneChangeListener);
            this.sceneChangeListener = null;
        }
        if (currentMenuBarStage != null && MenuBarSkin.getMenuBarSkin(currentMenuBarStage) == this) {
            MenuBarSkin.setSystemMenu(null);
        }
        if (systemMenuMap != null) {
            Iterator<Map.Entry<Stage, Reference<MenuBarSkin>>> iterator = systemMenuMap.entrySet().iterator();
            while (iterator.hasNext()) {
                MenuBarSkin menuBarSkin;
                Map.Entry<Stage, Reference<MenuBarSkin>> entry = iterator.next();
                Reference<MenuBarSkin> reference = entry.getValue();
                MenuBarSkin menuBarSkin2 = menuBarSkin = reference != null ? reference.get() : null;
                if (menuBarSkin != null && menuBarSkin != this) continue;
                iterator.remove();
            }
        }
    }

    private boolean isMenuEmpty(Menu menu) {
        boolean bl = true;
        if (menu != null) {
            for (MenuItem menuItem : menu.getItems()) {
                if (menuItem == null || !menuItem.isVisible()) continue;
                bl = false;
            }
        }
        return bl;
    }

    private void resetOpenMenu() {
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.clearHover();
            this.openMenuButton = null;
            this.menuModeEnd();
        }
    }

    private void unSelectMenus() {
        this.clearMenuButtonHover();
        if (this.focusedMenuIndex == -1) {
            return;
        }
        if (this.openMenu != null) {
            this.openMenu.hide();
            this.openMenu = null;
        }
        if (this.openMenuButton != null) {
            this.openMenuButton.clearHover();
            this.openMenuButton = null;
        }
        this.menuModeEnd();
    }

    private void menuModeStart(int n) {
        if (this.focusedMenuIndex == -1) {
            SceneHelper.getSceneAccessor().setTransientFocusContainer(((MenuBar)this.getSkinnable()).getScene(), (Node)((Object)this.getSkinnable()));
        }
        this.focusedMenuIndex = n;
    }

    private void menuModeEnd() {
        if (this.focusedMenuIndex != -1) {
            SceneHelper.getSceneAccessor().setTransientFocusContainer(((MenuBar)this.getSkinnable()).getScene(), null);
        }
        this.focusedMenuIndex = -1;
    }

    private void selectNextMenu() {
        Menu menu = this.findNextSibling();
        if (menu != null && this.focusedMenuIndex != -1) {
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.setHover();
            this.openMenu = menu;
        }
    }

    private void selectPrevMenu() {
        Menu menu = this.findPreviousSibling();
        if (menu != null && this.focusedMenuIndex != -1) {
            this.openMenuButton = (MenuBarButton)this.container.getChildren().get(this.focusedMenuIndex);
            this.openMenuButton.setHover();
            this.openMenu = menu;
        }
    }

    private void showNextMenu() {
        Menu menu = this.findNextSibling();
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.openMenu = menu;
        if (!this.isMenuEmpty(menu)) {
            this.openMenu.show();
        }
    }

    private void showPrevMenu() {
        Menu menu = this.findPreviousSibling();
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.openMenu = menu;
        if (!this.isMenuEmpty(menu)) {
            this.openMenu.show();
        }
    }

    private Menu findPreviousSibling() {
        if (this.focusedMenuIndex == -1) {
            return null;
        }
        this.focusedMenuIndex = this.focusedMenuIndex == 0 ? this.container.getChildren().size() - 1 : --this.focusedMenuIndex;
        if (((Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex)).isDisable()) {
            return this.findPreviousSibling();
        }
        this.clearMenuButtonHover();
        return (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
    }

    private Menu findNextSibling() {
        if (this.focusedMenuIndex == -1) {
            return null;
        }
        this.focusedMenuIndex = this.focusedMenuIndex == this.container.getChildren().size() - 1 ? 0 : ++this.focusedMenuIndex;
        if (((Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex)).isDisable()) {
            return this.findNextSibling();
        }
        this.clearMenuButtonHover();
        return (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
    }

    private void updateFocusedIndex() {
        int n = 0;
        for (Node node : this.container.getChildren()) {
            if (node.isHover()) {
                this.focusedMenuIndex = n;
                return;
            }
            ++n;
        }
        this.menuModeEnd();
    }

    private void clearMenuButtonHover() {
        for (Node node : this.container.getChildren()) {
            if (!node.isHover()) continue;
            ((MenuBarButton)node).clearHover();
            return;
        }
    }

    @Override
    public void onTraverse(Node node, Bounds bounds) {
        if (this.openMenu != null) {
            this.openMenu.hide();
        }
        this.focusedMenuIndex = 0;
    }

    @Override
    protected double snappedTopInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedTopInset();
    }

    @Override
    protected double snappedBottomInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedBottomInset();
    }

    @Override
    protected double snappedLeftInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedLeftInset();
    }

    @Override
    protected double snappedRightInset() {
        return this.container.getChildren().isEmpty() ? 0.0 : super.snappedRightInset();
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        this.container.resizeRelocate(d, d2, d3, d4);
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        return this.container.minWidth(d) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        return this.container.prefWidth(d) + this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        return this.container.minHeight(d) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        return this.container.prefHeight(d) + this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        return ((MenuBar)this.getSkinnable()).prefHeight(-1.0);
    }

    static {
        wrappedDefaultMenus = new ArrayList<MenuBase>();
    }

    static class MenuBarButton
    extends MenuButton {
        private ChangeListener<Boolean> menuListener;
        private MenuBarSkin menuBarSkin;
        private Menu menu;

        public MenuBarButton(MenuBarSkin menuBarSkin, String string, Node node) {
            super(string, node);
            this.menuBarSkin = menuBarSkin;
        }

        public MenuBarSkin getMenuBarSkin() {
            return this.menuBarSkin;
        }

        private void clearHover() {
            this.setHover(false);
        }

        private void setHover() {
            this.setHover(true);
        }
    }
}

