/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.tk.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javafx.embed.swing.DataFlavorUtils;
import javafx.embed.swing.SwingDnD;
import javafx.scene.input.TransferMode;

final class SwingDragSource
implements EmbeddedSceneDSInterface {
    private int sourceActions;
    private Map<String, Object> mimeType2Data = Collections.EMPTY_MAP;

    SwingDragSource() {
    }

    void updateContents(DropTargetDragEvent dropTargetDragEvent, boolean bl) {
        this.sourceActions = dropTargetDragEvent.getSourceActions();
        this.updateData(dropTargetDragEvent.getTransferable(), bl);
    }

    void updateContents(DropTargetDropEvent dropTargetDropEvent, boolean bl) {
        this.sourceActions = dropTargetDropEvent.getSourceActions();
        this.updateData(dropTargetDropEvent.getTransferable(), bl);
    }

    private void updateData(Transferable transferable, boolean bl) {
        Map<String, DataFlavor> map = DataFlavorUtils.adjustSwingDataFlavors(transferable.getTransferDataFlavors());
        try {
            this.mimeType2Data = DataFlavorUtils.readAllData(transferable, map, bl);
        }
        catch (Exception exception) {
            this.mimeType2Data = Collections.EMPTY_MAP;
        }
    }

    @Override
    public Set<TransferMode> getSupportedActions() {
        assert (Toolkit.getToolkit().isFxUserThread());
        return SwingDnD.dropActionsToTransferModes(this.sourceActions);
    }

    @Override
    public Object getData(String string) {
        assert (Toolkit.getToolkit().isFxUserThread());
        return this.mimeType2Data.get(string);
    }

    @Override
    public String[] getMimeTypes() {
        assert (Toolkit.getToolkit().isFxUserThread());
        return this.mimeType2Data.keySet().toArray(new String[0]);
    }

    @Override
    public boolean isMimeTypeAvailable(String string) {
        assert (Toolkit.getToolkit().isFxUserThread());
        return Arrays.asList(this.getMimeTypes()).contains(string);
    }

    @Override
    public void dragDropEnd(TransferMode transferMode) {
        throw new UnsupportedOperationException();
    }
}

