/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.converters.BooleanConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.NamedArg;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Duration;

public class StackedAreaChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart.Series<X, Y>, DoubleProperty> seriesYMultiplierMap = new HashMap<XYChart.Series<X, Y>, DoubleProperty>();
    private Legend legend = new Legend();
    private BooleanProperty createSymbols = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            for (int i = 0; i < StackedAreaChart.this.getData().size(); ++i) {
                XYChart.Series series = (XYChart.Series)StackedAreaChart.this.getData().get(i);
                for (int j = 0; j < series.getData().size(); ++j) {
                    XYChart.Data data = (XYChart.Data)series.getData().get(j);
                    Node node = data.getNode();
                    if (this.get() && node == null) {
                        node = StackedAreaChart.this.createSymbol(series, StackedAreaChart.this.getData().indexOf(series), data, j);
                        if (null == node) continue;
                        StackedAreaChart.this.getPlotChildren().add(node);
                        continue;
                    }
                    if (this.get() || node == null) continue;
                    StackedAreaChart.this.getPlotChildren().remove(node);
                    node = null;
                    data.setNode(null);
                }
            }
            StackedAreaChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return this;
        }

        @Override
        public String getName() {
            return "createSymbols";
        }

        @Override
        public CssMetaData getCssMetaData() {
            return StyleableProperties.CREATE_SYMBOLS;
        }
    };

    public final boolean getCreateSymbols() {
        return this.createSymbols.getValue();
    }

    public final void setCreateSymbols(boolean bl) {
        this.createSymbols.setValue(bl);
    }

    public final BooleanProperty createSymbolsProperty() {
        return this.createSymbols;
    }

    public StackedAreaChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public StackedAreaChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> observableList) {
        super(axis, axis2);
        this.setLegend(this.legend);
        this.setData(observableList);
    }

    private static double doubleValue(Number number) {
        return StackedAreaChart.doubleValue(number, 0.0);
    }

    private static double doubleValue(Number number, double d) {
        return number == null ? d : number.doubleValue();
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int n, XYChart.Data<X, Y> data) {
        Node node = this.createSymbol(series, this.getData().indexOf(series), data, n);
        if (this.shouldAnimate()) {
            boolean bl = false;
            if (n > 0 && n < series.getData().size() - 1) {
                bl = true;
                XYChart.Data data2 = (XYChart.Data)series.getData().get(n - 1);
                XYChart.Data data3 = (XYChart.Data)series.getData().get(n + 1);
                double d = this.getXAxis().toNumericValue(data2.getXValue());
                double d2 = this.getYAxis().toNumericValue(data2.getYValue());
                double d3 = this.getXAxis().toNumericValue(data3.getXValue());
                double d4 = this.getYAxis().toNumericValue(data3.getYValue());
                double d5 = this.getXAxis().toNumericValue(data.getXValue());
                double d6 = this.getYAxis().toNumericValue(data.getYValue());
                double d7 = (d4 - d2) / (d3 - d) * d5 + (d3 * d2 - d4 * d) / (d3 - d);
                data.setCurrentY(this.getYAxis().toRealValue(d7));
                data.setCurrentX(this.getXAxis().toRealValue(d5));
            } else if (n == 0 && series.getData().size() > 1) {
                bl = true;
                data.setCurrentX(((XYChart.Data)series.getData().get(1)).getXValue());
                data.setCurrentY(((XYChart.Data)series.getData().get(1)).getYValue());
            } else if (n == series.getData().size() - 1 && series.getData().size() > 1) {
                bl = true;
                int n2 = series.getData().size() - 2;
                data.setCurrentX(((XYChart.Data)series.getData().get(n2)).getXValue());
                data.setCurrentY(((XYChart.Data)series.getData().get(n2)).getYValue());
            } else if (node != null) {
                node.setOpacity(0.0);
                this.getPlotChildren().add(node);
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(500.0), node);
                fadeTransition.setToValue(1.0);
                fadeTransition.play();
            }
            if (bl) {
                this.animate(new KeyFrame(Duration.ZERO, actionEvent -> {
                    if (!this.getPlotChildren().contains(node)) {
                        this.getPlotChildren().add(node);
                    }
                }, new KeyValue(data.currentYProperty(), data.getCurrentY()), new KeyValue(data.currentXProperty(), data.getCurrentX())), new KeyFrame(Duration.millis(800.0), new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(data.currentXProperty(), data.getXValue(), Interpolator.EASE_BOTH)));
            }
        } else if (node != null) {
            this.getPlotChildren().add(node);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<X, Y> data, XYChart.Series<X, Y> series) {
        Node node = data.getNode();
        int n = series.getItemIndex(data);
        if (this.shouldAnimate()) {
            boolean bl = false;
            if (n > 0 && n < series.getDataSize()) {
                bl = true;
                XYChart.Data data2 = series.begin;
                for (int i = 0; data2 != null && i != n - 1; ++i) {
                    data2 = data2.next;
                }
                XYChart.Data data3 = data2;
                XYChart.Data data4 = data2.next.next;
                if (data4 == null) {
                    return;
                }
                double d = this.getXAxis().toNumericValue(data3.getXValue());
                double d2 = this.getYAxis().toNumericValue(data3.getYValue());
                double d3 = this.getXAxis().toNumericValue(data4.getXValue());
                double d4 = this.getYAxis().toNumericValue(data4.getYValue());
                double d5 = this.getXAxis().toNumericValue(data.getXValue());
                double d6 = this.getYAxis().toNumericValue(data.getYValue());
                double d7 = (d4 - d2) / (d3 - d) * d5 + (d3 * d2 - d4 * d) / (d3 - d);
                data.setCurrentX(this.getXAxis().toRealValue(d5));
                data.setCurrentY(this.getYAxis().toRealValue(d6));
                data.setXValue(this.getXAxis().toRealValue(d5));
                data.setYValue(this.getYAxis().toRealValue(d7));
            } else if (n == 0 && series.getDataSize() > 1) {
                bl = true;
                data.setXValue(((XYChart.Data)series.getData().get(0)).getXValue());
                data.setYValue(((XYChart.Data)series.getData().get(0)).getYValue());
            } else if (n == series.getDataSize() - 1 && series.getDataSize() > 1) {
                bl = true;
                int n2 = series.getData().size() - 1;
                data.setXValue(((XYChart.Data)series.getData().get(n2)).getXValue());
                data.setYValue(((XYChart.Data)series.getData().get(n2)).getYValue());
            } else {
                node.setOpacity(0.0);
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(500.0), node);
                fadeTransition.setToValue(0.0);
                fadeTransition.setOnFinished(actionEvent -> {
                    this.getPlotChildren().remove(node);
                    this.removeDataItemFromDisplay(series, data);
                    node.setOpacity(1.0);
                });
                fadeTransition.play();
            }
            if (bl) {
                this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentYProperty(), data.getCurrentY()), new KeyValue(data.currentXProperty(), data.getCurrentX())), new KeyFrame(Duration.millis(800.0), actionEvent -> {
                    this.getPlotChildren().remove(node);
                    this.removeDataItemFromDisplay(series, data);
                }, new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(data.currentXProperty(), data.getXValue(), Interpolator.EASE_BOTH)));
            }
        } else {
            this.getPlotChildren().remove(node);
            this.removeDataItemFromDisplay(series, data);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> data) {
    }

    @Override
    protected void seriesChanged(ListChangeListener.Change<? extends XYChart.Series> change) {
        for (int i = 0; i < this.getDataSize(); ++i) {
            XYChart.Series series = (XYChart.Series)this.getData().get(i);
            Path path = (Path)((Group)series.getNode()).getChildren().get(1);
            Path path2 = (Path)((Group)series.getNode()).getChildren().get(0);
            path.getStyleClass().setAll((String[])new String[]{"chart-series-area-line", "series" + i, series.defaultColorStyleClass});
            path2.getStyleClass().setAll((String[])new String[]{"chart-series-area-fill", "series" + i, series.defaultColorStyleClass});
            for (int j = 0; j < series.getData().size(); ++j) {
                XYChart.Data data = (XYChart.Data)series.getData().get(j);
                Node node = data.getNode();
                if (node == null) continue;
                node.getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + i, "data" + j, series.defaultColorStyleClass});
            }
        }
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int n) {
        Path path = new Path();
        Path path2 = new Path();
        path.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        path2.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        Group group = new Group(path2, path);
        series.setNode(group);
        SimpleDoubleProperty simpleDoubleProperty = new SimpleDoubleProperty(this, "seriesYMultiplier");
        this.seriesYMultiplierMap.put(series, simpleDoubleProperty);
        if (this.shouldAnimate()) {
            simpleDoubleProperty.setValue(0.0);
        } else {
            simpleDoubleProperty.setValue(1.0);
        }
        this.getPlotChildren().add(group);
        ArrayList<KeyFrame> arrayList = new ArrayList<KeyFrame>();
        if (this.shouldAnimate()) {
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(group.opacityProperty(), 0), new KeyValue(simpleDoubleProperty, 0)));
            arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(group.opacityProperty(), 1)));
            arrayList.add(new KeyFrame(Duration.millis(500.0), new KeyValue(simpleDoubleProperty, 1)));
        }
        for (int i = 0; i < series.getData().size(); ++i) {
            XYChart.Data data = (XYChart.Data)series.getData().get(i);
            Node node = this.createSymbol(series, n, data, i);
            if (node == null) continue;
            if (this.shouldAnimate()) {
                node.setOpacity(0.0);
            }
            this.getPlotChildren().add(node);
            if (!this.shouldAnimate()) continue;
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(node.opacityProperty(), 0)));
            arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(node.opacityProperty(), 1)));
        }
        if (this.shouldAnimate()) {
            this.animate(arrayList.toArray(new KeyFrame[arrayList.size()]));
        }
    }

    @Override
    protected void seriesRemoved(XYChart.Series<X, Y> series) {
        this.seriesYMultiplierMap.remove(series);
        if (this.shouldAnimate()) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.add(series.getNode());
            for (XYChart.Data data : series.getData()) {
                arrayList.add(data.getNode());
            }
            if (this.getCreateSymbols()) {
                KeyValue[] data = new KeyValue[arrayList.size()];
                KeyValue[] keyValueArray = new KeyValue[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    data[i] = new KeyValue(((Node)arrayList.get(i)).opacityProperty(), 1);
                    keyValueArray[i] = new KeyValue(((Node)arrayList.get(i)).opacityProperty(), 0);
                }
                Timeline timeline = new Timeline();
                timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, data), new KeyFrame(Duration.millis(400.0), actionEvent -> {
                    this.getPlotChildren().removeAll((Collection<?>)arrayList);
                    this.removeSeriesFromDisplay(series);
                }, keyValueArray)});
                timeline.play();
            } else {
                Timeline timeline = new Timeline();
                timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(400.0), actionEvent -> {
                    this.getPlotChildren().removeAll((Collection<?>)arrayList);
                    this.removeSeriesFromDisplay(series);
                }, new KeyValue[0])});
                timeline.play();
            }
        } else {
            this.getPlotChildren().remove(series.getNode());
            for (XYChart.Data data : series.getData()) {
                this.getPlotChildren().remove(data.getNode());
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    @Override
    protected void updateAxisRange() {
        Axis axis = this.getXAxis();
        Axis axis2 = this.getYAxis();
        if (axis.isAutoRanging()) {
            ArrayList arrayList = new ArrayList();
            for (XYChart.Series object : this.getData()) {
                for (XYChart.Data data : object.getData()) {
                    arrayList.add(data.getXValue());
                }
            }
            axis.invalidateRange(arrayList);
        }
        if (axis2.isAutoRanging()) {
            double d = Double.MAX_VALUE;
            Iterator iterator = this.getDisplayedSeriesIterator();
            boolean bl = true;
            TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
            TreeMap<Double, Double> treeMap2 = new TreeMap<Double, Double>();
            TreeMap<Double, Double> treeMap3 = new TreeMap<Double, Double>();
            while (iterator.hasNext()) {
                treeMap3.clear();
                XYChart.Series series = iterator.next();
                for (XYChart.Data data : series.getData()) {
                    if (data == null) continue;
                    double d2 = axis.toNumericValue(data.getXValue());
                    double d3 = axis2.toNumericValue(data.getYValue());
                    treeMap3.put(d2, d3);
                    if (bl) {
                        treeMap.put(d2, d3);
                        d = Math.min(d, d3);
                        continue;
                    }
                    if (treeMap2.containsKey(d2)) {
                        treeMap.put(d2, (Double)treeMap2.get(d2) + d3);
                        continue;
                    }
                    Map.Entry entry = treeMap2.higherEntry(d2);
                    Map.Entry entry2 = treeMap2.lowerEntry(d2);
                    if (entry != null && entry2 != null) {
                        treeMap.put(d2, (d2 - entry2.getKey()) / (entry.getKey() - entry2.getKey()) * ((Double)entry2.getValue() + (Double)entry.getValue()) + d3);
                        continue;
                    }
                    if (entry != null) {
                        treeMap.put(d2, (Double)entry.getValue() + d3);
                        continue;
                    }
                    if (entry2 != null) {
                        treeMap.put(d2, (Double)entry2.getValue() + d3);
                        continue;
                    }
                    treeMap.put(d2, d3);
                }
                for (Map.Entry entry : treeMap2.entrySet()) {
                    if (treeMap.keySet().contains(entry.getKey())) continue;
                    Double d4 = (Double)entry.getKey();
                    Double d5 = (Double)entry.getValue();
                    Map.Entry entry3 = treeMap3.higherEntry(d4);
                    Map.Entry entry4 = treeMap3.lowerEntry(d4);
                    if (entry3 != null && entry4 != null) {
                        treeMap.put(d4, (d4 - entry4.getKey()) / (entry3.getKey() - entry4.getKey()) * ((Double)entry4.getValue() + (Double)entry3.getValue()) + d5);
                        continue;
                    }
                    if (entry3 != null) {
                        treeMap.put(d4, (Double)entry3.getValue() + d5);
                        continue;
                    }
                    if (entry4 != null) {
                        treeMap.put(d4, (Double)entry4.getValue() + d5);
                        continue;
                    }
                    treeMap.put(d4, d5);
                }
                treeMap2.clear();
                treeMap2.putAll(treeMap);
                treeMap.clear();
                bl = d == Double.MAX_VALUE;
            }
            if (d != Double.MAX_VALUE) {
                axis2.invalidateRange(Arrays.asList(axis2.toRealValue(d), axis2.toRealValue((Double)Collections.max(treeMap2.values()))));
            }
        }
    }

    @Override
    protected void layoutPlotChildren() {
        ArrayList arrayList = new ArrayList();
        ArrayList<DataPointInfo<X, Y>> arrayList2 = new ArrayList<DataPointInfo<X, Y>>();
        for (int i = 0; i < this.getDataSize(); ++i) {
            XYChart.Series series = (XYChart.Series)this.getData().get(i);
            arrayList2.clear();
            for (DataPointInfo dataPointInfo : arrayList) {
                dataPointInfo.partOf = PartOf.PREVIOUS;
                arrayList2.add(dataPointInfo);
            }
            arrayList.clear();
            XYChart.Data data = series.begin;
            while (data != null) {
                DataPointInfo dataPointInfo = new DataPointInfo(data, data.getXValue(), data.getYValue(), PartOf.CURRENT);
                arrayList2.add(dataPointInfo);
                data = data.next;
            }
            data = this.seriesYMultiplierMap.get(series);
            Path object2 = (Path)((Group)series.getNode()).getChildren().get(1);
            Path path = (Path)((Group)series.getNode()).getChildren().get(0);
            object2.getElements().clear();
            path.getElements().clear();
            int n = 0;
            this.sortAggregateList(arrayList2);
            boolean bl = false;
            boolean bl2 = false;
            int n2 = this.findNextCurrent(arrayList2, -1);
            int n3 = this.findPreviousCurrent(arrayList2, arrayList2.size());
            for (DataPointInfo<X, Y> dataPointInfo : arrayList2) {
                DataPointInfo<X, Y> dataPointInfo2;
                DataPointInfo<X, Y> dataPointInfo3;
                int n4;
                int n5;
                if (n == n3) {
                    bl2 = true;
                }
                if (n == n2) {
                    bl = true;
                }
                double d = 0.0;
                double d2 = 0.0;
                DataPointInfo dataPointInfo4 = new DataPointInfo();
                DataPointInfo dataPointInfo5 = new DataPointInfo(true);
                XYChart.Data data2 = dataPointInfo.dataItem;
                if (dataPointInfo.partOf.equals((Object)PartOf.CURRENT)) {
                    n5 = this.findPreviousPrevious(arrayList2, n);
                    n4 = this.findNextPrevious(arrayList2, n);
                    if (n5 == -1 || n4 == -1 && !arrayList2.get((int)n5).x.equals(dataPointInfo.x)) {
                        if (bl) {
                            data2 = new XYChart.Data(dataPointInfo.x, 0);
                            d = this.getXAxis().getDisplayPosition(data2.getCurrentX());
                            d2 = this.getYAxis().getZeroPosition();
                            dataPointInfo5.setValues(data2, data2.getXValue(), data2.getYValue(), d, d2, PartOf.CURRENT, true, false);
                            arrayList.add(dataPointInfo5);
                        }
                        data2 = dataPointInfo.dataItem;
                        d = this.getXAxis().getDisplayPosition(data2.getCurrentX());
                        d2 = this.getYAxis().getDisplayPosition(this.getYAxis().toRealValue(this.getYAxis().toNumericValue(data2.getCurrentY()) * ((DoubleExpression)((Object)data)).getValue()));
                        dataPointInfo4.setValues(data2, data2.getXValue(), data2.getYValue(), d, d2, PartOf.CURRENT, false, !bl);
                        arrayList.add(dataPointInfo4);
                        if (n == n3) {
                            data2 = new XYChart.Data(dataPointInfo.x, 0);
                            d = this.getXAxis().getDisplayPosition(data2.getCurrentX());
                            d2 = this.getYAxis().getZeroPosition();
                            dataPointInfo5.setValues(data2, data2.getXValue(), data2.getYValue(), d, d2, PartOf.CURRENT, true, false);
                            arrayList.add(dataPointInfo5);
                        }
                    } else {
                        dataPointInfo3 = arrayList2.get(n5);
                        if (dataPointInfo3.x.equals(dataPointInfo.x)) {
                            DataPointInfo<X, Y> dataPointInfo6 = dataPointInfo3;
                            if (dataPointInfo3.dropDown) {
                                n5 = this.findPreviousPrevious(arrayList2, n5);
                                dataPointInfo3 = arrayList2.get(n5);
                            }
                            if (dataPointInfo3.x.equals(dataPointInfo.x)) {
                                d = this.getXAxis().getDisplayPosition(data2.getCurrentX());
                                d2 = this.getYAxis().getDisplayPosition(this.getYAxis().toRealValue(this.getYAxis().toNumericValue(data2.getCurrentY()) * ((DoubleExpression)((Object)data)).getValue()));
                                dataPointInfo4.setValues(data2, dataPointInfo.x, dataPointInfo.y, d, d2 += -(this.getYAxis().getZeroPosition() - dataPointInfo3.displayY), PartOf.CURRENT, false, !bl);
                                arrayList.add(dataPointInfo4);
                            }
                            if (bl2) {
                                dataPointInfo5.setValues(dataPointInfo6.dataItem, dataPointInfo6.x, dataPointInfo6.y, dataPointInfo6.displayX, dataPointInfo6.displayY, PartOf.CURRENT, true, false);
                                arrayList.add(dataPointInfo5);
                            }
                        } else {
                            dataPointInfo2 = n4 == -1 ? null : arrayList2.get(n4);
                            dataPointInfo3 = n5 == -1 ? null : arrayList2.get(n5);
                            d = this.getXAxis().getDisplayPosition(data2.getCurrentX());
                            d2 = this.getYAxis().getDisplayPosition(this.getYAxis().toRealValue(this.getYAxis().toNumericValue(data2.getCurrentY()) * ((DoubleExpression)((Object)data)).getValue()));
                            if (dataPointInfo3 != null && dataPointInfo2 != null) {
                                double d3 = this.interpolate(dataPointInfo3.displayX, dataPointInfo3.displayY, dataPointInfo2.displayX, dataPointInfo2.displayY, d);
                                d2 += -(this.getYAxis().getZeroPosition() - d3);
                                double d4 = this.interpolate(this.getXAxis().toNumericValue(dataPointInfo3.x), this.getYAxis().toNumericValue(dataPointInfo3.y), this.getXAxis().toNumericValue(dataPointInfo2.x), this.getYAxis().toNumericValue(dataPointInfo2.y), this.getXAxis().toNumericValue(dataPointInfo.x));
                                if (bl) {
                                    data2 = new XYChart.Data(dataPointInfo.x, d4);
                                    dataPointInfo5.setValues(data2, dataPointInfo.x, this.getYAxis().toRealValue(d4), d, d3, PartOf.CURRENT, true, false);
                                    arrayList.add(dataPointInfo5);
                                }
                                dataPointInfo4.setValues(data2, dataPointInfo.x, dataPointInfo.y, d, d2, PartOf.CURRENT, false, !bl);
                                arrayList.add(dataPointInfo4);
                                if (n == n3) {
                                    data2 = new XYChart.Data(dataPointInfo.x, d4);
                                    dataPointInfo5.setValues(data2, dataPointInfo.x, this.getYAxis().toRealValue(d4), d, d3, PartOf.CURRENT, true, false);
                                    arrayList.add(dataPointInfo5);
                                }
                            }
                        }
                    }
                } else {
                    n5 = this.findPreviousCurrent(arrayList2, n);
                    n4 = this.findNextCurrent(arrayList2, n);
                    if (dataPointInfo.dropDown) {
                        if (this.getXAxis().toNumericValue(dataPointInfo.x) <= this.getXAxis().toNumericValue(arrayList2.get((int)n2).x) || this.getXAxis().toNumericValue(dataPointInfo.x) > this.getXAxis().toNumericValue(arrayList2.get((int)n3).x)) {
                            dataPointInfo4.setValues(data2, dataPointInfo.x, dataPointInfo.y, dataPointInfo.displayX, dataPointInfo.displayY, PartOf.CURRENT, true, false);
                            dataPointInfo4.dropDown = true;
                            arrayList.add(dataPointInfo4);
                        }
                    } else if (n5 == -1 || n4 == -1) {
                        dataPointInfo4.setValues(data2, dataPointInfo.x, dataPointInfo.y, dataPointInfo.displayX, dataPointInfo.displayY, PartOf.CURRENT, true, false);
                        arrayList.add(dataPointInfo4);
                    } else {
                        dataPointInfo2 = arrayList2.get(n4);
                        if (!dataPointInfo2.x.equals(dataPointInfo.x)) {
                            dataPointInfo3 = arrayList2.get(n5);
                            d = this.getXAxis().getDisplayPosition(data2.getCurrentX());
                            double d5 = this.interpolate(this.getXAxis().toNumericValue(dataPointInfo3.x), this.getYAxis().toNumericValue(dataPointInfo3.y), this.getXAxis().toNumericValue(dataPointInfo2.x), this.getYAxis().toNumericValue(dataPointInfo2.y), this.getXAxis().toNumericValue(dataPointInfo.x));
                            d2 = this.getYAxis().getDisplayPosition(this.getYAxis().toRealValue(d5 * ((DoubleExpression)((Object)data)).getValue()));
                            dataPointInfo4.setValues(new XYChart.Data(dataPointInfo.x, d5), dataPointInfo.x, this.getYAxis().toRealValue(0.0), d, d2 += -(this.getYAxis().getZeroPosition() - dataPointInfo.displayY), PartOf.CURRENT, true, true);
                            arrayList.add(dataPointInfo4);
                        }
                    }
                }
                ++n;
                if (bl) {
                    bl = false;
                }
                if (!bl2) continue;
                bl2 = false;
            }
            if (!arrayList.isEmpty()) {
                object2.getElements().add(new MoveTo(((DataPointInfo)arrayList.get((int)0)).displayX, ((DataPointInfo)arrayList.get((int)0)).displayY));
                path.getElements().add(new MoveTo(((DataPointInfo)arrayList.get((int)0)).displayX, ((DataPointInfo)arrayList.get((int)0)).displayY));
            }
            for (DataPointInfo<X, Y> dataPointInfo : arrayList) {
                Node node;
                if (!dataPointInfo.lineTo) {
                    object2.getElements().add(new MoveTo(dataPointInfo.displayX, dataPointInfo.displayY));
                } else {
                    object2.getElements().add(new LineTo(dataPointInfo.displayX, dataPointInfo.displayY));
                }
                path.getElements().add(new LineTo(dataPointInfo.displayX, dataPointInfo.displayY));
                if (dataPointInfo.skipSymbol || (node = dataPointInfo.dataItem.getNode()) == null) continue;
                double d = node.prefWidth(-1.0);
                double d6 = node.prefHeight(-1.0);
                node.resizeRelocate(dataPointInfo.displayX - d / 2.0, dataPointInfo.displayY - d6 / 2.0, d, d6);
            }
            for (int j = arrayList2.size() - 1; j > 0; --j) {
                DataPointInfo<X, Y> dataPointInfo;
                dataPointInfo = arrayList2.get(j);
                if (!PartOf.PREVIOUS.equals((Object)dataPointInfo.partOf)) continue;
                path.getElements().add(new LineTo(dataPointInfo.displayX, dataPointInfo.displayY));
            }
            if (path.getElements().isEmpty()) continue;
            path.getElements().add(new ClosePath());
        }
    }

    private int findNextCurrent(ArrayList<DataPointInfo<X, Y>> arrayList, int n) {
        for (int i = n + 1; i < arrayList.size(); ++i) {
            if (!arrayList.get((int)i).partOf.equals((Object)PartOf.CURRENT)) continue;
            return i;
        }
        return -1;
    }

    private int findPreviousCurrent(ArrayList<DataPointInfo<X, Y>> arrayList, int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!arrayList.get((int)i).partOf.equals((Object)PartOf.CURRENT)) continue;
            return i;
        }
        return -1;
    }

    private int findPreviousPrevious(ArrayList<DataPointInfo<X, Y>> arrayList, int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!arrayList.get((int)i).partOf.equals((Object)PartOf.PREVIOUS)) continue;
            return i;
        }
        return -1;
    }

    private int findNextPrevious(ArrayList<DataPointInfo<X, Y>> arrayList, int n) {
        for (int i = n + 1; i < arrayList.size(); ++i) {
            if (!arrayList.get((int)i).partOf.equals((Object)PartOf.PREVIOUS)) continue;
            return i;
        }
        return -1;
    }

    private void sortAggregateList(ArrayList<DataPointInfo<X, Y>> arrayList) {
        Collections.sort(arrayList, (dataPointInfo, dataPointInfo2) -> {
            double d;
            XYChart.Data data = dataPointInfo.dataItem;
            XYChart.Data data2 = dataPointInfo2.dataItem;
            double d2 = this.getXAxis().toNumericValue(data.getXValue());
            return d2 < (d = this.getXAxis().toNumericValue(data2.getXValue())) ? -1 : (d2 == d ? 0 : 1);
        });
    }

    private double interpolate(double d, double d2, double d3, double d4, double d5) {
        return (d4 - d2) / (d3 - d) * (d5 - d) + d2;
    }

    private Node createSymbol(XYChart.Series<X, Y> series, int n, XYChart.Data<X, Y> data, int n2) {
        Node node = data.getNode();
        if (node == null && this.getCreateSymbols()) {
            node = new StackPane();
            data.setNode(node);
        }
        if (node != null) {
            node.getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + n, "data" + n2, series.defaultColorStyleClass});
        }
        return node;
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int i = 0; i < this.getData().size(); ++i) {
                XYChart.Series series = (XYChart.Series)this.getData().get(i);
                Legend.LegendItem legendItem = new Legend.LegendItem(series.getName());
                legendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-area-symbol", "series" + i, "area-legend-symbol", series.defaultColorStyleClass});
                this.legend.getItems().add(legendItem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackedAreaChart.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<StackedAreaChart<?, ?>, Boolean> CREATE_SYMBOLS = new CssMetaData<StackedAreaChart<?, ?>, Boolean>("-fx-create-symbols", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(StackedAreaChart<?, ?> stackedAreaChart) {
                return ((StackedAreaChart)stackedAreaChart).createSymbols == null || !((StackedAreaChart)stackedAreaChart).createSymbols.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(StackedAreaChart<?, ?> stackedAreaChart) {
                return (StyleableProperty)((Object)stackedAreaChart.createSymbolsProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(XYChart.getClassCssMetaData());
            arrayList.add(CREATE_SYMBOLS);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    private static enum PartOf {
        CURRENT,
        PREVIOUS;

    }

    static final class DataPointInfo<X, Y> {
        X x;
        Y y;
        double displayX;
        double displayY;
        XYChart.Data<X, Y> dataItem;
        PartOf partOf;
        boolean skipSymbol = false;
        boolean lineTo = false;
        boolean dropDown = false;

        DataPointInfo() {
        }

        DataPointInfo(XYChart.Data<X, Y> data, X x, Y y, PartOf partOf) {
            this.dataItem = data;
            this.x = x;
            this.y = y;
            this.partOf = partOf;
        }

        DataPointInfo(boolean bl) {
            this.dropDown = bl;
        }

        void setValues(XYChart.Data<X, Y> data, X x, Y y, double d, double d2, PartOf partOf, boolean bl, boolean bl2) {
            this.dataItem = data;
            this.x = x;
            this.y = y;
            this.displayX = d;
            this.displayY = d2;
            this.partOf = partOf;
            this.skipSymbol = bl;
            this.lineTo = bl2;
        }

        public final X getX() {
            return this.x;
        }

        public final Y getY() {
            return this.y;
        }
    }
}

