/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class AccessNode
extends BaseNode {
    private final IdentNode property;

    public AccessNode(long token, int finish, Expression base, IdentNode property) {
        super(token, finish, base, false);
        this.property = property.setIsPropertyName();
    }

    private AccessNode(AccessNode accessNode, Expression base, IdentNode property, boolean isFunction) {
        super(accessNode, base, isFunction);
        this.property = property;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterAccessNode(this)) {
            return visitor.leaveAccessNode(this.setBase((Expression)this.base.accept(visitor)).setProperty((IdentNode)this.property.accept(visitor)));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        boolean needsParen = this.tokenType().needsParens(this.getBase().tokenType(), true);
        if (needsParen) {
            sb.append('(');
        }
        this.base.toString(sb);
        if (needsParen) {
            sb.append(')');
        }
        sb.append('.');
        sb.append(this.property.getName());
    }

    public IdentNode getProperty() {
        return this.property;
    }

    private AccessNode setBase(Expression base) {
        if (this.base == base) {
            return this;
        }
        return new AccessNode(this, base, this.property, this.isFunction());
    }

    private AccessNode setProperty(IdentNode property) {
        if (this.property == property) {
            return this;
        }
        return new AccessNode(this, this.base, property, this.isFunction());
    }

    @Override
    public BaseNode setIsFunction() {
        if (this.isFunction()) {
            return this;
        }
        return new AccessNode(this, this.base, this.property, true);
    }
}

