/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.FirmwareCapsule;
import com.intel.galileo.flash.tool.GalileoFirmwareUpdater;
import com.intel.galileo.flash.tool.GalileoVersion;
import com.intel.galileo.flash.tool.PreferencesPanel;
import com.intel.galileo.flash.tool.UpdateStatusPanel;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

public class FirmwareUpdateAction
extends AbstractAction {
    static final String DIALOG_TITLE = "Intel Galileo Firmware Updater";
    private PreferencesPanel parentPanel;
    private final GalileoFirmwareUpdater galileo;
    private final UpdateStatusPanel status;
    private FirmwareUpdateTask task;
    private boolean runState = false;

    public FirmwareUpdateAction(GalileoFirmwareUpdater galileoFirmwareUpdater, UpdateStatusPanel updateStatusPanel) {
        super("Update Firmware");
        this.galileo = galileoFirmwareUpdater;
        this.status = updateStatusPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        try {
            if (this.galileo.getLocalCapFile() != null) {
                new File(this.galileo.getLocalCapFile().getPath()).exists();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(jComponent, "Invalid cap file, make sure the file exists or you have valid permissions.", DIALOG_TITLE, 0);
            return;
        }
        GalileoVersion galileoVersion = this.galileo.getCurrentBoardVersion();
        if (!this.galileo.isReadyForUpdate()) {
            JOptionPane.showMessageDialog(jComponent, "Preferences not yet properly set", DIALOG_TITLE, 0);
            return;
        }
        int n = JOptionPane.showConfirmDialog(jComponent, "Intel Galileo firmware update requires using the external power supply.", DIALOG_TITLE, 2);
        if (2 == n || -1 == n) {
            this.galileo.getLogger().warning("Update canceled by user");
            return;
        }
        FirmwareCapsule firmwareCapsule = this.galileo.getUpdate();
        GalileoVersion galileoVersion2 = firmwareCapsule.getVersion();
        String string = "Target firmware is version '" + galileoVersion.toPresentationString() + "' now.\n\nDo you wish to ";
        String string2 = galileoVersion.toPresentationString();
        String string3 = galileoVersion2.toPresentationString();
        int n2 = string2.compareTo("1.0.2");
        if (n2 >= 0 && ((n2 = string3.compareTo("1.0.2")) < 0 || string3.compareTo("732") == 0)) {
            JOptionPane.showMessageDialog(jComponent, "The current firmware version " + string2 + " does not accept be downgraded to " + string3 + ".The candidate capsule file must be " + "1.0.2" + " or newer.", DIALOG_TITLE, 0);
            return;
        }
        boolean bl = false;
        try {
            int n3 = galileoVersion2.compareTo(galileoVersion);
            if (n3 < 0) {
                string = string + "update with older";
            } else if (n3 > 0) {
                string = string + "update with newer";
            } else {
                string = string + "rewrite with equivalent";
                bl = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = string + "overwrite with";
        }
        if (!bl) {
            string = string + " version '" + galileoVersion2.toPresentationString() + "'";
        }
        if (1 == (n = JOptionPane.showConfirmDialog(null, string = string + " firmware?", DIALOG_TITLE, 0)) || -1 == n) {
            this.galileo.getLogger().warning("User canceled update");
            return;
        }
        this.task = new FirmwareUpdateTask();
        this.status.setVisible(true);
        this.task.execute();
    }

    public void setPreferencesPanel(PreferencesPanel preferencesPanel) {
        this.parentPanel = preferencesPanel;
    }

    public boolean isRunning() {
        return this.runState;
    }

    class FirmwareUpdateTask
    extends SwingWorker<Boolean, String>
    implements GalileoFirmwareUpdater.ProgressNotification {
        public FirmwareUpdateTask() {
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                        FirmwareUpdateAction.this.status.updateUploadProgress((Integer)propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        @Override
        protected void done() {
            try {
                FirmwareUpdateAction.this.runState = false;
                FirmwareUpdateAction.this.status.setVisible(false);
                FirmwareUpdateAction.this.status.revalidate();
                FirmwareUpdateAction.this.status.repaint();
                FirmwareUpdateAction.this.parentPanel.enableUI();
                boolean bl = (Boolean)this.get();
                String string = bl ? "Target firmware successfully updated." : "Target firmware not updated.";
                int n = bl ? -1 : 0;
                JOptionPane.showMessageDialog(FirmwareUpdateAction.this.status, string, FirmwareUpdateAction.DIALOG_TITLE, n);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                String string = throwable != null ? throwable.getMessage() : executionException.getMessage();
                JOptionPane.showMessageDialog(null, string, FirmwareUpdateAction.DIALOG_TITLE, 0);
            }
        }

        @Override
        protected void process(List<String> list) {
            String string = list.get(list.size() - 1);
            FirmwareUpdateAction.this.status.updateMessage(string);
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            FirmwareUpdateAction.this.runState = true;
            FirmwareUpdateAction.this.parentPanel.disableUI();
            return FirmwareUpdateAction.this.galileo.updateFirmwareOnBoard(this);
        }

        @Override
        public void updateMessage(String string) {
            this.publish(string);
        }

        @Override
        public void updateProgress(int n) {
            this.setProgress(n);
        }
    }
}

