/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.FirmwareCapsule;
import com.intel.galileo.flash.tool.FirmwareUpdateCmdArgs;
import com.intel.galileo.flash.tool.FirmwareUpdateTool;
import com.intel.galileo.flash.tool.GalileoFirmwareUpdater;
import com.intel.galileo.flash.tool.GalileoVersion;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FirmwareUpdateSilent {
    private final FirmwareUpdateCmdArgs _cmdArgs;
    private final GalileoFirmwareUpdater _galileoflash;
    private final String _capBaseVersion;
    private int _systemExitCode;

    FirmwareUpdateSilent(FirmwareUpdateCmdArgs firmwareUpdateCmdArgs) {
        this._cmdArgs = firmwareUpdateCmdArgs;
        this._galileoflash = new GalileoFirmwareUpdater();
        this._capBaseVersion = "1.0.2";
        this._systemExitCode = 9;
    }

    public String _compareBaseFwVer(String string) {
        String string2 = "ERR";
        if (string.equals("732")) {
            string2 = "LT";
        } else {
            if (!this._isVersionForm(string)) {
                return string2;
            }
            int n = string.compareTo(this._capBaseVersion);
            if (n > 0) {
                string2 = "GT";
            } else if (n < 0) {
                string2 = "LT";
            } else if (n == 0) {
                string2 = "EQ";
            }
        }
        return string2;
    }

    private boolean _isVersionForm(String string) {
        boolean bl = false;
        int n = string.indexOf(46);
        if (n == -1) {
            return bl;
        }
        int n2 = n + 1;
        if ((n = string.indexOf(46, n2)) == -1) {
            return bl;
        }
        bl = true;
        return bl;
    }

    private boolean _setCapFile() {
        Object object;
        boolean bl = false;
        URL uRL = null;
        URL uRL2 = null;
        FirmwareCapsule firmwareCapsule = this._galileoflash.getUpdate();
        GalileoVersion galileoVersion = firmwareCapsule.getVersion();
        if (galileoVersion == null) {
            System.out.println("Corrupted internal firmware. Terminate!");
            this._systemExitCode = 7;
            return bl;
        }
        String string = galileoVersion.toPresentationString();
        System.out.println("Internal FW=" + string);
        try {
            uRL2 = this._cmdArgs.getCapURL();
            if (uRL2 == null) {
                FirmwareCapsule firmwareCapsule2 = this._galileoflash.getUpdate();
                this._galileoflash.setUpdate(firmwareCapsule2);
            } else {
                this._galileoflash.setLocalCapFile(uRL2);
                uRL = this._galileoflash.getLocalCapFile();
                if (uRL == null) {
                    return bl;
                }
                object = new File(System.getProperty("user.home"), ".galileo");
                ((File)object).mkdir();
                FirmwareCapsule firmwareCapsule3 = new FirmwareCapsule(this._galileoflash.getLocalCapFile(), (File)object);
                galileoVersion = firmwareCapsule3.getVersion();
                if (galileoVersion == null) {
                    System.out.println("Corrupted user firmware. Terminate!");
                    System.exit(5);
                    return bl;
                }
                string = galileoVersion.toPresentationString();
                System.out.println("User FW    =" + string);
                this._galileoflash.setUpdate(firmwareCapsule3);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(FirmwareUpdateTool.class.getName()).log(Level.SEVERE, null, exception);
        }
        uRL = this._galileoflash.getLocalCapFile();
        if (uRL != null) {
            return bl;
        }
        FirmwareCapsule firmwareCapsule4 = this._galileoflash.getUpdate();
        galileoVersion = firmwareCapsule4.getVersion();
        if (galileoVersion == null) {
            System.out.println("Corrupted flasher firmware. Terminate!");
            return bl;
        }
        string = galileoVersion.toPresentationString();
        System.out.println("New FW     =" + string);
        object = this._compareBaseFwVer(string);
        if (((String)object).equals("LT") || ((String)object).equals("ERR")) {
            System.out.println("The lowest supported *.cap file is " + this._capBaseVersion);
            System.out.println("Firmware version (" + string + ") is not supported. Terminate!");
            System.exit(1);
            return bl;
        }
        bl = true;
        return bl;
    }

    private String _findGalileoSerialPort() {
        String string = null;
        List<String> list = this._cmdArgs.queryPorts();
        Object var5_3 = null;
        for (int i = 0; i < list.size(); ++i) {
            this._galileoflash.setCommunicationConnection(list.get(i));
            try {
                GalileoVersion galileoVersion = this._galileoflash.getCurrentBoardVersion();
                if (galileoVersion == null) continue;
                string = list.get(i);
                this._cmdArgs.setUserPort(string);
                break;
            }
            catch (Exception exception) {
                Logger.getLogger(FirmwareUpdateTool.class.getName()).log(Level.SEVERE, null, exception);
                System.out.println("Error: " + list.get(i) + " is valid system serial port but it is connected to a Galileo.");
                System.out.println("If you did not specify this port, then the first enumerated port is not connected to Galileo.");
                System.out.println("Please specify the correct serial port connected to a Galileo after the -serial_port option.");
                System.exit(3);
            }
        }
        return string;
    }

    private boolean _setSerialPort() {
        boolean bl = false;
        this._galileoflash.setCommunicationConnection(this._cmdArgs.getSerialPort());
        try {
            GalileoVersion galileoVersion = this._galileoflash.getCurrentBoardVersion();
            if (galileoVersion == null) {
                System.out.println("Unable to query board firmware. Terminate!");
                this._systemExitCode = 8;
                return bl;
            }
            String string = galileoVersion.toPresentationString();
            System.out.println("Board FW  =" + string);
            if (this._compareBaseFwVer(string).equals("ERR")) {
                System.out.println("Board version (" + string + ") is not supported. Terminate!");
                this._systemExitCode = 1;
                return bl;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(FirmwareUpdateTool.class.getName()).log(Level.SEVERE, null, exception);
            System.out.println("Error: " + this._cmdArgs.getSerialPort() + " is valid system serial port but it is connected to a Galileo.");
            System.out.println("If you did not specify this port, then the first enumerated port is not connected to Galileo.");
            System.out.println("Please specify the correct serial port connected to a Galileo after the -serial_port option.");
            this._systemExitCode = 3;
            return bl;
        }
        bl = true;
        return bl;
    }

    public void runSilent(boolean bl) {
        if (!this._setCapFile()) {
            this._systemExitCode = 5;
            return;
        }
        if (this._cmdArgs.getSerialPort().contentEquals("NULL") && this._findGalileoSerialPort() == null) {
            this._systemExitCode = 12;
            System.exit(this._systemExitCode);
        }
        if (!this._setSerialPort()) {
            this._systemExitCode = 3;
            System.exit(this._systemExitCode);
        }
        if (!this._galileoflash.isReadyForUpdate()) {
            this._systemExitCode = 4;
        }
        if (bl) {
            try {
                if (this._galileoflash.updateFirmwareOnBoard(new SilentConsole())) {
                    this._systemExitCode = 0;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(FirmwareUpdateSilent.class.getName()).log(Level.SEVERE, null, exception);
            }
        } else {
            System.out.println("Firmware flash disabled. Is aAllowFirmwareFlash false?");
        }
        System.exit(this._systemExitCode);
    }

    protected Boolean flashnow() throws Exception {
        return this._galileoflash.updateFirmwareOnBoard(null);
    }

    class SilentConsole
    implements GalileoFirmwareUpdater.ProgressNotification {
        @Override
        public void updateMessage(String string) {
            System.out.println(string);
        }

        @Override
        public void updateProgress(int n) {
            System.out.println(n + " %");
        }
    }
}

