/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.CommunicationService;
import com.intel.galileo.flash.tool.FirmwareCapsule;
import com.intel.galileo.flash.tool.GalileoVersion;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GalileoFirmwareUpdater {
    static final String[] CAPSULE_RESOURCES = new String[]{"firmware.cap"};
    static final String CAPSULE_RESOURCE_PATH = "/capsules/";
    static final String DEFAULT_CAPSULE = CAPSULE_RESOURCES[0];
    private URL localCapFile = null;
    private static final String VERSION_COMMAND = "cat /sys/firmware/board_data/flash_version";
    private static final String TRANSFER_COMPLETE = "Transfer complete";
    private File files;
    private PropertyChangeSupport props = new PropertyChangeSupport(this);
    private GalileoVersion capsuleVersion;
    private GalileoVersion currentBoardVersion;
    private List<CommunicationService> services;
    private String communicationConnection;
    private CommunicationService communicationService;
    private List<FirmwareCapsule> capsules;
    private FirmwareCapsule update;
    private ProgressNotification progress;
    private boolean boardVersionQueryRunning = false;

    public GalileoFirmwareUpdater() {
        this(null, null);
    }

    public GalileoFirmwareUpdater(CommunicationService stringArray, String string) {
        this.files = this.createFileDirectory();
        this.services = CommunicationService.getCommunicationServices();
        if (!this.services.isEmpty()) {
            String[] stringArray2 = stringArray != null ? stringArray : this.services.get(0);
            this.setCommunicationService((CommunicationService)stringArray2);
            if (string != null) {
                this.setCommunicationConnection(string);
            } else {
                List<String> list = stringArray2.getAvailableConnections();
                if (list.size() == 1) {
                    String string2 = list.get(0);
                    this.setCommunicationConnection(string2);
                }
            }
        }
        this.capsules = new ArrayList<FirmwareCapsule>();
        for (String string3 : CAPSULE_RESOURCES) {
            String string4 = CAPSULE_RESOURCE_PATH + string3;
            URL uRL = this.getClass().getResource(string4);
            if (uRL == null) {
                throw new InternalError("Invalid capsule url: " + string4);
            }
            FirmwareCapsule firmwareCapsule = new FirmwareCapsule(uRL, this.files);
            this.capsules.add(firmwareCapsule);
            if (!string3.equals(DEFAULT_CAPSULE)) continue;
            this.setUpdate(firmwareCapsule);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.props.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.props.removePropertyChangeListener(propertyChangeListener);
    }

    protected File createFileDirectory() {
        String string = System.getProperty("user.home");
        File file = new File(string, ".galileo");
        file.mkdir();
        return file;
    }

    public List<CommunicationService> getCommunicationServices() {
        return this.services;
    }

    public CommunicationService getCommunicationService() {
        return this.communicationService;
    }

    public final synchronized void setCommunicationService(CommunicationService communicationService) {
        CommunicationService communicationService2 = this.communicationService;
        this.communicationService = communicationService;
        if (this.communicationService != null) {
            this.communicationService.setFileLocation(this.files);
        }
        this.props.firePropertyChange("communicationService", communicationService2, this.communicationService);
    }

    public String getCommunicationConnection() {
        return this.communicationConnection;
    }

    public final synchronized void setCommunicationConnection(String string) {
        this.communicationConnection = string;
    }

    public final synchronized GalileoVersion getCurrentBoardVersion() {
        GalileoVersion galileoVersion;
        GalileoVersion galileoVersion2 = galileoVersion = this.currentBoardVersion;
        if (this.currentBoardVersion == null) {
            if (this.communicationService == null) {
                throw new IllegalArgumentException("No communication service");
            }
            if (this.communicationConnection == null) {
                throw new IllegalArgumentException("No connection to board specified");
            }
            if (!this.communicationService.isConnectionOpen() && !this.communicationService.openConnection(this.communicationConnection)) {
                throw new IllegalArgumentException("Unable to open communication");
            }
            try {
                for (int i = 0; this.currentBoardVersion == null && i < 5; ++i) {
                    String string = this.communicationService.sendCommandWithTimeout(VERSION_COMMAND, 250);
                    int n = string.indexOf(TRANSFER_COMPLETE);
                    if (n <= 0) continue;
                    string = string.substring(0, n).trim();
                    this.currentBoardVersion = GalileoVersion.ofTargetString(string);
                    break;
                }
            }
            catch (Exception exception) {
                this.getLogger().log(Level.SEVERE, null, exception);
            }
            this.communicationService.closeConnection();
            galileoVersion = this.currentBoardVersion;
        }
        if (galileoVersion2 != galileoVersion) {
            this.props.firePropertyChange("currentBoardVersion", galileoVersion2, galileoVersion);
        }
        return this.currentBoardVersion;
    }

    public synchronized void invalidateBoardVersion() {
        GalileoVersion galileoVersion = this.currentBoardVersion;
        this.currentBoardVersion = null;
        this.props.firePropertyChange("currentBoardVersion", galileoVersion, null);
    }

    public final GalileoVersion getUpdateVersion() {
        return this.capsuleVersion;
    }

    private void setUpdateVersion(GalileoVersion galileoVersion) {
        GalileoVersion galileoVersion2 = this.capsuleVersion;
        this.capsuleVersion = galileoVersion;
        this.props.firePropertyChange("updateVersion", galileoVersion2, this.capsuleVersion);
    }

    public final List<FirmwareCapsule> getAvailableFirmware() {
        return this.capsules;
    }

    public final FirmwareCapsule getUpdate() {
        return this.update;
    }

    public final synchronized void setUpdate(FirmwareCapsule firmwareCapsule) {
        FirmwareCapsule firmwareCapsule2 = this.update;
        this.update = firmwareCapsule;
        this.props.firePropertyChange("update", firmwareCapsule2, firmwareCapsule);
        GalileoVersion galileoVersion = firmwareCapsule != null ? firmwareCapsule.getVersion() : null;
        this.setUpdateVersion(galileoVersion);
        this.localCapFile = null;
    }

    public boolean isReadyForUpdate() {
        return this.capsuleVersion != null && this.currentBoardVersion != null;
    }

    public Logger getLogger() {
        return Logger.getLogger(GalileoFirmwareUpdater.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateFirmwareOnBoard(ProgressNotification progressNotification) throws Exception {
        boolean bl;
        this.progress = progressNotification;
        if (this.update == null) {
            throw new IllegalArgumentException("No update was specified");
        }
        if (this.update.getCache() == null) {
            throw new IllegalArgumentException("There firmware can't be loaded from the specified URL");
        }
        if (this.update.getVersion() == null) {
            throw new IllegalArgumentException("Update doesn't appear to be valid");
        }
        if (!this.communicationService.isConnectionOpen() && !this.communicationService.openConnection(this.communicationConnection)) {
            throw new IllegalArgumentException("Unable to open communication");
        }
        Logger logger = this.getLogger();
        try {
            String string;
            logger.log(Level.INFO, "Uploading: {0}", this.update.getCache());
            if (progressNotification != null) {
                progressNotification.updateMessage("Loading new firmware onto target.");
            }
            this.communicationService.sendFile(this.update.getCache(), new UploadProgressRelay());
            String string2 = "/" + this.update.getCache().getName();
            String string3 = "md5sum " + string2;
            logger.log(Level.INFO, "Checking uploaded file: {0}", string3);
            if (progressNotification != null) {
                progressNotification.updateMessage("Checking new firmware on target.");
            }
            String string4 = this.communicationService.sendCommand(string3);
            logger.log(Level.INFO, "MD5 result: {0}", string4);
            int n = string4.indexOf("/");
            String string5 = string = n > 0 ? string4.substring(0, n - 1).trim() : string4;
            if (!this.update.getMD5().equalsIgnoreCase(string)) {
                logger.log(Level.INFO, "Expected: {0}", this.update.getMD5());
                logger.log(Level.INFO, "Found: {0}", string);
                logger.severe("Upload failed");
                throw new Exception("Failed upload integrity check");
            }
            String string6 = "Integrity good, preparing for upgrade...";
            logger.info(string6);
            if (progressNotification != null) {
                progressNotification.updateMessage(string6);
            }
            string3 = "mkdir -p /tmp/spi_upgrade";
            logger.info(string3);
            this.communicationService.sendCommand(string3);
            string3 = "mkdir -p /lib/firmware/tmp/spi_upgrade";
            logger.info(string3);
            this.communicationService.sendCommand(string3);
            string3 = "mv " + string2 + " /tmp/spi_upgrade/galileo_firmware.bin";
            logger.info(string3);
            this.communicationService.sendCommand(string3);
            string3 = "cp /tmp/spi_upgrade/galileo_firmware.bin /lib/firmware/tmp/spi_upgrade/galileo_firmware.bin";
            logger.info(string3);
            this.communicationService.sendCommand(string3);
            string6 = "Preparations complete!";
            logger.info(string6);
            if (progressNotification != null) {
                progressNotification.updateMessage(string6);
            }
            if (progressNotification != null) {
                progressNotification.updateMessage(string6);
            }
            string3 = "./opt/cln/galileo/start_spi_upgrade.sh";
            logger.info(string3);
            this.communicationService.sendCommand(string3);
            string3 = "reboot";
            logger.info(string3);
            this.communicationService.sendCommand(string3);
            string6 = "Updating firmware...This may take up to 5 minutes.";
            logger.info(string6);
            if (progressNotification != null) {
                progressNotification.updateMessage(string6);
            }
        }
        finally {
            this.communicationService.closeConnection();
        }
        this.invalidateBoardVersion();
        if (progressNotification != null) {
            progressNotification.updateProgress(0);
        }
        long l = System.currentTimeMillis();
        int n = 0;
        while (true) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l2 = System.currentTimeMillis() - l;
            if (l2 > 360000L) {
                throw new Exception("Timeout waiting for board");
            }
            if (progressNotification != null) {
                int n2 = (int)(100.0f * ((float)l2 / 360000.0f));
                progressNotification.updateProgress(n2);
            }
            if (l2 < 180000L) continue;
            logger.info("poll ...  " + ++n);
            if (this.communicationService.openConnection(this.communicationConnection)) break;
        }
        Thread.sleep(5000L);
        GalileoVersion galileoVersion = this.getCurrentBoardVersion();
        boolean bl2 = bl = galileoVersion != null && galileoVersion.compareTo(this.update.getVersion()) == 0;
        if (bl) {
            logger.info("Update was successful!");
        } else {
            logger.info("Update failed version check");
        }
        return bl;
    }

    public URL getLocalCapFile() {
        return this.localCapFile;
    }

    public void setLocalCapFile(URL uRL) {
        this.localCapFile = uRL;
    }

    public boolean getQueryState() {
        return this.boardVersionQueryRunning;
    }

    public void setQueryState(boolean bl) {
        this.boardVersionQueryRunning = bl;
    }

    public static interface ProgressNotification {
        public void updateMessage(String var1);

        public void updateProgress(int var1);
    }

    private class UploadProgressRelay
    implements CommunicationService.FileProgress {
        private final float nbytesTotal;

        public UploadProgressRelay() {
            this.nbytesTotal = GalileoFirmwareUpdater.this.update.getCache().length();
        }

        @Override
        public void bytesSent(int n) {
            try {
                int n2 = (int)(100.0f * ((float)n / this.nbytesTotal));
                n2 = Math.min(n2, 100);
                n2 = Math.max(n2, 0);
                if (GalileoFirmwareUpdater.this.progress != null) {
                    GalileoFirmwareUpdater.this.progress.updateProgress(n2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

