/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.CommunicationService;
import com.intel.galileo.flash.tool.JsscZmodemService;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jssc.SerialPortList;

public class WindowsZmodemService
extends JsscZmodemService {
    private String[] windowsResources = new String[]{"bash.exe", "cyggcc_s-1.dll", "cygiconv-2.dll", "cygintl-8.dll", "cygncurses++w-10.dll", "cygncursesw-10.dll", "cygreadline7.dll", "cygwin1.dll", "grep.exe", "lsz.exe", "md5sum.exe", "strings.exe", "upgrade.sh"};
    static final String PATH_KEY = "Path";

    @Override
    public boolean isSupportedOnThisOS() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    @Override
    protected String getOSResourcePath() {
        return "/os/windows/";
    }

    @Override
    public List<String> getAvailableConnections() {
        String[] stringArray = SerialPortList.getPortNames();
        return Arrays.asList(stringArray);
    }

    @Override
    protected File installResources() throws IOException {
        for (String string : this.windowsResources) {
            this.copyZmodemResource(string);
        }
        for (String string : this.windowsResources) {
            File file = new File(this.zmodemDir, string);
            file.setExecutable(true);
        }
        return new File(this.zmodemDir, "lsz.exe");
    }

    @Override
    protected ProcessBuilder createProcessBuilder(List<String> list) {
        ProcessBuilder processBuilder = super.createProcessBuilder(list);
        Map<String, String> map = processBuilder.environment();
        String string = map.get(PATH_KEY);
        string = string != null ? this.zmodemDir.getAbsolutePath() + ";" + string : this.zmodemDir.getAbsolutePath();
        string = string + ";.";
        map.put(PATH_KEY, string);
        this.getLogger().info("process path: " + string);
        return processBuilder;
    }

    @Override
    public void sendFile(File file, CommunicationService.FileProgress fileProgress) throws Exception {
        this.port.closePort();
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = this.zmodemDir.getPath().replace("\\", "/");
        linkedList.add(string + "/bash.exe");
        linkedList.add("--verbose");
        linkedList.add("--noprofile");
        linkedList.add(string + "/upgrade.sh");
        linkedList.add(string);
        linkedList.add(file.getName());
        linkedList.add(this.port.getPortName());
        this.getLogger().info(((Object)linkedList).toString());
        this.zmodemOperation(linkedList, fileProgress);
        this.port.openPort();
    }

    @Override
    public boolean isProgressSupported() {
        return false;
    }
}

