/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.CommunicationService;
import com.intel.galileo.flash.tool.ProcessManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractZmodemService
extends CommunicationService {
    protected static final String OS_PROPERTY_KEY = "os.name";
    protected volatile boolean quit = false;
    protected File zmodemDir;
    private File zmodem;

    @Override
    public String getServiceName() {
        return "Serial Connection Service";
    }

    @Override
    public String getConnectionLabel() {
        return "Port:";
    }

    @Override
    public final boolean isConnectionOpen() {
        return this.zmodemDir != null && this.zmodem != null && this.isSerialTransportOpen();
    }

    @Override
    public void setFileLocation(File file) {
        this.zmodemDir = file;
        try {
            this.zmodem = this.installResources();
        }
        catch (IOException iOException) {
            Logger.getLogger(AbstractZmodemService.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    @Override
    public final boolean openConnection(String string) {
        try {
            if (this.zmodemDir == null) {
                File file = File.createTempFile("bogus", "");
                File file2 = file.getParentFile();
                file.delete();
                this.zmodemDir = new File(file2, "zmodem");
                this.zmodemDir.mkdir();
                this.zmodemDir.deleteOnExit();
                this.zmodem = this.installResources();
            }
            return this.openSerialTransport(string);
        }
        catch (IOException iOException) {
            this.zmodemDir = null;
            Logger.getLogger(AbstractZmodemService.class.getName()).log(Level.SEVERE, null, iOException);
            return false;
        }
    }

    protected abstract File installResources() throws IOException;

    @Override
    public final void closeConnection() {
        this.closeSerialTransport();
    }

    @Override
    public final String sendCommand(String string) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.zmodem.getAbsolutePath());
        linkedList.add("--escape");
        linkedList.add("--verbose");
        linkedList.add("-c");
        linkedList.add(string);
        return this.zmodemOperation(linkedList, null);
    }

    @Override
    public final String sendCommandWithTimeout(String string, int n) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.zmodem.getAbsolutePath());
        linkedList.add("--escape");
        linkedList.add("--verbose");
        linkedList.add("-c");
        linkedList.add(string);
        return this.zmodemOperationWithTimeout(linkedList, null, n);
    }

    @Override
    public void sendFile(File file, CommunicationService.FileProgress fileProgress) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.zmodem.getPath().replace("\\", "/"));
        linkedList.add("--escape");
        linkedList.add("--binary");
        linkedList.add("--overwrite");
        linkedList.add("--verbose");
        linkedList.add(file.getName());
        this.getLogger().info(((Object)linkedList).toString());
        this.zmodemOperation(linkedList, fileProgress);
    }

    @Override
    public boolean isProgressSupported() {
        return true;
    }

    protected abstract Runnable createSerialOutputPipe(InputStream var1, CommunicationService.FileProgress var2);

    protected abstract Runnable createSerialInputPipe(OutputStream var1);

    protected abstract boolean openSerialTransport(String var1);

    protected abstract void closeSerialTransport();

    protected abstract boolean isSerialTransportOpen();

    protected String zmodemOperation(List<String> list, CommunicationService.FileProgress fileProgress) throws Exception {
        ProcessBuilder processBuilder = this.createProcessBuilder(list);
        this.quit = false;
        Process process = processBuilder.start();
        RemoteOutputPipe remoteOutputPipe = new RemoteOutputPipe(process.getErrorStream());
        Thread thread = new Thread(this.createSerialOutputPipe(process.getInputStream(), fileProgress));
        thread.setName("serial-output");
        thread.start();
        Thread thread2 = new Thread(this.createSerialInputPipe(process.getOutputStream()));
        thread2.setName("serial-input");
        thread2.start();
        Thread thread3 = new Thread(remoteOutputPipe);
        thread3.setName("output-sucker");
        thread3.start();
        int n = process.waitFor();
        this.quit = true;
        if (n != 0) {
            String string = String.format("Remote command exited with %d\n", n);
            this.getLogger().severe(string);
            this.getLogger().log(Level.INFO, "Output was: {0}", remoteOutputPipe.getOutput());
            throw new Exception(string);
        }
        return remoteOutputPipe.getOutput();
    }

    protected String zmodemOperationWithTimeout(List<String> list, CommunicationService.FileProgress fileProgress, int n) throws Exception {
        System.out.println("zmodemOperationWithTimeout");
        ProcessBuilder processBuilder = this.createProcessBuilder(list);
        this.quit = false;
        Process process = processBuilder.start();
        RemoteOutputPipe remoteOutputPipe = new RemoteOutputPipe(process.getErrorStream());
        Thread thread = new Thread(this.createSerialOutputPipe(process.getInputStream(), fileProgress));
        thread.setName("serial-output");
        thread.start();
        Thread thread2 = new Thread(this.createSerialInputPipe(process.getOutputStream()));
        thread2.setName("serial-input");
        thread2.start();
        Thread thread3 = new Thread(remoteOutputPipe);
        thread3.setName("output-sucker");
        thread3.start();
        try {
            ProcessManager processManager = new ProcessManager(process);
            Thread thread4 = new Thread(processManager);
            thread4.start();
            processManager.waitForOrKill(n);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        System.out.println("Output was: " + remoteOutputPipe.getOutput());
        return remoteOutputPipe.getOutput();
    }

    protected ProcessBuilder createProcessBuilder(List<String> list) {
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        processBuilder.directory(this.zmodemDir);
        return processBuilder;
    }

    protected Logger getLogger() {
        return Logger.getLogger(AbstractZmodemService.class.getName());
    }

    private File copyResourceToTmpFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n >= 0) {
            fileOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        inputStream.close();
        file.deleteOnExit();
        return file;
    }

    private InputStream getZmodemResource(String string) {
        String string2 = this.getOSResourcePath() + string;
        return this.getClass().getResourceAsStream(string2);
    }

    File copyZmodemResource(String string) throws IOException {
        InputStream inputStream = this.getZmodemResource(string);
        File file = new File(this.zmodemDir, string);
        return this.copyResourceToTmpFile(inputStream, file);
    }

    protected abstract String getOSResourcePath();

    private class RemoteOutputPipe
    implements Runnable {
        private final InputStream es;
        private final StringBuffer output;

        RemoteOutputPipe(InputStream inputStream) {
            this.es = inputStream;
            this.output = new StringBuffer();
        }

        public String getOutput() {
            return this.output.toString().trim();
        }

        @Override
        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.es));
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.output.append(string);
                    this.output.append("\n");
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                AbstractZmodemService.this.getLogger().log(Level.SEVERE, null, iOException);
            }
            finally {
                try {
                    this.es.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

