/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.AbstractZmodemService;
import com.intel.galileo.flash.tool.CommunicationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FileDeviceZmodemService
extends AbstractZmodemService {
    private File device;
    private InputStream serialIn;
    private OutputStream serialOut;

    @Override
    protected Runnable createSerialOutputPipe(InputStream inputStream, CommunicationService.FileProgress fileProgress) {
        return new SerialOutputPipe(inputStream, this.serialOut, fileProgress);
    }

    @Override
    protected boolean openSerialTransport(String string) {
        this.device = this.portToDevice(string);
        if (this.device != null && this.device.exists()) {
            try {
                this.serialIn = new FileInputStream(this.device);
                this.serialOut = new FileOutputStream(this.device);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(FileDeviceZmodemService.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isSerialTransportOpen() {
        return this.serialIn != null && this.serialOut != null;
    }

    @Override
    protected void closeSerialTransport() {
        this.device = null;
        if (this.serialIn != null) {
            try {
                this.serialIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serialIn = null;
        }
        if (this.serialOut != null) {
            try {
                this.serialOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serialOut = null;
        }
    }

    @Override
    protected Runnable createSerialInputPipe(OutputStream outputStream) {
        return new SerialInputPipe(outputStream, this.serialIn);
    }

    protected File portToDevice(String string) {
        return new File(string);
    }

    private class SerialInputPipe
    implements Runnable {
        private final OutputStream out;
        private final InputStream serialIn;

        SerialInputPipe(OutputStream outputStream, InputStream inputStream) {
            this.out = outputStream;
            this.serialIn = inputStream;
        }

        @Override
        public void run() {
            try {
                int n = this.serialIn.read();
                while (n != -1) {
                    this.out.write(n);
                    this.out.flush();
                    n = this.serialIn.read();
                }
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                FileDeviceZmodemService.this.getLogger().severe(string);
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class SerialOutputPipe
    implements Runnable {
        private final InputStream in;
        private final OutputStream serialOut;
        private final CommunicationService.FileProgress progress;

        SerialOutputPipe(InputStream inputStream, OutputStream outputStream, CommunicationService.FileProgress fileProgress) {
            this.in = inputStream;
            this.serialOut = outputStream;
            this.progress = fileProgress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = 0;
            try {
                int n2 = this.in.read();
                while (n2 >= 0) {
                    this.serialOut.write(n2);
                    if (this.progress != null && ++n % 1024 == 0) {
                        this.progress.bytesSent(n);
                    }
                    n2 = this.in.read();
                }
                if (this.progress != null) {
                    this.progress.bytesSent(n);
                }
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                FileDeviceZmodemService.this.getLogger().severe(string);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                FileDeviceZmodemService.this.getLogger().severe(string);
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

