/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.GalileoVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FirmwareCapsule {
    private boolean cacheLoaded = false;
    private String md5sum;
    private GalileoVersion version;
    private File cache;
    private final File cacheDir;
    private final URL location;

    FirmwareCapsule(URL uRL, File file) {
        this.location = uRL;
        this.cacheDir = file;
    }

    public final String getMD5() {
        this.checkCacheAndLoadIfNeeded();
        return this.md5sum;
    }

    public final URL getLocation() {
        return this.location;
    }

    public final GalileoVersion getVersion() {
        this.checkCacheAndLoadIfNeeded();
        return this.version;
    }

    public final File getCache() {
        this.checkCacheAndLoadIfNeeded();
        return this.cache;
    }

    private synchronized void checkCacheAndLoadIfNeeded() {
        if (!this.cacheLoaded) {
            try {
                int n;
                this.cache = new File(this.cacheDir, this.toString());
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                InputStream inputStream = this.location.openStream();
                FileOutputStream fileOutputStream = new FileOutputStream(this.cache);
                byte[] byArray = new byte[1024];
                do {
                    if ((n = inputStream.read(byArray)) <= 0) continue;
                    messageDigest.update(byArray, 0, n);
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                } while (n != -1);
                inputStream.close();
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                byte[] byArray2 = messageDigest.digest();
                BigInteger bigInteger = new BigInteger(1, byArray2);
                String string = this.getImageVersion(this.cache);
                this.version = GalileoVersion.ofTargetString(string);
                this.md5sum = String.format("%0" + (byArray2.length << 1) + "X", bigInteger);
            }
            catch (Exception exception) {
                Logger.getLogger(FirmwareCapsule.class.getName()).log(Level.SEVERE, "Invalid capsule", exception);
            }
            this.cacheLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getImageVersion(File file) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            char[] cArray = new char[1024];
            while ((n = bufferedReader.read(cArray)) != -1) {
                String string = String.valueOf(cArray, 0, n);
                stringBuilder.append(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n2 = stringBuilder.indexOf("[Flash Image Version]");
        n = "value=".length() + stringBuilder.indexOf("value=", n2);
        int n3 = stringBuilder.indexOf("\r\n", n);
        String string = stringBuilder.substring(n, n3);
        return string;
    }

    public final String toString() {
        String string = this.location.getPath();
        int n = string.lastIndexOf("/");
        string = n > 0 ? string.substring(n + 1) : string;
        return string;
    }
}

