/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.CommunicationService;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class FirmwareUpdateCmdArgs {
    URL _url;
    String _port;
    boolean _debug;
    int _nargs;
    boolean _silentInstall;
    boolean _verbose;

    public List<String> queryPorts() {
        List<String> list = new LinkedList<String>();
        List<CommunicationService> list2 = CommunicationService.getCommunicationServices();
        if (!list2.isEmpty()) {
            CommunicationService communicationService = list2.get(0);
            list = communicationService.getAvailableConnections();
        }
        return list;
    }

    public FirmwareUpdateCmdArgs() {
        this._init();
    }

    private void _init() {
        try {
            this._url = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._port = "NULL";
        this._debug = false;
        this._nargs = -1;
        this._silentInstall = false;
        this._verbose = false;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public boolean isSilentInstall() {
        return this._silentInstall;
    }

    public int getNumArgs() {
        return this._nargs;
    }

    public URL getCapURL() {
        return this._url;
    }

    public String getSerialPort() {
        return this._port;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    private boolean _setFileURI(String string) {
        boolean bl = false;
        try {
            File file;
            if (this._debug) {
                System.out.print("  setFileURI," + string);
            }
            if ((file = new File(string)).exists()) {
                this._url = file.toURI().toURL();
                bl = true;
                if (this._debug) {
                    System.out.print(",FileExists");
                }
            } else if (this._debug) {
                System.out.print(",FileDoesNotExists");
            }
            if (this._debug) {
                System.out.println("");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public boolean setUserPort(String string) {
        List<String> list;
        boolean bl = false;
        if (this._debug) {
            System.out.print("  setUserPort," + string);
        }
        if ((list = this.queryPorts()).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (this._debug) {
                    System.out.print("," + list.get(i) + "(" + i + ")");
                }
                if (!string.equals(list.get(i))) continue;
                this._port = list.get(i);
                bl = true;
                if (!this._debug) break;
                System.out.println(",PortExists");
                break;
            }
        }
        if (!bl && this._debug) {
            System.out.println(",PortDoesNotExists");
        }
        return bl;
    }

    public int ParseArguments(String[] stringArray) {
        int n = 6;
        if (stringArray.length == 0) {
            this._nargs = 0;
            return 0;
        }
        n = 6;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (String string : stringArray) {
            if (this._debug) {
                System.out.print("Arg: " + string + "," + n2);
            }
            if (string.length() < 2 || !string.startsWith("-", 0)) continue;
            if (string.equals("--file")) {
                if (!this._setFileURI(stringArray[n2 + 1])) {
                    this._init();
                    return 2;
                }
                ++n4;
                n2 += 2;
                this._silentInstall = true;
                continue;
            }
            if (string.equals("--serial_port")) {
                if (!this.setUserPort(stringArray[n2 + 1])) {
                    this._init();
                    return 3;
                }
                ++n3;
                n2 += 2;
                this._silentInstall = true;
                continue;
            }
            if (string.equals("--default_image")) {
                ++n4;
                ++n2;
                this._silentInstall = true;
                continue;
            }
            if (string.equals("--v")) {
                this._verbose = true;
                ++n2;
                continue;
            }
            this._init();
            return 6;
        }
        if (n3 <= 1 && n4 <= 1) {
            ++this._nargs;
            if (n3 > 0) {
                ++this._nargs;
            }
            if (n4 > 0) {
                ++this._nargs;
            }
            n = 0;
        } else {
            if (n3 > 1) {
                n = 10;
            }
            if (n4 > 1) {
                n = 11;
            }
            this._init();
        }
        return n;
    }
}

