/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.About;
import com.intel.galileo.flash.tool.FirmwareUpdateAction;
import com.intel.galileo.flash.tool.FirmwareUpdateCmdArgs;
import com.intel.galileo.flash.tool.FirmwareUpdateSilent;
import com.intel.galileo.flash.tool.GalileoFirmwareUpdater;
import com.intel.galileo.flash.tool.PreferencesPanel;
import com.intel.galileo.flash.tool.UpdateStatusPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.UIManager;

public class FirmwareUpdateTool
extends JFrame {
    private final GalileoFirmwareUpdater flasher;
    private final PreferencesPanel preferences;
    private final UpdateStatusPanel status;
    static String capVersion = "";
    static String appVersion = "";
    static final int E_SUCCESS = 0;
    static final int E_INVDOWNGRADE = 1;
    static final int E_CAPFILE_NOTFOUND = 2;
    static final int E_BADCOMPORT = 3;
    static final int E_UPDATEFAILED = 4;
    static final int E_BADCAPFILE = 5;
    static final int E_BADARG = 6;
    static final int E_BADINTERNALFW = 7;
    static final int E_UNABLEQUERYBRDFW = 8;
    static final int E_UNKNOWN = 9;
    static final int E_COMCOUNT = 10;
    static final int E_CAPCOUNT = 11;
    static final int E_NOBOARD = 12;
    private static String title = "Intel\u00ae Galileo Firmware Updater ";

    private static void parseVersions() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = FirmwareUpdateTool.class.getClassLoader().getResourceAsStream("versions.properties");
            if (inputStream == null) {
                throw new FileNotFoundException("Not able to find the versions file");
            }
            properties.load(inputStream);
            appVersion = properties.getProperty("APP_VER");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        final FirmwareUpdateCmdArgs firmwareUpdateCmdArgs = new FirmwareUpdateCmdArgs();
        int n = firmwareUpdateCmdArgs.ParseArguments(stringArray);
        if (n > 0) {
            System.out.println("--serial_port SerialPort --file CapsFile.cap --default_image");
            System.out.println("With no arguments, GUI version will start.");
            System.exit(n);
            return;
        }
        if (!firmwareUpdateCmdArgs.isVerbose()) {
            LogManager.getLogManager().reset();
            Logger logger = Logger.getLogger("global");
            logger.setLevel(Level.OFF);
        }
        try {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(FirmwareUpdateTool.class.getName()).log(Level.SEVERE, null, exception);
        }
        FirmwareUpdateTool.parseVersions();
        if (appVersion.length() == 0) {
            Logger.getLogger(FirmwareUpdateTool.class.getName()).log(Level.SEVERE, null, "YOUR FORGOT THE VERSIONS IN ENV VARS!!!");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (firmwareUpdateCmdArgs.isSilentInstall()) {
                    new FirmwareUpdateSilent(firmwareUpdateCmdArgs).runSilent(true);
                } else {
                    LogManager.getLogManager().reset();
                    Logger logger = Logger.getLogger("global");
                    logger.setLevel(Level.OFF);
                    new FirmwareUpdateTool().setVisible(true);
                }
            }
        });
    }

    public FirmwareUpdateTool() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/application.png")));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(500, 300);
        this.setBounds(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2, dimension2.width, dimension2.height);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (FirmwareUpdateTool.this.preferences.isUpdateRunning()) {
                    FirmwareUpdateTool.this.setDefaultCloseOperation(0);
                } else {
                    FirmwareUpdateTool.this.setDefaultCloseOperation(3);
                    System.out.println("Closing");
                    System.exit(0);
                }
            }
        });
        this.flasher = new GalileoFirmwareUpdater();
        this.status = new UpdateStatusPanel();
        this.preferences = new PreferencesPanel(this.flasher, new FirmwareUpdateAction(this.flasher, this.status));
        this.preferences.setFirmwareUpdateTool(this);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setJMenuBar(this.createMenubar());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.preferences);
        this.getContentPane().add("South", this.status);
        this.pack();
        this.preferences.setFrame(this);
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createAboutMenu());
        return jMenuBar;
    }

    JMenu createFileMenu() {
        JMenu jMenu = new JMenu("File");
        FirmwareUpdateAction firmwareUpdateAction = new FirmwareUpdateAction(this.flasher, this.status);
        firmwareUpdateAction.setPreferencesPanel(this.preferences);
        jMenu.add(firmwareUpdateAction);
        jMenu.add(new AbstractAction("Quit"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        return jMenu;
    }

    JMenu createAboutMenu() {
        JMenu jMenu = new JMenu("About");
        jMenu.add(new AbstractAction("Version"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                About about = new About();
                About.showMe(null);
            }
        });
        return jMenu;
    }

    @Override
    public void paint(Graphics graphics) {
        this.setTitle(title + " " + capVersion);
        super.paint(graphics);
    }
}

