/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GalileoVersion
implements Comparable<GalileoVersion> {
    static Charset utf8 = Charset.forName("UTF-8");
    static Integer zero = 0;
    static Integer[] empty = new Integer[0];
    static String quarkCodeline = "!Quark";
    private final String codeline;
    private final List<Integer> release;
    private final Integer build;

    public GalileoVersion(String string, Integer[] integerArray, Integer n) {
        this.codeline = new String(string.getBytes(utf8));
        this.release = Arrays.asList(integerArray);
        this.build = n;
    }

    private String toStringAux(Boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl2 = this.codeline.length() > 0;
        Boolean bl3 = this.release.size() > 0;
        Boolean bl4 = !this.build.equals(zero);
        if (!bl.booleanValue() && this.codeline.equals(quarkCodeline)) {
            bl2 = false;
            bl4 = bl3 == false;
        }
        if (bl2.booleanValue()) {
            stringBuilder.append(this.codeline);
            if (bl3.booleanValue()) {
                stringBuilder.append('-');
            }
        }
        Boolean bl5 = false;
        for (Integer n : this.release) {
            if (bl5.booleanValue()) {
                stringBuilder.append('.');
            }
            stringBuilder.append(n.toString());
            bl5 = true;
        }
        if (bl4.booleanValue()) {
            if (bl3.booleanValue() || bl2.booleanValue()) {
                stringBuilder.append('+');
            }
            stringBuilder.append(this.build.toString());
        }
        return stringBuilder.toString();
    }

    public String toPresentationString() {
        return this.toStringAux(false);
    }

    public String toCanonicalString() {
        return this.toStringAux(true);
    }

    public static boolean isReleasedQuarkBuild(String string) {
        int n;
        Boolean bl = string.matches("^0[Xx][0-9A-Fa-f]+$");
        if (bl.booleanValue() && (n = Integer.parseInt(string.substring(2), 16)) < 524288) {
            bl = false;
        }
        return bl;
    }

    public static boolean isUnreleasedQuarkBuild(String string) {
        int n;
        Boolean bl = string.matches("^[1-9][0-9]*$");
        if (!bl.booleanValue() && (bl = Boolean.valueOf(string.matches("^0[Xx][0-9A-Fa-f]+$"))).booleanValue() && (n = Integer.parseInt(string.substring(2), 16)) >= 524288) {
            bl = false;
        }
        return bl;
    }

    public static boolean isCanonicalFormat(String string) {
        if (string == null || string.length() < 1 || string.length() > 63) {
            return false;
        }
        Pattern pattern = Pattern.compile("(!?[A-Z][A-Za-z0-9_]*)([-+]?)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.lookingAt()) {
            return false;
        }
        string = string.substring(matcher.end());
        String string2 = matcher.group(1);
        Boolean bl = string2.equals("-");
        Boolean bl2 = string2.equals("+");
        if (bl.booleanValue()) {
            pattern = Pattern.compile("((0|[1-9][0-9]*)(\\.(0|[1-9][0-9]*)))(\\+?)");
            matcher = pattern.matcher(string);
            if (!matcher.lookingAt()) {
                return false;
            }
            string = string.substring(matcher.end());
            string2 = matcher.group(4);
            bl2 = string2.equals("+");
        }
        return bl2 == false || string.matches("0|[1-9][0-9]*");
    }

    public static String parseCodeline(String string) {
        int n = string.indexOf("-");
        if (n < 0 && (n = string.indexOf("+")) < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static Integer parseBuildNumber(String string) {
        int n = string.lastIndexOf("+");
        if (n < 0) {
            return zero;
        }
        try {
            String string2 = string.substring(n + 1);
            return Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string);
        }
    }

    public static Integer[] parseReleaseArray(String string) {
        int n = string.indexOf("-");
        n = n >= 0 ? n + 1 : 0;
        int n2 = string.lastIndexOf("+");
        n2 = n2 >= 0 ? n2 : string.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n < n2) {
            String string2 = string.substring(n, n2);
            for (String string3 : string2.split("\\.")) {
                Integer n3;
                try {
                    n3 = Integer.parseInt(string3, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("part '" + string3 + "' not valid.");
                }
                arrayList.add(n3);
            }
        }
        return arrayList.toArray(empty);
    }

    public static GalileoVersion ofTargetString(String string) {
        if (GalileoVersion.isUnreleasedQuarkBuild(string)) {
            String string2 = quarkCodeline;
            Integer[] integerArray = empty;
            Integer n = string.startsWith("0x") || string.startsWith("0X") ? Integer.valueOf(Integer.parseInt(string.substring(2), 16)) : Integer.valueOf(Integer.parseInt(string, 10));
            return new GalileoVersion(string2, integerArray, n);
        }
        if (GalileoVersion.isReleasedQuarkBuild(string)) {
            String string3 = quarkCodeline;
            int n = Integer.parseInt(string.substring(2), 16);
            Integer n2 = n & 0xFF;
            n >>= 8;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < 3; ++i) {
                arrayList.add(0, n & 0xFF);
                n >>= 8;
            }
            Integer[] integerArray = arrayList.toArray(empty);
            return new GalileoVersion(string3, integerArray, n2);
        }
        return GalileoVersion.ofString(string);
    }

    public static GalileoVersion ofString(String string) {
        if (!GalileoVersion.isCanonicalFormat(string)) {
            throw new IllegalArgumentException(string);
        }
        String string2 = GalileoVersion.parseCodeline(string);
        Integer[] integerArray = GalileoVersion.parseReleaseArray(string);
        Integer n = GalileoVersion.parseBuildNumber(string);
        return new GalileoVersion(string2, integerArray, n);
    }

    @Override
    public int compareTo(GalileoVersion galileoVersion) {
        int n;
        int n2;
        ListIterator<Integer> listIterator = this.release.listIterator();
        ListIterator<Integer> listIterator2 = galileoVersion.release.listIterator();
        if (this.codeline.equals(quarkCodeline) && galileoVersion.codeline.equals(quarkCodeline) && (n2 = listIterator.hasNext()) != (n = listIterator2.hasNext())) {
            throw new IllegalArgumentException();
        }
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Integer n3;
            Integer n4 = (Integer)listIterator.next();
            int n5 = n4.compareTo(n3 = (Integer)listIterator2.next());
            if (n5 == 0) continue;
            return n5;
        }
        if (listIterator.hasNext()) {
            return -1;
        }
        if (listIterator2.hasNext()) {
            return 1;
        }
        n2 = this.codeline.compareTo(galileoVersion.codeline);
        if (n2 != 0) {
            return n2;
        }
        return this.build.compareTo(galileoVersion.build);
    }
}

