/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.AbstractZmodemService;
import com.intel.galileo.flash.tool.CommunicationService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jssc.SerialPort;
import jssc.SerialPortException;

public abstract class JsscZmodemService
extends AbstractZmodemService {
    protected SerialPort port;

    @Override
    protected Runnable createSerialOutputPipe(InputStream inputStream, CommunicationService.FileProgress fileProgress) {
        return new SerialOutputPipe(inputStream, fileProgress);
    }

    @Override
    protected Runnable createSerialInputPipe(OutputStream outputStream) {
        return new SerialInputPipe(outputStream);
    }

    @Override
    protected boolean openSerialTransport(String string) {
        this.port = new SerialPort(string);
        try {
            return this.port.openPort();
        }
        catch (SerialPortException serialPortException) {
            this.getLogger().severe(serialPortException.getMessage());
            return false;
        }
    }

    @Override
    protected void closeSerialTransport() {
        if (this.port != null) {
            try {
                this.port.closePort();
            }
            catch (SerialPortException serialPortException) {
                this.getLogger().severe(serialPortException.getMessage());
            }
            this.port = null;
        }
    }

    @Override
    protected boolean isSerialTransportOpen() {
        return this.port != null && this.port.isOpened();
    }

    private class SerialInputPipe
    implements Runnable {
        private final OutputStream out;

        SerialInputPipe(OutputStream outputStream) {
            this.out = outputStream;
        }

        @Override
        public void run() {
            try {
                byte[] byArray = JsscZmodemService.this.port.readBytes();
                while (!JsscZmodemService.this.quit) {
                    if (byArray != null) {
                        this.out.write(byArray);
                        this.out.flush();
                    } else {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            JsscZmodemService.this.quit = true;
                        }
                    }
                    byArray = JsscZmodemService.this.port.readBytes();
                }
            }
            catch (IOException iOException) {
                JsscZmodemService.this.getLogger().severe(iOException.getMessage());
            }
            catch (SerialPortException serialPortException) {
                JsscZmodemService.this.getLogger().severe(serialPortException.getMessage());
            }
        }
    }

    private class SerialOutputPipe
    implements Runnable {
        private final InputStream in;
        private final CommunicationService.FileProgress progress;

        SerialOutputPipe(InputStream inputStream, CommunicationService.FileProgress fileProgress) {
            this.in = inputStream;
            this.progress = fileProgress;
        }

        @Override
        public void run() {
            int n = 0;
            try {
                int n2 = this.in.read();
                while (n2 >= 0) {
                    JsscZmodemService.this.port.writeByte((byte)n2);
                    if (this.progress != null && ++n % 1024 == 0) {
                        this.progress.bytesSent(n);
                    }
                    n2 = this.in.read();
                }
                if (this.progress != null) {
                    this.progress.bytesSent(n);
                }
            }
            catch (IOException iOException) {
                JsscZmodemService.this.getLogger().severe(iOException.getMessage());
            }
            catch (SerialPortException serialPortException) {
                JsscZmodemService.this.getLogger().severe(serialPortException.getMessage());
            }
        }
    }
}

