/*
 * Decompiled with CFR 0.152.
 */
package com.intel.galileo.flash.tool;

import com.intel.galileo.flash.tool.CommunicationService;
import com.intel.galileo.flash.tool.FirmwareCapsule;
import com.intel.galileo.flash.tool.FirmwareUpdateAction;
import com.intel.galileo.flash.tool.FirmwareUpdateTool;
import com.intel.galileo.flash.tool.GalileoFirmwareUpdater;
import com.intel.galileo.flash.tool.GalileoVersion;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PreferencesPanel
extends JPanel {
    private SwingWorker boardVersionUpdater;
    private SwingWorker capsuleVersionUpdater;
    private PropertyChangeListener changes = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if ("updateVersion".equals(string)) {
                GalileoVersion galileoVersion = object != null ? (GalileoVersion)object : null;
                final String string2 = galileoVersion != null ? galileoVersion.toPresentationString() : "Unknown";
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PreferencesPanel.this.capsuleVersion.setText(string2);
                        PreferencesPanel.this.capsuleVersion.repaint();
                    }
                });
            } else if ("currentBoardVersion".equals(string)) {
                GalileoVersion galileoVersion = object != null ? (GalileoVersion)object : null;
                final String string3 = galileoVersion != null ? galileoVersion.toPresentationString() : "Unknown";
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PreferencesPanel.this.boardVersion.setText(string3);
                        PreferencesPanel.this.boardVersion.repaint();
                    }
                });
            }
        }
    };
    private JTextField boardVersion;
    private JTextField capsuleVersion;
    private JRadioButton resourceNameRatio;
    private JComboBox connectionComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel msgJlabel;
    private JButton uploadFirmwareButton;
    private JComboBox servicesComboBox;
    private final GalileoFirmwareUpdater galileo;
    private final FirmwareUpdateAction updateAction;
    private String lastPort = "";
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JFrame frame;
    private FirmwareUpdateTool parentTool;

    public PreferencesPanel(GalileoFirmwareUpdater galileoFirmwareUpdater) {
        this.galileo = galileoFirmwareUpdater;
        this.updateAction = null;
        this.galileo.addPropertyChangeListener(this.changes);
        this.initComponents();
        this.initFirmware();
        List<CommunicationService> list = galileoFirmwareUpdater.getCommunicationServices();
        if (!list.isEmpty()) {
            this.servicesComboBox.removeAllItems();
            for (CommunicationService communicationService : list) {
                this.servicesComboBox.addItem(communicationService);
            }
            this.populateConnections(galileoFirmwareUpdater);
            String string = galileoFirmwareUpdater.getCommunicationConnection();
            if (string != null) {
                this.connectionComboBox.setSelectedItem(string);
            }
        }
        this.updateFirmwareVersion();
    }

    public URL isThereAnyCap() {
        try {
            TreeSet<File> treeSet = new TreeSet<File>(new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return (int)(file.lastModified() - file2.lastModified());
                }
            });
            File file = new File(System.getProperty("user.dir"));
            FilenameFilter filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".cap");
                }
            };
            for (File file2 : file.listFiles(filenameFilter)) {
                treeSet.add(file2);
            }
            File file3 = (File)treeSet.last();
            return file3.toURI().toURL();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void updateCanvasBasedInURL(URL uRL) {
        if (uRL == null) {
            return;
        }
        this.galileo.setLocalCapFile(uRL);
        String string = System.getProperty("user.home");
        File file = new File(string, ".galileo");
        file.mkdir();
        FirmwareCapsule firmwareCapsule = new FirmwareCapsule(this.galileo.getLocalCapFile(), file);
        this.galileo.setUpdate(firmwareCapsule);
        this.updateBoardVersion();
    }

    public PreferencesPanel(GalileoFirmwareUpdater galileoFirmwareUpdater, FirmwareUpdateAction firmwareUpdateAction) {
        this.galileo = galileoFirmwareUpdater;
        this.galileo.addPropertyChangeListener(this.changes);
        this.updateAction = firmwareUpdateAction;
        this.updateAction.setPreferencesPanel(this);
        this.initComponents();
        this.initFirmware();
        List<CommunicationService> list = galileoFirmwareUpdater.getCommunicationServices();
        if (!list.isEmpty()) {
            this.servicesComboBox.removeAllItems();
            for (CommunicationService communicationService : list) {
                this.servicesComboBox.addItem(communicationService);
            }
            this.populateConnections(galileoFirmwareUpdater);
            String string = galileoFirmwareUpdater.getCommunicationConnection();
            if (string != null) {
                this.connectionComboBox.setSelectedItem(string);
            }
        }
        this.jLabel1.setVisible(false);
        this.servicesComboBox.setVisible(false);
        this.uploadFirmwareButton.setEnabled(false);
        this.updateFirmwareVersion();
    }

    private void populateConnections(GalileoFirmwareUpdater galileoFirmwareUpdater) {
        CommunicationService communicationService = galileoFirmwareUpdater.getCommunicationService();
        this.uploadFirmwareButton.setEnabled(false);
        if (communicationService != null) {
            this.servicesComboBox.setSelectedItem(communicationService);
            this.jLabel2.setText(communicationService.getConnectionLabel());
            List<String> list = communicationService.getAvailableConnections();
            this.connectionComboBox.removeAllItems();
            for (String string : list) {
                this.connectionComboBox.addItem(string);
            }
        }
    }

    private void initFirmware() {
        List<FirmwareCapsule> list = this.galileo.getAvailableFirmware();
    }

    private void updateBoardVersion() {
        this.boardVersion.setText("Unknown");
        if (this.galileo.getCommunicationConnection() != null) {
            this.boardVersionUpdater = new SwingWorker<GalileoVersion, Void>(){

                @Override
                protected GalileoVersion doInBackground() throws Exception {
                    return PreferencesPanel.this.galileo.getCurrentBoardVersion();
                }

                @Override
                protected void done() {
                    try {
                        GalileoVersion galileoVersion = (GalileoVersion)this.get();
                        if (galileoVersion != null) {
                            PreferencesPanel.this.boardVersion.setText(galileoVersion.toPresentationString());
                            PreferencesPanel.this.boardVersion.repaint();
                            PreferencesPanel.this.uploadFirmwareButton.setEnabled(true);
                            PreferencesPanel.this.msgJlabel.setText("");
                            PreferencesPanel.this.msgJlabel.setVisible(true);
                        } else {
                            String string = PreferencesPanel.this.connectionComboBox.getSelectedItem().toString();
                            PreferencesPanel.this.uploadFirmwareButton.setEnabled(false);
                            PreferencesPanel.this.msgJlabel.setText("<html><font color='red'>Galileo not found on " + string + "! Please make sure that you select the correct serial port and that you have permission to access.</font></html>");
                            PreferencesPanel.this.msgJlabel.setVisible(true);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            };
            this.boardVersionUpdater.execute();
        }
    }

    private void updateFirmwareVersion() {
        this.capsuleVersion.setText("Unknown");
        if (this.galileo.getUpdate() != null) {
            this.capsuleVersionUpdater = new SwingWorker<GalileoVersion, Void>(){

                @Override
                protected GalileoVersion doInBackground() throws Exception {
                    return PreferencesPanel.this.galileo.getUpdateVersion();
                }

                @Override
                protected void done() {
                    try {
                        GalileoVersion galileoVersion = (GalileoVersion)this.get();
                        if (galileoVersion != null) {
                            PreferencesPanel.this.capsuleVersion.setText(galileoVersion.toPresentationString());
                            FirmwareUpdateTool.capVersion = galileoVersion.toPresentationString();
                            PreferencesPanel.this.resourceNameRatio.setText(galileoVersion.toPresentationString());
                            PreferencesPanel.this.capsuleVersion.repaint();
                            PreferencesPanel.this.frame.repaint();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            };
            this.capsuleVersionUpdater.execute();
            this.repaint();
        }
    }

    public void setFrame(JFrame jFrame) {
        if (jFrame == null) {
            throw new InternalError("NULL frame set ");
        }
        this.frame = jFrame;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.servicesComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.connectionComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.capsuleVersion = new JTextField();
        this.capsuleVersion.setBackground(Color.LIGHT_GRAY);
        this.boardVersion = new JTextField();
        this.boardVersion.setBackground(Color.LIGHT_GRAY);
        this.jLabel5 = new JLabel();
        this.uploadFirmwareButton = new JButton("Upload Firmware");
        this.uploadFirmwareButton.setEnabled(false);
        this.msgJlabel = new JLabel();
        this.msgJlabel.setHorizontalAlignment(0);
        this.uploadFirmwareButton.setAction(this.updateAction);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Connection:");
        this.servicesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None Available"}));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Port:");
        this.connectionComboBox.setEditable(true);
        this.connectionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None"}));
        this.connectionComboBox.setName("connection");
        this.connectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPanel.this.connectionComboBoxActionPerformed(actionEvent);
            }
        });
        this.connectionComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                PreferencesPanel.this.populateConnections(PreferencesPanel.this.galileo);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Firmware:");
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setLabelFor(this.capsuleVersion);
        this.jLabel4.setText("Update Firmware Version:");
        this.capsuleVersion.setEditable(false);
        this.capsuleVersion.setText("Unknown");
        this.capsuleVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPanel.this.capsuleVersionActionPerformed(actionEvent);
            }
        });
        this.boardVersion.setEditable(false);
        this.boardVersion.setText("Unknown");
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setText("Current Board Firmware:");
        this.resourceNameRatio = new JRadioButton("Browse for .cap file");
        this.resourceNameRatio.setSelected(true);
        this.buttonGroup.add(this.resourceNameRatio);
        JRadioButton jRadioButton = new JRadioButton("Browse for .cap file");
        jRadioButton.setSelected(true);
        this.buttonGroup.add(jRadioButton);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Galileo cap file", "cap");
                jFileChooser.setFileFilter(fileNameExtensionFilter);
                jFileChooser.setCurrentDirectory(new File("."));
                int n = jFileChooser.showOpenDialog(PreferencesPanel.this.getParent());
                if (n == 0) {
                    try {
                        PreferencesPanel.this.updateCanvasBasedInURL(jFileChooser.getSelectedFile().toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                } else {
                    PreferencesPanel.this.resourceNameRatio.setSelected(true);
                }
            }
        });
        this.resourceNameRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPanel.this.galileo.setUpdate(PreferencesPanel.this.galileo.getAvailableFirmware().get(0));
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.msgJlabel, -1, 499, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 84, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.servicesComboBox, 0, 289, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.connectionComboBox, 0, 233, Short.MAX_VALUE).addGap(56)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, 168, -2).addComponent(this.jLabel4, -2, 146, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.capsuleVersion, -1, 117, Short.MAX_VALUE).addComponent(this.uploadFirmwareButton, -1, 117, Short.MAX_VALUE).addComponent(this.boardVersion, GroupLayout.Alignment.TRAILING, -1, 117, Short.MAX_VALUE))))).addGroup(groupLayout.createSequentialGroup().addGap(24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resourceNameRatio).addComponent(jRadioButton)))).addGap(130)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(13).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.servicesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.connectionComboBox, -2, -1, -2)).addGap(11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.resourceNameRatio)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jRadioButton).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.capsuleVersion, -2, -1, -2)).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.boardVersion, -2, -1, -2)).addGap(18).addComponent(this.uploadFirmwareButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.msgJlabel, -2, 42, -2).addContainerGap(36, Short.MAX_VALUE)));
        this.setLayout(groupLayout);
        this.connectionComboBox.getAccessibleContext().setAccessibleName("");
    }

    private void capsuleVersionActionPerformed(ActionEvent actionEvent) {
    }

    private void connectionComboBoxActionPerformed(ActionEvent actionEvent) {
        try {
            String string = (String)this.connectionComboBox.getSelectedItem();
            if (string != this.lastPort) {
                this.lastPort = string;
                this.galileo.invalidateBoardVersion();
            }
            if (!this.galileo.getQueryState()) {
                this.galileo.setQueryState(true);
                this.boardVersion.setText("");
                string = (String)this.connectionComboBox.getSelectedItem();
                this.galileo.setCommunicationConnection(string);
                this.updateBoardVersion();
                this.galileo.setQueryState(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void disableUI() {
        this.parentTool.setEnabled(false);
    }

    public void enableUI() {
        this.parentTool.setEnabled(true);
    }

    public void setFirmwareUpdateTool(FirmwareUpdateTool firmwareUpdateTool) {
        this.parentTool = firmwareUpdateTool;
    }

    public boolean isUpdateRunning() {
        return this.updateAction.isRunning();
    }
}

