#! /bin/sh

# Copyright (c) 2012, Wind River Systems, Inc.
#
# The right to copy, distribute, modify, or otherwise make use
# of this software may be licensed only pursuant to the terms
# of an applicable Wind River license agreement.
set -u

function qecho
{
    [ ${QUIET} -ne 1 ] && echo "$@"
}

function env_check
{
    if [ $# != 1 ]; then return 2; fi
    local BIN=""
    local VAR=$(echo $1|awk '{ print toupper($0) }')

    qecho -n "checking for $1 ... "|awk '{ printf("%-30s"), $0}'
    BIN=$(which $1 2>/dev/null|head -n 1)

    if [ ${#BIN} != "0" ]; then
        qecho "${BIN}"
        export "${VAR}=${BIN}"
        return 0
    else
        qecho "Not Found!"
        return 1
    fi  
}

