#!/bin/sh
#
# Called from udev
#
# Attempt to mount any added block devices and umount any removed devices


MOUNT="/bin/mount"
PMOUNT="/usr/bin/pmount"
UMOUNT="/bin/umount"

for line in `cat /etc/udev/mount.blacklist`
do
	if [ ` expr match "$DEVNAME" "$line" ` -gt 0 ];
	then
		logger "udev/mount.sh" "[$DEVNAME] is blacklisted, ignoring"
		exit 0
	fi
done

postboot_vfat_kernel_image() {
	if grep -q "bootonce" /proc/cmdline ; then
		# Bootonce is validated
		cp /boot/efi/bzImage-bootonce /boot/efi/bzImage 2>/dev/null
		cp /boot/efi/bzImage-bootonce.auth /boot/efi/bzImage.auth 2>/dev/null
		cp /boot/efi/idp-initramfs-bootonce.img /boot/efi/idp-initramfs.img 2>/dev/null
		cp /boot/efi/idp-initramfs-bootonce.img.auth /boot/efi/idp-initramfs.img.auth 2>/dev/null
	fi
}

automount() {
	name="`basename "$DEVNAME"`"

	#Automatically mount bootable FAT parition to /boot/efi
	id_file="/sys/firmware/efi/efivars/ESPVolSerialNumber-4a67b082-0a4c-41cf-b6c7-440b29bb8c4f"
	test -f $id_file && {
		id="`cat $id_file | cut -c 5-`"
		dev="`blkid -U $id`"
		! test -d "/boot/efi" && mkdir -p "/boot/efi"
		$MOUNT -o async $dev "/boot/efi"
		postboot_vfat_kernel_image
	}

	! test -d "/media/$name" && mkdir -p "/media/$name"

	if ! $MOUNT -t auto -o sync $DEVNAME "/media/$name"
	then
		#logger "mount.sh/automount" "$MOUNT -t auto $DEVNAME \"/media/$name\" failed!"
		rm_dir "/media/$name"
	else
		logger "mount.sh/automount" "Auto-mount of [/media/$name] successful"
		touch "/tmp/.automount-$name"
	fi
}

rm_dir() {
	# We do not want to rm -r populated directories
	if test "`find "$1" | wc -l | tr -d " "`" -lt 2 -a -d "$1"
	then
		! test -z "$1" && rm -r "$1"
	else
		logger "mount.sh/automount" "Not removing non-empty directory [$1]"
	fi
}

if [ "$ACTION" = "add" ] && [ -n "$DEVNAME" ]; then

	if [ -x "$PMOUNT" ]; then
		$PMOUNT $DEVNAME 2> /dev/null
	elif [ -x $MOUNT ]; then
		$MOUNT $DEVNAME 2> /dev/null
	fi

	# If the device isn't mounted at this point, it isn't
	# configured in fstab (note the root filesystem shows up as
	# /dev/root in /proc/mounts, so parse the command line for
	# that case)
	root=`sed 's/\(^\|.* \)root=\([^ ]*\).*/\2/' /proc/cmdline`
	if [ "$root" != "$DEVNAME" ]; then
		grep -q "^$DEVNAME " /proc/mounts || automount
	fi
fi



if [ "$ACTION" = "remove" ] && [ -x "$UMOUNT" ] && [ -n "$DEVNAME" ]; then
	for mnt in `cat /proc/mounts | grep "$DEVNAME" | cut -f 2 -d " " `
	do
		$UMOUNT $mnt
	done

	# Remove empty directories from auto-mounter
	name="`basename "$DEVNAME"`"
	test -e "/tmp/.automount-$name" && rm_dir "/media/$name"
fi
