#!/bin/sh

#harded firewall rules
[ -f /etc/config/firewall ] && {
	#harded default policy
	uci set firewall.@defaults[0].syn_flood="1"
	uci set firewall.@defaults[0].input="DROP"
	uci set firewall.@defaults[0].forward="DROP"

	uci set firewall.@zone[1].input="REJECT"

	#open port 111 for rpcbind
	isenabled_rpcbind=`systemctl is-enabled rpcbind.socket 2>&1`
	isenabled_portmap=`systemctl is-enabled portmap 2>&1`
	[ $isenabled_rpcbind == "enabled" ] || [ $isenabled_portmap == "enabled" ] && {
		cfgid=`uci add firewall rule`
		uci set firewall.$cfgid.name="Allow-RPC-From-Anywhere"
		uci set firewall.$cfgid.src="*"
		uci set firewall.$cfgid.proto="tcpudp"
		uci set firewall.$cfgid.dest_port="111"
		uci set firewall.$cfgid.target="ACCEPT"
	}

	#open port 135 for OPC
	isenabled_dcom=`systemctl is-enabled dcom 2>&1`
	[ $isenabled_dcom == "enabled" ] && {
		cfgid=`uci add firewall rule`
		uci set firewall.$cfgid.name="Allow-OPC-From-Anywhere"
		uci set firewall.$cfgid.src="*"
		uci set firewall.$cfgid.proto="tcp"
		uci set firewall.$cfgid.dest_port="135"
		uci set firewall.$cfgid.target="ACCEPT"
	}

	uci commit
}

