#!/bin/bash

disable_service() {
	systemctl stop $1 2>/dev/null && systemctl disable $1 2>/dev/null || true
}

enable_service() {
	systemctl enable $1 2>/dev/null && systemctl start $1 2>/dev/null || true
}

disabled_service() {
	systemctl is-enabled $1 2>/dev/null && return 1 ; return 0
}

enabled_service() {
	systemctl is-enabled $1 2>/dev/null
}

uninstall_package() {
	rpm -q --quiet $1 && { echo "remove $1 ..."; rpm -e $1 || rpm -e --noscripts $1 ; } || true
}

nonexist_package() {
	rpm -q --quiet $1 ; test $? != 0
}

nonexist_process() {
	for i in `pgrep -f $1`; do test "$(readlink -f /proc/$i/exe)" = "$2" && return 1 ; done ; return 0
}

sysctl_set() {
	echo $* >> /etc/sysctl.d/60-lockdown.conf
}

sysctl_check() {
	test "$(sysctl -n $1)" = "$2"
}

config_set() {
	sed -i "s/^#*\($2[[:space:]]\+\).*/\1$3/" $1
}

config_check() {
	v=$(awk '$1=="'$2'"{a=$2}END{print a}' $1) ; test "$v" = $3
}

should_empty() {
	test -z "$*" || { echo $*; false; }
}

should_not_empty() {
	test -n "$*"
}

remove_file() {
	mkdir -p /tmp/lockdown-removed && \
		cp -a --parents $* /tmp/lockdown-removed && \
		rm -rf $*
}
