#!/bin/sh
##
#  deploy MEC protection and set MEC password
#
#
##

conf_file=/etc/mcafee/solidcore/solidcore.conf
passwd_file=/usr/local/mcafee/solidcore/passwd
tmp_file=/tmp/.sad_min_pass_wd-$$_.tmp
is_passwd_match="no"
is_mec_enabled="no"

ROOT="$1"
[ "$ROOT" = "/" ] && ROOT=""

## start service if not started yet
systemctl start scsrvc &>/dev/null || {
	rpm -q solidcores3 &>/dev/null || {
		echo "MEC not found, Skip."
		exit 0
	}
	systemctl restart scsrvc &>/dev/null || {
		echo "Failed to start MEC service"
		exit 1
	}
}

## recover MEC CLI access
if ! sadmin status | grep -q "Local CLI access:.*Recovered" &>/dev/null; then
	sadmin recover &>/dev/null || {
		echo "Unable to lockdown MEC, cannot enable MEC CLI."
		exit 1
	}
fi

## disable MEC
if sadmin status | grep -q "Solidifier:.*Enabled" &>/dev/null; then
	is_mec_enabled="yes"
	if [ -f $passwd_file ] && [ $(stat --format="%s" $passwd_file 2>/dev/null) -gt 50 ]; then
		if [ -n "$MEC_PASSWORD" ] && sadmin disable -z "$MEC_PASSWORD" &>/dev/null; then
			is_passwd_match="yes"
		else
			echo "Unable to lockdown MEC, unknown MEC password.
	You can disable MEC in current system with \"sadmin disable\",
	or remove MEC password with \"sadmin passwd -d\", before lockdown."
			exit 2
		fi
	else
		sadmin disable &>/dev/null || {
			echo "Unable to lockdown MEC, cannot disable MEC."
			exit 1
		}
	fi
fi

## disable password
rm -rf $tmp_file
[ -f $passwd_file ] && mv -f $passwd_file $tmp_file

## set password
if [ -n "$MEC_PASSWORD" ]; then
	screen -dmS mec sadmin passwd
	sleep 1
	screen -S mec -p 0 -X stuff "$MEC_PASSWORD$(printf \\r)"
	sleep 1
	screen -S mec -p 0 -X stuff "$MEC_PASSWORD$(printf \\r)"
	# wait a while for command
	for i in $(seq 120); do
		pgrep -f "sadmin passwd" &>/dev/null || break
		sleep 1
	done
	sleep 1

	if [ -f $passwd_file ]; then
		if [ -n "$ROOT" ]; then
			mv -f $passwd_file $ROOT$passwd_file
		else
			mv -f $passwd_file $tmp_file
		fi
	else
		pkill -f "sadmin passwd"
		if [ $is_passwd_match = "yes" ]; then
			[ -n "$ROOT" ] && cp $tmp_file $ROOT$passwd_file
		else
			echo "Failed to create MEC password."
			# recover password
			[ -f $tmp_file ] && mv -f $tmp_file $passwd_file
			exit 1
		fi
	fi
fi

## Creating MEC whitelist ... (${ROOT:-/})
sadmin clean ${ROOT:-/}
sadmin solidify $ROOT || exit $?

## recover password
[ -f $tmp_file ] && mv -f $tmp_file $passwd_file

## enable and lockdown
if [ -n "$ROOT" ];then
	[ -w $ROOT$conf_file ] || chmod u+rw $ROOT$conf_file
	sed -irq '/^IsSystemVolumeSolidified =.*/s||IsSystemVolumeSolidified = 0x1|' $ROOT$conf_file
	sed -irq '/^RTEModeOnReboot =.*/s||RTEModeOnReboot = 0x1|' $ROOT$conf_file || exit $?
	sed -irq '/^GlobalPassthru =.*/s||GlobalPassthru = 0x0|' $ROOT$conf_file || exit $?
	sed -irq '/^LockdownStatus =.*/s||LockdownStatus = 0x0|' $ROOT$conf_file || exit $?
	# make sure service is enabled
	systemctl --root=$ROOT enable scsrvc

	if [ $is_mec_enabled = "yes" ]; then
		if [ $is_passwd_match = "yes" ]; then
			sadmin enable -z "$MEC_PASSWORD"
		else
			sadmin enable
		fi
	fi
else
	if [ -n "$MEC_PASSWORD" ]; then
		sadmin enable -z "$MEC_PASSWORD" || exit $?
	elif [ -f $passwd_file ] && [ $(stat --format="%s" $passwd_file 2>/dev/null) -gt 50 ]; then
		# password unknown, do nothing
		exit 0
	else
		sadmin enable || exit $?
	fi
	# make sure service is enabled
	systemctl enable scsrvc
fi

exit 0
