#!/bin/sh

create_intel_smart()
{
(
cat << "EOF"
#!/bin/sh

# wraps the smart command, removing access to a couple of options.  On a secure
# system, smart cannot be run directly because McAfee doesn't recognize it as an
# updater.  This script is allowed as an updater, so it can call smart to do its
# work. to test, use this command with any valid smart options and ensure that
# they work properly. Also, try the "--shell", "remove rpm-check-signature" and
# "set rpm-check-signature" options.  Add multiple spaces, tabs and escaped
# whitespace to ensure that added whitespace can't be used to bypass the check.
#

INSTRING=$(echo $@ | sed -r 's/\\(.)/\1/g')

if [[ $INSTRING =~ "remove rpm-check-signature" ||
      $INSTRING =~ "set rpm-check-signature" ||
      $INSTRING =~ "--shell" ]]
then
    echo "EPERM: Operation not permitted"
    exit 1
else
    /usr/bin/smart "$@"
    exit $?
fi
EOF
) > /usr/bin/IntelSmart
chmod 755 /usr/bin/IntelSmart
}

create_intel_smart
