#!/bin/bash

if [ $# -eq 0 ];  then
    echo "Usage: generate_ssh_key user passphrase"
    exit 0
fi

host_userid=$1
passphrase=$2

host_userhome=`cat /etc/passwd | grep "^$host_userid:" | cut -d: -f6`

echo "User is $host_userid"
echo "Passphrase is $passphrase"

if [ -e $host_userhome/.ssh/id_rsa.pub ]; then
        echo "Key already exists, do not create a new key"

else
        echo "Creating Key for user $host_userid"
        mkdir -p $host_userhome/.ssh/
        ssh-keygen -t rsa -b 4092 -C $host_userid@$HOSTNAME -f $host_userhome/.ssh/id_rsa -N "$passphrase" || exit 1
        cat $host_userhome/.ssh/id_rsa.pub >> $host_userhome/.ssh/authorized_keys
fi

chown $host_userid:admin $host_userhome/.ssh
chown $host_userid:admin $host_userhome/.ssh/*

chmod 700 $host_userhome/.ssh
chmod 600 $host_userhome/.ssh/*

exit 0

