#!/bin/sh
append DRIVERS "mac80211"

lookup_phy() {
	[ -n "$phy" ] && {
		[ -d /sys/class/ieee80211/$phy ] && return
	}

	local devpath
	config_get devpath "$device" path
	[ -n "$devpath" ] && {
		for _phy in /sys/devices/$devpath/ieee80211/phy*; do
			[ -e "$_phy" ] && {
				phy="${_phy##*/}"
				return
			}
		done
	}

	local macaddr="$(config_get "$device" macaddr | tr 'A-Z' 'a-z')"
	[ -n "$macaddr" ] && {
		for _phy in $(ls /sys/class/ieee80211 2>/dev/null); do
			[ "$macaddr" = "$(cat /sys/class/ieee80211/${_phy}/macaddress)" ] || continue
			phy="$_phy"
			return
		done
	}
	phy=
	return
}

find_mac80211_phy() {
	local device="$1"

	config_get phy "$device" phy
	lookup_phy
	[ -n "$phy" -a -d "/sys/class/ieee80211/$phy" ] || {
		echo "PHY for wifi device $1 not found"
		return 1
	}
	config_set "$device" phy "$phy"

	config_get macaddr "$device" macaddr
	[ -z "$macaddr" ] && {
		config_set "$device" macaddr "$(cat /sys/class/ieee80211/${phy}/macaddress)"
	}

	return 0
}

check_mac80211_device() {
	config_get phy "$1" phy
	[ -z "$phy" ] && {
		find_mac80211_phy "$1" >/dev/null || return 0
		config_get phy "$1" phy
	}
	[ "$phy" = "$dev" ] && found=1
}

wait_phy_ready() {
	local phy_file=""
	local max_count="10"
	local i="0"

	while [ "${i}" -lt "${max_count}" ];
	do
		phy_file=`ls /sys/class/ieee80211`
		[ -z "${phy_file}" ] || return 0
		sleep 1
		i=$((i + 1))
	done
	return 1
}

detect_mac80211() {
	local vendor_device
	local vendor
	local device
	local realtek_8723be="0x10ec_0xb723"
	local realtek_8188ee="0x10ec_0x8179"
	local found_reltek
	local reltek_done

	devidx=0

	config_load wireless

	while :; do
		config_get type "radio$devidx" type
		[ -n "$type" ] || break
		devidx=$(($devidx + 1))
	done

	found_reltek=0
	reltek_done=0

	wait_phy_ready || return 1

	for dev in $(ls /sys/class/ieee80211); do
		vendor=`cat /sys/class/ieee80211/${dev}/device/vendor| tr "A-Z" "a-z"`
		device=`cat /sys/class/ieee80211/${dev}/device/device| tr "A-Z" "a-z"`
		[ -z "${vendor}" ] && vendor="null"
		[ -z "${device}" ] && device="null"
		vendor_device=${vendor}_${device}
		[ "${vendor_device}" = "${realtek_8723be}" -o "${vendor_device}" = "${realtek_8188ee}" ] && found_reltek=1
		[ $reltek_done -eq 1 ] && [  $found_reltek -eq 1 ] && continue

		found=0
		config_foreach check_mac80211_device wifi-device
		[ "$found" -gt 0 ] && [ $found_reltek -eq 1 ] && reltek_done=1
		[ "$found" -gt 0 ] && continue

		mode_band="ng"
		channel="11"
		htmode="HT20"
		ht_capab=""

		iw phy "$dev" info | grep -q 'Capabilities:' && htmode=HT20
		iw phy "$dev" info | grep -q '2412 MHz' || { mode_band="a"; channel="36"; }

		vht_cap=$(iw phy "$dev" info | grep -c 'VHT Capabilities')
		#[ "$vht_cap" -gt 0 ] && {
		#	mode_band="a";
		#	channel="36"
		#	htmode="VHT80"
		#}

		[ -n $htmode ] && append ht_capab "	option htmode	$htmode" "$N"

		if [ -x /usr/bin/readlink ]; then
			path="$(readlink -f /sys/class/ieee80211/${dev}/device)"
			path="${path##/sys/devices/}"
			dev_id="	option path	'$path'"
		else
			dev_id="	option macaddr	$(cat /sys/class/ieee80211/${dev}/macaddress)"
		fi

		# Initialize the SSID
		wlan0_mac=`cat /sys/class/ieee80211/${dev}/macaddress | head -n 1 | awk -F: '{ print $(NF-1)$NF }'`
		interface=`ls /sys/class/net/ | grep wlan 2>/dev/null | head -n 1`
		[ "${vendor_device}" = "${realtek_8723be}" -o "${vendor_device}" = "${realtek_8188ee}" ] && \
			[ -n "${interface}" ] && \
			wlan0_mac=`cat /sys/class/net/${interface}/address | head -n 1 | awk -F: '{ print $(NF-1)$NF }'`

		ssid="IDPDK-$wlan0_mac"
		cat <<EOF
config wifi-device  wlan$devidx
	option type     mac80211
	option channel  ${channel}
	option hwmode	11${mode_band}
$dev_id
$ht_capab
	option disabled 0

config wifi-iface
	option device   wlan$devidx
	option network  lan
	option mode     ap
	option ssid     ${ssid}
	option encryption psk2
	option key windriveridp

EOF
	devidx=$(($devidx + 1))
	[ $found_reltek = 1 ] && reltek_done=1
	done

	return 0
}

