#
# Copyright (c) 2015 Wind River Systems, Inc.
# The right to copy, distribute, modify, or otherwise
# make use of this software may be licensed only pursuant
# to the terms of an applicable Wind River license agreement.
#
# This is a library file for wr agent config functions which
# will be included and used by the wr-iot-agent service script.
#
# Junxian.Xiao@windriver.com  @2015-04-24
#

WRA_CONF="/var/wra/files/default/default_settings"
SSHD_EXEC="/usr/sbin/sshd"

#===============================================================================
# Json config file parser functions
#===============================================================================
J_PREFIX="wra_jconf_"

J_SERVER_S="ems_server_config"
J_DEBUG_S="debug_config"
J_RS_NUMBER_S="remote_session_config_number"
J_RS_CONFIG_S="remote_session_config_"

J_SERVER_ADDR="server_address"
J_DEBUG_LEVEL="log_level"
J_RS_NUMBER_NUM="number"
J_RS_CONFIG_ENABLE="enable"
J_RS_CONFIG_TYPE="type"
J_RS_CONFIG_NAME="name"
J_RS_CONFIG_SERVER="server"
J_RS_CONFIG_PORT="port"

jconf_get()
{
	jconf get $WRA_CONF $@
}

jconf_export()
{
	local old_s=$1
	local new_s=${2:-$1} #whether need to change session name
	local kv

	for kv in $(jconf_get $old_s) ; do
		eval export ${J_PREFIX}${new_s}_${kv}
	done
}

wra_jconf_get()
{
	eval echo \$${J_PREFIX}$1_$2
}

wra_jconf_log_level()
{
	jconf_get $J_DEBUG_S $J_DEBUG_LEVEL
}

wra_jconf_server_addr()
{
	jconf_get $J_SERVER_S $J_SERVER_ADDR
}

wra_jconf_load_rs()
{
	local rs_num rs_p
	local i=0

	rs_num=$(jconf_get $J_RS_NUMBER_S $J_RS_NUMBER_NUM)
	while [ "$i" -lt "$rs_num" ] ; do
		jconf_export ${J_RS_CONFIG_S}$i
		rs_p=$(wra_jconf_get ${J_RS_CONFIG_S}$i $J_RS_CONFIG_PORT)
		case $rs_p in
			22) jconf_export ${J_RS_CONFIG_S}$i ${J_RS_CONFIG_S}ssh ;;
		esac
		let i=i+1
	done
}

wra_jconf_rs_sshd_enabled()
{
	local en=$(wra_jconf_get ${J_RS_CONFIG_S}ssh ${J_RS_CONFIG_ENABLE})
	[ "$en" == 1 ] && return 0 || return 1
}

