#===============================================================================
#
# Copyright (c) 2015 Wind River Systems, Inc.
# The right to copy, distribute, modify, or otherwise
# make use of this software may be licensed only pursuant
# to the terms of an applicable Wind River license agreement.
#
# This is a library file for systemd functions which will be
# included and used by the wr-iot-agent service script.
#
# Junxian.Xiao@windriver.com  @2015-04-24
#


#===============================================================================
# Basic systemd functions
#===============================================================================
systemd_service_status()
{
	local service="$1"

	which systemctl >/dev/null 2>&1 || return 0

	systemctl status $service >/dev/null 2>&1
}

systemd_service_start()
{
	local service="$1"

	which systemctl >/dev/null 2>&1 || return 0

	systemctl is-enabled $service >/dev/null 2>&1 || {
		echo "Enabling $service ..."
		systemctl enable $service >/dev/null 2>&1
		systemctl is-enabled $service >/dev/null 2>&1 || {
			echo "Failed to enable $service"
			return 1
		}
	}

	echo "Starting $service ..."
	systemctl start $service >/dev/null 2>&1

	# Check status again after start it above
	systemctl status $service >/dev/null 2>&1 && return 0

	echo "Failed to start $service ..."
	return 1
}

systemd_service_stop()
{
	local service="$1"

	which systemctl >/dev/null 2>&1 || return 0

	echo "Stoping $service ..."
	systemctl stop $service >/dev/null 2>&1

	# Check status again after start it above
	systemctl status $service >/dev/null 2>&1 || return 0

	echo "Failed to stop $service ..."
	return 1
}

systemd_service_restart()
{
	local service="$1"

	which systemctl >/dev/null 2>&1 || return 0

	systemctl status $service >/dev/null 2>&1 || {
		systemd_service_start $service && return 0 || return 1
	}

	echo "Restarting $service ..."
	systemctl restart $service >/dev/null 2>&1

	systemctl status $service >/dev/null 2>&1 && return 0

	echo "Failed to start $service ..."
	return 1
}

systemd_service_check()
{
	local service="$1"

	which systemctl >/dev/null 2>&1 || return 0
	systemctl status $service >/dev/null 2>&1 && return 0

	systemd_service_start $service
}

#===============================================================================
# Services special functions
#===============================================================================

systemd_sshd_installed()
{
	[ -e "${SSHD_EXEC}" ] && return 0 || return 1
}

systemd_start_sshd()
{
	systemd_service_status sshd.socket && return 0
	systemd_service_start sshd.socket
}

systemd_stop_sshd()
{
	systemd_service_stop sshd.socket
}

