#!/usr/bin/env python

# Copyright (c) 2014 Intel Corporation.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in
# the documentation and/or other materials provided with the
# distribution.
# * Neither the name of Intel Corporation nor the names of its
# contributors may be used to endorse or promote products derived
# from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import os
import re
import subprocess

def print_keywarning(str):
    dashboard.write('\n-------------------Security Warning---------------------\n')
    dashboard.write('This project is using default keys for ')
    dashboard.write(str);
    dashboard.write(' \n');
    dashboard.write('For development phase, this is OK. For production builds, consider creating your keys using SST create-key command.  See Wind River IDP manual for more info on SST tool\n')

def print_no_srm():
    dashboard.write('\n-------------------Security Warning---------------------\n')
    dashboard.write('For development phase, disabling SRM is OK. Disabling SRM disables verified boot, TPM related libs, Grsecruity.\n');
    dashboard.write('For production phase, enable SRM in your config.\n');

def print_no_mcafee():
    dashboard.write('\n-------------------Security Warning---------------------\n')
    dashboard.write('Image built without mcafee layer.  Consider building with layer wr-mcafee.\n');


def print_no_ems():
    dashboard.write('\nImage built without ems.  To enable EMS include configure option wr-ems.\n');

def clean_string(str):
    str = str.replace('\r', '')
    str = str.replace('\t', '')
    str = str.replace('\f', '')
    str = str.replace(' ', '')
    str = str.replace('a', '')



def remove_comments(list):
    length = len(list)
    i = 0
    while i < length:
        for a in list:
            if a.startswith('#'):
                list.remove(a)
        i += 1

def find_config_str(list):
    index = -1;
    for a in list:
        index = a.find('configure')
        if index != -1:
            confstr = a
            break
    list=confstr.split(' ')
    return list

def check_item(str, list):
    for a in list:
        index = a.find(str)
        if index != -1:
            temp_str = a
            break
    index = temp_str.find('=')
    ret_str = temp_str[index+1:]
    return ret_str



def check_keys_status():
    if os.path.exists('./triage_tool/keysum.log'):
        keysumlog = open('./triage_tool/keysum.log')
        keysumstr = keysumlog.read()

        kindex = keysumstr.find('55649281ad9ea853a379c5d0ac19df5a')
        if kindex != -1:
            print_keywarning("ownercert ");
        else:
            print('Owner Cert OK');

        kindex = keysumstr.find('2411a73dfe4a747ddfd1edd56fec33e6')
        if kindex != -1:
            print_keywarning("owner-private ");
        else:
            print('Owner Private OK');

        kindex = keysumstr.find('f04cb1e76a66bcd440df2a7c72c64689')
        if kindex != -1:
            print_keywarning("vendor cert ");
        else:
            print('Vendor Cert OK');

        kindex = keysumstr.find('8ea1aeee0497c62f46a381e7f4b358b6')
        if kindex != -1:
            print_keywarning("vendor private ");
        else:
            print('Vendor Private OK');
        keysumlog.close();
    else:
        print('keysum not found');

def print_info_dashboard(str, key):
    if str.find(key) != -1:
        dashboard.write(str)


def main():
    if  os.path.exists('./triage_tool_target/system_information.out'):
        syslog = open('./triage_tool_target/system_information.out')
        syslog_lines = open('./triage_tool_target/system_information.out')
        syslogstr = syslog.read()
        sysloglines = syslog_lines.readlines()
        for a in sysloglines:
            print_info_dashboard(a, 'Device Name')
            print_info_dashboard(a, 'Linux Kernel')
            print_info_dashboard(a, 'model name')
            print_info_dashboard(a, 'MemTotal')

        if (syslogstr.find('aa:bb:cc:dd:ee:ff') != -1) or (syslogstr.find('AA:BB:CC:DD:EE:FF') != -1):
            dashboard.write('Default MAC address AA:BB:CC:DD:EE:FF detected. \n')
            dashboard.write('MAC address can be fixed by modifying platform.ini and building the image again. \n')
            dashboard.write('Multiple gateways with default MAC addresses can results in connectivity issues.\n')

        else:
            dashboard.write('MAC address: OK.\n')


        if (syslogstr.find('IMA is enabled') != -1):
            dashboard.write('IMA is enabled. \n')

        if (syslogstr.find('IMA is disabled') != -1):
            dashboard.write('IMA is disabled. \n')

        if (syslogstr.find('gradm') != -1):
            dashboard.write('Image is likely SRM enabled.\n')
            dashboard.write('Using kernel with GRsecurity.\n')
        else:
            dashboard.write('GRsecurity not present.  Did you build without SRM?\n')

        # sshd status
        p = subprocess.Popen(['systemctl', 'status', 'sshd.socket'], stdout=subprocess.PIPE)
        sshd_out, sshd_err = p.communicate()
        sshd_active = re.search(r'\(listening\)', sshd_out)
        if sshd_active:
            dashboard.write('Service sshd is running. \n')
        else:
            dashboard.write('Service sshd is not running. You can start by executing: systemctl start sshd.socket\n')

        # tcsd status
        p = subprocess.Popen(['systemctl', 'status', 'tcsd.service'], stdout=subprocess.PIPE)
        tcsd_out, tcsd_err = p.communicate()
        tcsd_inactive = re.search(r'\(dead\)', tcsd_out)
        if tcsd_inactive:
            dashboard.write('Service tcsd is not running. You can start by executing: systemctl start tcsd.service\n')
        else:
            dashboard.write('Service tcsd is running. \n')

        memidx = syslogstr.find('Mem:')
        if (memidx != -1):
            memstr =  syslogstr[memidx:memidx + 100]
            memlist = memstr.split()
            usedmem = float(memlist[2])/float(memlist[1])*100
            if usedmem > 70:
                dashboard.write('Using more than 70% of the available free memory.\n')
            else:
                dashboard.write('Memory usage: OK.\n')
        syslog.close()
        syslog_lines.close()
    else:
        dashboard.write('Error:  system_information.log is not present.\n')



    try:
        p = subprocess.Popen(["sadmin", "status"], stdout=subprocess.PIPE)
        out, err = p.communicate()
        dashboard.write('Image was built with MEC layer \n')
        if out.find('Unsolidified') != -1:
            dashboard.write('SECURITY WARNING: Volume is Unsolidified.  You can solidify using sadmin so \n')
        mflist = out.split('\n')
        for a in mflist:
            if a.find('Solidifier:') != -1:
                if a.find('Disabled') != -1:
                    dashboard.write('SECURITY WARNING: McAfee Solidifier is Disabled. \n')

    except:
        dashboard.write('McAfee Embedded Controller not present.  Build your image including layer wr-mcafee. \n')



    try:
        p = subprocess.Popen("df",  stdout=subprocess.PIPE)
        out, err = p.communicate()
        lines = out.splitlines()
        used_pct = -1
        fields = lines[1].split()

        for field in fields:
            if field.endswith("%"):
                used_pct = int(field[:-1])
                break

        if used_pct == -1:
            dashboard.write('Disk space could not be determined.\n')
        elif used_pct > 80:
            dashboard.write('Warning: Disk space is low (' + str(used_pct) + '%).\n')
        else:
            dashboard.write('Available diskspace is OK (' + str(used_pct) + '%).\n')

    except:
        dashboard.write('Could not execute df \n')

'''
Script begins here
'''
dashboard = open('./triage_tool_target/dashboard.out', 'w')
dashboard.write("Generated by Triage Tool Version 2.0\n\n")
dashboard.write("Platform Information \n")
dashboard.write("---------------------------\n\n")

main()
dashboard.write('Please attach the generated zipped tar file to Intel(R) Premier Support issues for faster resolution. \n')
dashboard.write("---------------------------\n\n")
dashboard.write("Steps for self diagnosis\n\n")
dashboard.write("---------------------------\n\n")
dashboard.write("1)Untar the generated zip file in a temporary directory.\n\n")
dashboard.write("2)For detailed hardware and software information, see system_information.out \n\n")
dashboard.write("3)For other useful systems logs, see dmesg.out and syslog.out \n\n")
dashboard.write("4)For summary of information, see dashboard.out \n\n")
dashboard.write("---------------------------\n\n")


dashboard.close();
