#!/bin/bash
# Copyright (c) 2013 Intel Corporation.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in
# the documentation and/or other materials provided with the
# distribution.
# * Neither the name of Intel Corporation nor the names of its
# contributors may be used to endorse or promote products derived
# from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#######################################################################
#
# Triage Tool for IoT Gateway Target Device.
#
#
# Author: Aamir Yunus
#
# Usage: sh ./triage_tool_target.sh
# Note: Don't execute this script as ./triage_tool_target.sh as
# IMA might block it.  Makesure McAfee Embedded Control is disabled
#
# Outputs:
# The script will generate an archive file with Target system
# hardware and software information.  Provide the archive file to
# your Intel support representative.
#
# The script does not collect any private key information
###################################################################


RED='\e[0;31m'
CYAN='\e[0;36m'
BLUE='\e[0;34m'
NOCOLOR='\e[0m'
TARGET_DIR=`pwd`/triage_tool_target
SYSINFO=$TARGET_DIR/system_information.out
SYSLOG=$TARGET_DIR/syslog.out
PKGINFOR=$TARGET_DIR/installed_package_information.out
DMESGOUT=$TARGET_DIR/dmesg.out
RPMINFO=$TARGET_DIR/installed_rpms.out
TRIAGELOG=$TARGET_DIR/triagetool.log
SC_HOST_NAME=`hostname | awk -F. {'print $1'}`;
DATE_TIME=`date +%m-%d-%y_%H-%M-%S`;
TARGET_FILE=triagetool-$SC_HOST_NAME-$DATE_TIME.tar
TARGET_BASE=`basename $TARGET_DIR`
DEBUG_ENABLED=1
DEBUG_MESSAGE ()
{
    [ "$DEBUG_ENABLED" = "1" ] && echo -e "${BLUE} $@ ${NOCOLOR}"
}

usage()
{
  cat <<EOF
  sh ./triage_tool.sh
EOF
}

print_error_and_exit()
{

 echo -e "${RED}$@${NOCOLOR}"
 exit 1
}

create_target_directory ()
{
    rm -rf $TARGET_DIR;
    mkdir -p $TARGET_DIR;
}


check_if_the_user_root ()
{
    [ "$(whoami)" = "root" ] || {
        print_error_and_exit "Use sudo or run triage tool as root"
    }
    return 0
}

########### Script Starts Here #################################################



check_if_the_user_root
create_target_directory
echo $TARGET_FILE
dmesg > $DMESGOUT
_devicename="$(cat /etc/device_name)"
_kversion=$(uname -srv 2>/dev/null)
_krelease=$(uname -r 2>/dev/null)
_mac=$(/sbin/ifconfig eth0 2>/dev/null | grep HWaddr | cut -b39-)
echo -e "Triage Tool Target Version 2.0\n" > $SYSINFO
echo "Script running.  It may take few minutes to complete........"
echo -e "Device Name $_devicename\n" >> $SYSINFO
echo " " >> $SYSINFO
echo -e "Linux Kernel  $_kversion\n" >> $SYSINFO
echo -e "Kernel_release  $_krelease\n" >> $SYSINFO
echo -e "MAC Address $_mac\n" >> $SYSINFO
echo "CPU info" >> $SYSINFO
echo "********************************************" >>$SYSINFO
cat /proc/cpuinfo >> $SYSINFO
echo -e  "\nFirmware Version" >> $SYSINFO
echo "********************************************" >>$SYSINFO
if [ -f /sys/firmware/board_data/flash_version ]; then
	cat /sys/firmware/board_data/flash_version >> $SYSINFO
else
        echo "Firmware info not present"
fi
echo -e "********************************************\n" >>$SYSINFO
echo "Memory info" >> $SYSINFO
echo "********************************************" >>$SYSINFO
cat /proc/meminfo >> $SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"lspci"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
lspci -nn	>>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"lsusb"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
lsusb		>>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"lsblk"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
lsblk		>>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"df"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
df		>>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"fdisk"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
fdisk -l	>>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"mount"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
mount		>>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"free"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
free -m		>>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"ifconfig"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
ifconfig		>>$SYSINFO
echo 	"tpm info"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
tpm_version 2>&1 | tee  >>$SYSINFO
dmesg | grep -i tpm >>$SYSINFO
cat /var/log/syslog |  grep -i tpm >>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo "TPM STATISTICS" >>$SYSINFO
echo "********************************************" >>$SYSINFO
tpm_statistic             >>$SYSINFO
echo -e  "********************************************\n" >>$SYSINFO
echo 	"GPIO"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
cat /sys/kernel/debug/gpio >>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"GR Security"	>>$SYSINFO
echo  "********************************************" >>$SYSINFO
gradm -v >>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"LuCI"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
LUCI=$(curl -k https://localhost | grep -ic luci)
if [ $LUCI = "0" ]; then
   echo "LuCI is disabled" >> $SYSINFO
else
   echo "LuCI is enabled" >> $SYSINFO
fi
echo -e "********************************************\n\n" >>$SYSINFO
echo 	"Installed Software"	>>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"JAVA"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
java -version 2>&1 | tee  -a $SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"SQLITE"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
sqlite3 -version >>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"OPEN SSL"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
openssl version >>$SYSINFO
echo -e "********************************************\n\n" >>$SYSINFO
echo 	"Running Processes"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
ps -ef  >>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"lsmod"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
lsmod  >>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
echo 	"etc/config/network"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
cat /etc/config/network  >>$SYSINFO
echo -e  "********************************************\n" >>$SYSINFO
echo "/etc/config/wireless"  >>$SYSINFO
echo "********************************************" >>$SYSINFO
if [ -f /etc/config/wireless ]; then
	cat 	/etc/config/wireless	>>$SYSINFO
else
	echo "etc wireless not present"
fi
echo -e "********************************************\n" >>$SYSINFO
echo 	"Bluetooth"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
hciconfig  >>$SYSINFO
echo -e "********************************************\n" >>$SYSINFO
cat /var/log/syslog > $SYSLOG
if [ -f /usr/local/mcafee/solidcore/tools/gatherinfo/gatherinfo.sh ]; then
  echo -e "${BLUE} Gather info installed ${NOCOLOR}"
  /usr/local/mcafee/solidcore/tools/gatherinfo/gatherinfo.sh
  mv gather*gz $TARGET_DIR
else
  echo -e  "${RED} McAfee Gatherinfo not present ${NOCOLOR}"
fi


spm_repo --listrpm 2>&1 | tee  >> $RPMINFO

echo -e "********************************************\n" >>$SYSINFO
echo 	"IMA Status"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
echo "echo IMA is disabled" > $TARGET_DIR/a.sh
chmod +x $TARGET_DIR/a.sh
TEST=''
TEST=`$TARGET_DIR/a.sh`
if [ "$TEST" == "IMA is disabled" ]; then
    echo "IMA is disabled" >> $SYSINFO
else
    echo "IMA is enabled" >> $SYSINFO
fi


echo -e "********************************************\n" >>$SYSINFO
echo 	"MEC status"	>>$SYSINFO
echo "********************************************" >>$SYSINFO
sadmin status >>$SYSINFO

if [ -f parser_target.py ]; then
        python parser_target.py
else
        echo "parser not present" >> $TRIAGELOG
fi

if [ -f /home/etasapp/intel/logs/banjo.canyon.client.log ]; then
        cp /home/etasapp/intel/logs/banjo.canyon.client.log $TARGET_DIR
else
        echo "banjo.canyon.client.log not present." >> $TRIAGELOG
fi

if [ -f /home/inteltcsapp/intel/logs/tpmcertmgmt.log ]; then
        cp /home/inteltcsapp/intel/logs/tpmcertmgmt.log $TARGET_DIR
else
        echo "tpmcertmgmt.log not present." >> $TRIAGELOG
fi

tar -cvf $TARGET_FILE $TARGET_BASE
gzip -f $TARGET_FILE

if [ -f $TARGET_DIR/dashboard.out ]; then
        cat $TARGET_DIR/dashboard.out
else
        echo "Dashboard.out not present" >> $TRIAGELOG
fi
#rm -rf $TARGET_DIR
echo -e  "${CYAN}Script Completed ${NOCOLOR}"
