#!/bin/bash
#===============================================================================
# Copyright (c) 2012-2015 Wind River Systems, Inc.
# The right to copy, distribute, modify, or otherwise
# make use of this software may be licensed only pursuant
# to the terms of an applicable Wind River license agreement.
#===============================================================================
MYNAME=$(basename $0)
DEPLOYTOOL="/sbin/deploytool"

# option to be used by deploytool
DIOPTS=""

#===============================================================================
# Functions
#===============================================================================
SHOW() {
    local level=$1 c p e="\n"

    case $level in
        ERROR)   c=31; p="[  ERROR] " ;;
        WARNING) c=32; p="[WARNING] " ;;
        INFO)    c=00; p="[   INFO] " ;;
        DEBUG)   c=00; p="[  DEBUG] " ;;
        *) return 0 ;;
    esac

    shift
    echo -ne "\033[1;${c}m${PREFIX:-$p}$@${END:-$e}\033[0m"
}

EXIT() {
    END="\n\n" SHOW "$@"
    SHOW INFO "Exit ..."
    exit 1
}

OPTAPPEND() {
    DIOPTS="$DIOPTS $@"
}

show_help()
{
    cat <<EOF
Usage: $MYNAME options

Options
 -d vfat-partition
    Set the vfat partition used in the tool to install bzImage,grub stuffs.
    e.g. /dev/sdb1

 -k rootfs-partition
    Set the rootfs partition used in the tool to install root filesystem.
    e.g. /dev/sdb3

 -f rootfs-tarball
    Rootfs tarball, e.g. ./intel-xxx-idp-idp-dist.tar.bz2

 -b board-name
    It is only for backward-compatibility but not used now.

 -u
    Deploy uefi files in first vfat partition. Assume that there are
    grub efi files in the rootfs partition.

 -c
    Perform the BIOS capsule update to update the on board Flash image in
    quark target boards. It is ONLY supported in quark target.

 -v
    Enable debug mode.  This will produce a lot of extra messages from
    the tool, but does not change its operating behaviour at all.

 -h
    Show this help menu.

EOF

## NOTE ##
#There is a new version of deploytool in the same directory as this tool,
#you are suggested to use deploytool directly instead of ${MYNAME}.
#deploytool provides more function and the uniform interafces in both host
#and target. This $MYNAME tool may will be discarded in the near future.
}

#===============================================================================
# Start Main
#===============================================================================
trap "EXIT ERROR Canceled" SIGINT

if [ ! -x $DEPLOYTOOL ] ; then
    EXIT ERROR "Cannot find $DEPLOYTOOL to do ${MYNAME}!"
fi

# Parse command line options
while getopts "d:k:f:b:ucvh" opt ; do
    echo "$OPTARG" | grep -q "^-.*" && {
        EXIT ERROR "option -$opt requires an argument!"
    }

    case $opt in
        d) OPTAPPEND "-V $OPTARG" ;;
        k) OPTAPPEND "-R $OPTARG" ;;
        f) OPTAPPEND "-f $OPTARG" ;;
        b) SHOW INFO "'-b' option is useless and ignored!" ;;
        u) OPTAPPEND "-u" ;;
        c) OPTAPPEND "-c" ;;
        v) OPTAPPEND "-v 7" ;;
        h) show_help && exit 0 ;;
        ?) show_help && exit 1 ;;
    esac
done
[ -n "$OPTIND" -a $OPTIND -le $# ] && {
    eval opt=\$$OPTIND
    EXIT ERROR "Invalid option: $opt"
}

SHOW INFO "Call deploytool to do ${MYNAME}:"
SHOW INFO "$DEPLOYTOOL $DIOPTS"
$DEPLOYTOOL $DIOPTS && exit 0 || exit 1
