#!/bin/bash

# **** Perform CSV conversion of System Browser log *****

SELF=$0
if [ -L "$SELF" ]; then
	SELF=`ls -l $SELF | sed -e 's/.*->\ \(.*\)/\1/g'`
fi
WBDIR=`dirname "$SELF"`/../..
DIR="$WBDIR/.."

# Make sure to use a writable workspace
workspace=~/.cliConversionsWS
for arg in $@ ; do
  if [ "$arg" == "-data" ]; then
    workspace="";
  fi;
done
if [ "$workspace" != "" ]; then
   workspaceArg="-data $workspace";
fi

wrwbCmd="$WBDIR/eclipse/x86-linux2/wrwb"
wrwbArgs="-nosplash -application com.windriver.analysis.systembrowser.common.core.cliConvert $workspaceArg"
jvmArgs="-vmargs -DHEADLESS=true -Dosgi.noShutdown=true"
exec "$DIR/wrenv.sh" -p workbench-4 "$wrwbCmd" $wrwbArgs "$@" $jvmArgs

