#!/bin/bash

# **** Perform symbol resolution on System Browser log *****

function printUsage() {
  echo "Usage: cafe-symresolve [-m source;destination]... <input-file> [<output-file>]"
  exit
}

if [ -z "$1" ]; then
  printUsage
fi
if [ "$1" == "-h" -o "$1" == "-help" ]; then
  printUsage
fi

SELF=$0
if [ -L "$SELF" ]; then
	SELF=`ls -l $SELF | sed -e 's/.*->\ \(.*\)/\1/g'`
fi
WBDIR=`dirname $SELF`/../..

declare -a pathMappings
pathMappingCount=0
while [ "$1" == "-m" ]; do
	pathMappings[$pathMappingCount]="-m"
	pathMappingCount=`expr $pathMappingCount + 1`
	pathMappings[$pathMappingCount]="$2"
	pathMappingCount=`expr $pathMappingCount + 1`
	shift 2
done

if [ -z "$1" ]; then
  echo error: No input file.
  printUsage
fi
if [ ! -f "$1" ]; then
  echo error: $1 does not exist or is not a file.
  printUsage
fi
inputFile="$1"
if [ -z "$2" ]; then
  filename=$(basename "$1")
  dirname=$(dirname "$1")
  extension="${filename##*.}"
  filename="${filename%.*}"
  outputFile="${dirname}"/"${filename}"-resolved."${extension}"
else 
  outputFile="$2"
fi

symresolveScript="$WBDIR/wranalysis/symresolve.cafescript"
cafeScriptExe="$WBDIR/x86-linux2/bin/cafe-script"
exec "$cafeScriptExe" "${pathMappings[@]}" "$symresolveScript" "$inputFile" "$outputFile"

