#!/bin/bash

# Copyright (c) 2012 Wind River Systems, Inc.
# The right to copy, distribute, modify, or otherwise
# make use of this software may be licensed only pursuant
# to the terms of an applicable Wind River license agreement.

declare system_rpm_not_installed=0
declare system_rpm_upgradable=0
declare SYS_RPM_PKG="system"

declare install_ok
declare install_fail
pkg_install()
{
    local pkg=`echo $1 | awk -F":" '{print $2}'`

    echo -n -e "${color_info}install package $pkg ${color_off}"
    exec_cmd_toFile "$SMART install -y $pkg"
    local ret=$?
    local tmpPID=$pid
    [[ $ret -eq 0 ]] && {
        set_to_reinstallable ${outputFile}${tmpPID}
        ret=$_SUCCESS
        install_ok=${install_ok}"\t"`echo $1 | awk -F":" '{print $3}'`"\n"
        echo -e "${color_ok} done${color_off}"
    } || {
        ret=$_FAIL
        install_fail=${install_fail}"\t"`echo $1 | awk -F":" '{print $3}'`"\n"
        echo -e "${color_fail} failed${color_off}"
    }

    [[ $verbose -ne 0 ]] && cat ${outputFile}${tmpPID} | sed -e '/^$/d'
    exec_cmd "rm ${outputFile}${tmpPID}"

    return $ret
}

pkgs_install()
{
    local pkgList=("$@")
    local ret=0

    unset install_ok
    unset install_fail
    echo -e "${color_info}start to install new packages${color_off}"
    local item
    for item in ${pkgList[@]}; do
        repos=${repos}`echo $item | awk -F":" '{print $1}'`" "
        tmp_pkg=`echo $item | awk -F":" '{print $2}'`
        exec_cmd_toStr_parser "$REPO_PARSER -f$_REINSTALLABLE -L"
        tmp_output=$outputStr
        exec_cmd "echo \"$tmp_output\" | grep -- ${tmp_pkg}-[0-9].*"
        [[ $? -ne 0 ]] && {
            pkg_install $item
        }
    done

    [[ -z "${install_fail}" ]] && ret=$_SUCCESS || ret=$_FAIL

    return $ret
}

declare reinstall_ok
declare reinstall_fail
pkg_reinstall()
{
    local pkg=`echo $1 | awk -F":" '{print $2}'`

    echo -n -e "${color_info}reinstall package $pkg ${color_off}"
    exec_cmd_toFile "$SMART reinstall -y $pkg"
    local ret=$?
    local tmpPID=$pid
    [[ $ret -eq 0 ]] && {
        set_to_reinstallable ${outputFile}${tmpPID}
        ret=$_SUCCESS 
        reinstall_ok=${reinstall_ok}"\t"`echo $1 | awk -F":" '{print $3}'`"\n"
        echo -e "${color_ok} done${color_off}"
    } || {
        ret=$_FAIL
        reinstall_fail=${reinstall_fail}"\t"`echo $1 | awk -F":" '{print $3}'`"\n"
        echo -e "${color_fail} failed${color_off}"
    }

    [[ $verbose -ne 0 ]] && cat ${outputFile}${tmpPID} | sed -e '/^$/d'
    exec_cmd "rm -rf ${outputFile}${tmpPID}"

    return $ret
}

pkgs_reinstall()
{
    local pkgList=("$@")
    local ret=0

    unset reinstall_ok
    unset reinstall_fail

    echo -e "${color_info}start to reinstall packages${color_off}"
    local item
    for item in ${pkgList[@]}; do
        tmp_pkg=`echo $item | awk -F":" '{print ":"$2":"$3}'`" "
        tmp_pkgs=${tmp_pkgs}${tmp_pkg}
    done

    tmp_pkgs=(`echo $tmp_pkgs | tr " " "\n" | sort | uniq`)
    unset item
    for item in ${tmp_pkgs[@]}; do
        pkg_reinstall $item
    done

    [[ -z "${reinstall_fail}" ]] && ret=$_SUCCESS || ret=$_FAIL

    return $ret
}

declare upgrade_ok
declare upgrade_fail
pkg_upgrade()
{
    local pkg=`echo $1 | awk -F":" '{print $2}'`

    echo -n -e "${color_info}install upgradable package $pkg ${color_off}"
    exec_cmd_toFile "$SMART upgrade -y $pkg"
    local ret=$?
    local tmpPID=$pid
    [[ $? -eq 0 ]] && {
        set_to_reinstallable ${outputFile}${tmpPID}
        ret=$_SUCCESS
        upgrade_ok=${upgrade_ok}"\t"`echo $1 | awk -F":" '{print $3}'`"\n"
        echo -e "${color_ok} done${color_off}"
    } || {
        ret=$_FAIL
        upgrade_fail=${upgrade_fail}"\t"`echo $1 | awk -F":" '{print $3}'`"\n"
        echo -e "${color_fail} failed${color_off}"
    }

    [[ $verbose -ne 0 ]] && cat ${outputFile}${tmpPID} | sed -e '/^$/d'
    exec_cmd "rm -rf ${outputFile}${tmpPID}"

    return $ret
}

pkgs_upgrade()
{
    local pkgList=("$@")
    local item

    unset upgrade_ok
    unset upgrade_fail

    echo -e "${color_info}start to upgrade packages ${color_off}"
    for item in ${pkgList[@]}; do
        tmp_pkg=`echo $item | awk -F":" '{print $3}'`
        tmp_pkg=`echo $tmp_pkg | sed -e 's/\.atom-[0-9a-z]*.rpm/\.atom/g'`
        exec_cmd_toStr_parser "$REPO_PARSER -f$_REINSTALLABLE -L"
        tmp_output=$outputStr
        exec_cmd "echo \"$tmp_output\" | grep $tmp_pkg"
        [[ $? -ne 0 ]] && {
            pkg_upgrade $item
        }
    done

    [[ -z "${upgrade_fail}" ]] && ret=$_SUCCESS || ret=$_FAIL
    return $ret
}

pkg_install_wrapper()
{
    echo -n -e "${color_info}start to install package $@ ${color_off}"
    exec_cmd_toFile "$SMART install $@ -y" # need update pkg status
    echo
    local ret=$?
    local tmpPID=$pid
    cat ${outputFile}${tmpPID} | sed -e '/^$/d'
    [[ $ret -eq 0 ]] && {
       set_to_reinstallable ${outputFile}${tmpPID}
    }
    exec_cmd "rm -rf ${outputFile}${tmpPID}"
}

pkg_reinstall_wrapper()
{
    echo -n -e "${color_info}start to reinstall package $@ ${color_off}"
    exec_cmd_toFile "$SMART reinstall $@ -y" 
    echo
    local ret=$?
    local tmpPID=$pid
    cat ${outputFile}${tmpPID} | sed -e '/^$/d'
    [[ $ret -eq 0 ]] && {
        set_to_reinstallable ${outputFile}${tmpPID}
    }
    exec_cmd "rm -rf ${outputFile}${tmpPID}"
}

pkg_download_wrapper()
{
    echo -n -e "${color_info}start to download package $@ ${color_off}"
    exec_cmd_toFile "$SMART download $@ "
    echo
    local tmpPID=$pid
    cat ${outputFile}${tmpPID} | sed -e '/^$/d'
    exec_cmd "rm -rf ${outputFile}${tmpPID}"
}

pkg_query_wrapper()
{
    echo -n -e "${color_info}start to query package $@ ${color_off}"
    exec_cmd_toFile "$SMART query --installed $@ "
    echo
    local tmpPID=$pid
    cat ${outputFile}${tmpPID} | sed -e '/^$/d'
    exec_cmd "rm -rf ${outputFile}${tmpPID}"
}

pkg_upgrade_wrapper()
{
    echo -n -e "${color_info}start to upgrade package $@ ${color_off}"
    exec_cmd_toFile "$SMART upgrade -y $@ "
    echo
    local ret=$?
    local tmpPID=$pid
    cat ${outputFile}${tmpPID} | sed -e '/^$/d'
    [[ $ret -eq 0 ]] && {
        set_to_reinstallable ${outputFile}${tmpPID}
    }
    exec_cmd "rm -rf ${outputFile}${tmpPID}"
}

pkg_remove_wrapper()
{
    echo -n -e "${color_info}start to remove package $@ ${color_off}"
    exec_cmd_toFile "$SMART remove $@ -y"
    echo
    local ret=$?
    local tmpPID=$pid
    cat ${outputFile}${tmpPID} | sed -e '/^$/d'
    [[ $ret -eq 0 ]] && {
        matchKeywordInFile ${outputFile}${tmpPID} "Removing packages"
        local line=$keyword_lineNum
        [[ $line -ne 0 ]] && {
            start_line=`expr $line + 1`
            matchKeywordInFile ${outputFile}${tmpPID} "will be freed"
            stop_line=`expr $keyword_lineNum - 1`
            [[ $stop_line -le $start_line ]] && {
                exec_cmd "rm ${outputFile}${tmpPID}"
                return
            }
            
            pkg_names=`sed -n ${start_line},${stop_line}p ${outputFile}${tmpPID}`
            pkg_names=(`echo $pkg_names | sed -e 's/@/./g' -e 's/[1-9]://g'`)
            for item in ${pkg_names[@]}; do
                set_to_not_installed $item
            done
        }
    }
    exec_cmd "rm -rf ${outputFile}${tmpPID}"
}

#Get the available updates based on the output of "smart update"
declare pkg_entries
getUpdtList()
{
    local updt_output="$1"

    unset pkg_entries

    local ret=0
    local updtIndex_start
    local updtIndex_stop

    matchKeywordInFile $updt_output "Channels have no new packages"
    [[ $? -eq 0 ]] && ret=$_FAIL || {

        matchKeywordInFile $updt_output "Saving cache..."
        ret=$?
        [[ $ret -eq 0 ]] && {
            updtIndex_stop=`expr $keyword_lineNum - 1`
        } || return $ret # file is broken

        matchKeywordInFile $updt_output "Channels" "have" "new packages"
        ret=$?
        [[ $ret -eq 0 ]] && { 
            updtIndex_start=`expr $keyword_lineNum + 1`
        } || return $ret # no new packages

        [[ $updtIndex_start -lt $updtIndex_stop ]] && {
            local i=$updtIndex_start
            local j=0
            while [[ $i -lt $updtIndex_stop ]]; do
                pkg_entries[$j]=`sed -n ${i}p $updt_output`
                i=`expr $i + 1`
                j=`expr $j + 1`
            done
            ret=$_SUCCESS
        } || ret=$_FAIL
    }
    return $ret
}

declare newer_pkg_entries
declare newer_pkg_versions
declare newer_pkg_repos
getNewerList()
{
    local ret=0
    #exec_cmd_toFile "$SMART newer"
    $SMART newer > ${outputFile}_newer 2>&1
    local tmpPID=$pid
    ret=$?

    unset newer_pkg_entries
    unset newer_pkg_versions
    unset newer_pkg_repos

    [[ $ret -ne 0 ]] && return $ret || {

        local newerIndex_start
        local newerIndex_stop

        matchKeywordInFile ${outputFile}_newer "No interesting upgrades available"
        [[ $? -eq 0 ]] && ret=$_FAIL || {

            matchKeywordInFile ${outputFile}_newer 'Package Name' 'Installed' 'Upgrade' 'Channel' 'Size'
            newerIndex_start=`expr $keyword_lineNum + 2`
            newerIndex_stop=`cat ${outputFile}_newer | wc -l`

            [[ $newerIndex_start -lt $newerIndex_stop ]] && {
                local tmp_newerStr
                local i=$newerIndex_start
                local j=0

                while [[ $i -lt $newerIndex_stop ]]; do
                    tmp_newerStr=`sed -n ${i}p ${outputFile}_newer`
                    echo $tmp_newerStr | grep "\|" > /dev/null 2>&1
                    [[ $? -eq 0 ]] && {
                        field_len=`echo $tmp_newerStr | awk -F"|" '{print NF}'`
                        [[ $field_len -eq 5 ]] && {
                            newer_pkg_entries[$j]=`echo $tmp_newerStr | awk -F"|" '{print $1}'`
                            echo ${newer_pkg_entries[$j]} | grep "^${SYS_RPM_PKG}" > /dev/null 2>&1
                            [[ $? -eq 0 ]] && sys_rpm_upgradable=1
                            newer_pkg_versions[$j]=`echo $tmp_newerStr | awk -F"|" '{print $3}'`
                            newer_pkg_versions[$j]=`echo ${newer_pkg_versions[$j]} | awk '{print $1"@"$2}'`
                            newer_pkg_repos[$j]=`echo $tmp_newerStr | awk -F"|" '{print $4}'`
                            j=`expr $j + 1`
                        }
                        i=`expr $i + 1`
                    }
                done
                ret=$_SUCCESS
            } || ret=$_FAIL
        }
    }
#    [[ $verbose -ne 0 ]] && cat ${outputFile}_newer | sed -e '/^$/d'
    exec_cmd "rm -rf ${outputFile}_newer"
    return $ret
}

set_to_not_installed()
{
    local pkg="$1"
    local pkg_cnt=0

    exec_cmd_toStr_parser "$REPO_PARSER -p${pkg} -Q"
    pkg_cnt=$?
    tmp_output=$outputStr

    [[ $pkg_cnt -gt 0 ]] && {
        pkg_full_names=($tmp_output)
        for item in ${pkg_full_names[@]}; do
            exec_cmd_parser "$REPO_PARSER -n$item -f$_NOT_INSTALLED -F"
        done
    }
}

set_to_upgradable()
{
    getNewerList

    local tmpPKGList=(${newer_pkg_entries[@]})
    local tmpVerList=(${newer_pkg_versions[@]})

    [[ ${#tmpPKGList[@]} -eq ${#tmpVerList[@]} ]] && {
        [[ ${#tmpPKGList[@]} -gt 0 ]] && {
            local i=0
            while [[ i -lt ${#tmpPKGList[@]} ]]; do
                tmp_pkg=`echo ${tmpPKGList[$i]}-${tmpVerList[$i]} | sed 's/@/./'`
                exec_cmd_toStr_parser "$REPO_PARSER -p$tmp_pkg -Q"
                pkg_cnt=$?
                tmp_output=$outputStr
                [[ $pkg_cnt -gt 0 ]] && {
                    pkg_full_names=($tmp_output)
                    for item in ${pkg_full_names[@]}; do
                        exec_cmd_parser "$REPO_PARSER -n$item -f$_UPGRADABLE -F"
                    done
                }
                i=`expr $i + 1`
            done
        }
    }
}

set_to_reinstallable()
{
    file_name="$1"
    matchKeywordInFile $file_name "Fetching packages..."
    local line=$keyword_lineNum
    [[ $line -ne 0 ]] && {
        pkg_urls=`cat ${outputFile}${tmpPID} | grep "\->"| awk '{print $2}'`
        pkg_cnt=`cat ${outputFile}${tmpPID} | grep "\->"| awk '{print $2}' | wc -l`
        pkg_urls=(`echo $pkg_urls | sed -e 's/\\n/ /g'`)
        i=0
        while [[ $i -lt $pkg_cnt ]]; do
            pkg_full_name=`basename ${pkg_urls[$i]}`
            baseurl=`dirname ${pkg_urls[$i]}`
            echo $baseurl | grep '...' > /dev/null 2>&1
            [[ $? -eq 0 ]] && exec_cmd_parser "$REPO_PARSER -n$pkg_full_name -f$_REINSTALLABLE -F"  ||
            exec_cmd_parser "$REPO_PARSER -n$pkg_full_name -b$baseurl -f$_REINSTALLABLE -F"
            i=`expr $i + 1`
        done
    }
}

#install the default "system" rpm when upgradable or reinstallable flag is set.
install_system_rpm()
{
    [[ $flag_OnlineUpdt -eq 1 || $flag_OnlineUpdt -eq 2 || $flag_OnlineUpdt -eq 4 ]] && {
        [[ $sys_rpm_not_installed -eq 1 && $sys_rpm_upgradable -eq 0 ]] && {
            echo -n -e "${color_info}install rpm package \"$SYS_RPM_PKG\" by default ${color_off}"
            exec_cmd_toFile "$SMART install $SYS_RPM_PKG -y"
            local ret=$?
            local tmpPID=$pid
            [[ $ret -eq 0 ]] && {
                set_to_reinstallable ${outputFile}${tmpPID}
                echo -e "${color_ok} done${color_off}"
            } || echo -e "${color_fail} failed${color_off}"
    
            [[ $verbose -ne 0 ]] && cat ${outputFile}${tmpPID} | sed -e '/^$/d'
            exec_cmd "rm -rf ${outputFile}${tmpPID}"
        }
    }
}
