#!/bin/bash
# Use df to find the mount point of /, if the root device is a LVM volume then
# find out the physical device by walk thru all physical volume which match the
# volume group name. echo the partition 1 back to caller

# find the mount point of /
ROOTDEV=`df / | tail -1 | awk '{ print $1 }'`
LV_INFO=`sudo lvdisplay ${ROOTDEV} -c 2> /dev/null`
if [ ! -z $LV_INFO ]; then
  # find the volume group name
  IFS=':' read -a INFO <<< ${LV_INFO}
  ROOTDEV_VG_NAME=${INFO[1]}
  # use pvdisplay to print all available volume and save the names
  DEVS=`pvdisplay -m | grep "PV Name" | awk '{print $NF}'`
  # DEVS="/dev/sdb2 /dev/sda2"
  for i in $DEVS ; do
    VG_NAME=`pvdisplay $i -c | tail -1 | awk -F ':' '{print $2}'`
    if [ ${VG_NAME} == ${ROOTDEV_VG_NAME} ] ; then
      echo "${i%?}1"
    fi
  done
else
  # non LVM kernel upgrade
  # replace the last digit with 1, ie /dev/mmcblk0p1, /dev/sda1
  echo "${ROOTDEV%?}1"
fi
